package pl.org.inmost.acceptancetests.jwebunit;

import net.sourceforge.jwebunit.junit.WebTestCase;
import net.sourceforge.jwebunit.util.TestingEngineRegistry;

public class MerlinTest extends WebTestCase {
	public MerlinTest(String name) {
        super(name);
    }

    public void setUp() {
    	setTestingEngineKey(TestingEngineRegistry.TESTING_ENGINE_HTMLUNIT);
    	getTestContext().setBaseUrl("http://www.merlin.com.pl");
    }
    
    public void testFindHerbert(){
    	beginAt("/frontend/browse/home.html");
    	setWorkingForm("searchForm");
    	setFormElement("phrase", "Herbert");
    	submit();
    	assertTextPresent("89 wierszy");
    }
    
    public void testKoszyk(){
    	beginAt("/frontend/browse/product/1,118957.html");
    	clickLinkWithImage("ddk.gif");
    	clickLinkWithText("Koszyk i przechowalnia");
    	assertTextPresent("89 wierszy");
    }
}