package pl.org.inmost.acceptancetests.httpunit;

import java.io.IOException;
import java.net.MalformedURLException;

import junit.framework.TestCase;

import org.xml.sax.SAXException;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

public class WysylkowaTest extends TestCase {
	WebConversation wc = null;
	public WysylkowaTest(String name) {
        super(name);
    }

    public void setUp() {
    	wc = new WebConversation();
    	ClientProperties cp = wc.getClientProperties();
    	cp.setAutoRedirect(false);
    	cp.setAcceptGzip(false);
    	cp.setAcceptCookies(true);
    }
    
    public void testFindHerbert() throws MalformedURLException, IOException, SAXException {
    	 WebRequest req = new GetMethodWebRequest("http://www.wysylkowa.pl");
    	 WebResponse resp = wc.getResponse(req);
    	 WebForm form = resp.getFormWithName("szuk_main");
    	 form.setParameter("fraza", "Herbert");
    	 resp = form.submit();
    	 assertTrue(resp.getText().indexOf("Elzenberg") != -1);
    }
}