/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;

public class TestContext {
    private String user;
    private String passwd;
    private String domain;
    private List cookies;
    private boolean hasAuth = false;
    private boolean hasNTLMAuth = false;
    private Locale locale = Locale.getDefault();
    private String resourceBundleName;
    private URL baseUrl;
    private String userAgent;
    private Map requestHeaders = new HashMap();
    private String proxyUser = null;
    private String proxyPasswd = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private boolean hasProxyAuth = false;

    public TestContext() {
        this.cookies = new ArrayList();
        try {
            this.baseUrl = new URL("http://localhost:8080");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void clearAuthorizations() {
        this.hasAuth = false;
        this.hasNTLMAuth = false;
        this.hasProxyAuth = false;
    }

    public void setAuthorization(String user, String passwd) {
        this.user = user;
        this.passwd = passwd;
        this.hasAuth = true;
    }

    public void setNTLMAuthorization(String user, String passwd, String domain) {
        this.user = user;
        this.passwd = passwd;
        this.domain = domain;
        this.hasNTLMAuth = true;
    }

    public void setProxyAuthorization(String user, String passwd, String host, int port) {
        this.proxyUser = user;
        this.proxyPasswd = passwd;
        this.proxyHost = host;
        this.proxyPort = port;
        this.hasProxyAuth = true;
    }

    public void addCookie(String name, String value, String domain) {
        Cookie c = new Cookie(name, value);
        c.setDomain(domain);
        this.cookies.add(c);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean hasAuthorization() {
        return this.hasAuth;
    }

    public boolean hasNTLMAuthorization() {
        return this.hasNTLMAuth;
    }

    public boolean hasProxyAuthorization() {
        return this.hasProxyAuth;
    }

    public boolean hasCookies() {
        return this.cookies.size() > 0;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String getDomain() {
        return this.domain;
    }

    public List getCookies() {
        return this.cookies;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean hasUserAgent() {
        return this.userAgent != null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setResourceBundleName(String name) {
        this.resourceBundleName = name;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPasswd() {
        return this.proxyPasswd;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        try {
            this.baseUrl = new URL(url.endsWith("/") ? url : url + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders.remove(name);
    }

    public Map getRequestHeaders() {
        return this.requestHeaders;
    }

    public void clearRequestHeaders() {
        this.requestHeaders = new HashMap();
    }
}

