/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlPage
implements Page {
    private final String content_;
    private Document document_;
    private WebWindow enclosingWindow_;
    private final WebResponse webResponse_;

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow) throws IOException {
        this.webResponse_ = webResponse;
        this.content_ = webResponse.getContentAsString();
        this.enclosingWindow_ = enclosingWindow;
        try {
            this.document_ = XmlUtil.buildDocument(webResponse);
        }
        catch (SAXException e) {
            this.getLog().warn((Object)("Failed parsing xml document " + webResponse.getUrl() + ": " + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            this.getLog().warn((Object)("Failed parsing xml document " + webResponse.getUrl() + ": " + e.getMessage()));
        }
    }

    public void cleanUp() {
    }

    public String getContent() {
        return this.content_;
    }

    public WebWindow getEnclosingWindow() {
        return this.enclosingWindow_;
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public WebResponse getWebResponse() {
        return this.webResponse_;
    }

    public Document getXmlDocument() {
        return this.document_;
    }

    public void initialize() {
    }
}

