/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import java.net.MalformedURLException;
import java.net.URL;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static URL getUrlWithNewProtocol(URL u, String newProtocol) throws MalformedURLException {
        return UrlUtils.createNewUrl(newProtocol, u.getHost(), u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewHost(URL u, String newHost) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), newHost, u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPort(URL u, int newPort) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), newPort, u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPath(URL u, String newPath) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), newPath, u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewRef(URL u, String newRef) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), newRef, u.getQuery());
    }

    public static URL getUrlWithNewQuery(URL u, String newQuery) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), u.getRef(), newQuery);
    }

    private static URL createNewUrl(String protocol, String host, int port, String path, String ref, String query) throws MalformedURLException {
        StringBuffer s = new StringBuffer();
        s.append(protocol);
        s.append("://");
        s.append(host);
        if (port != -1) {
            s.append(":").append(port);
        }
        if (path != null && path.length() > 0) {
            if (!path.startsWith("/")) {
                s.append("/");
            }
            s.append(path);
        }
        if (query != null) {
            s.append("?").append(query);
        }
        if (ref != null) {
            s.append("#").append(ref);
        }
        URL url = new URL(s.toString());
        return url;
    }
}

