/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.ElementArray;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.JavaScriptBackgroundJob;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Popup;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class Window
extends SimpleScriptable {
    private static final long serialVersionUID = -7730298149962810325L;
    private Document document_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private Function onload_;
    private Object event_;
    private String status_ = "";
    private ElementArray frames_;
    private Map eventHandlers_ = new HashMap();

    public void jsConstructor() {
    }

    public void jsxFunction_alert(String message) {
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.alert(\"" + message + "\") no alert handler installed"));
        } else {
            handler.handleAlert(this.document_.getHtmlPage(), message);
        }
    }

    public boolean jsxFunction_confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button"));
            return true;
        }
        return handler.handleConfirm(this.document_.getHtmlPage(), message);
    }

    public String jsxFunction_prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.prompt(\"" + message + "\") no prompt handler installed"));
            return null;
        }
        return handler.handlePrompt(this.document_.getHtmlPage(), message);
    }

    public Document jsxGet_document() {
        return this.document_;
    }

    public Object jsxGet_event() {
        return this.event_;
    }

    public void setEvent(Object event) {
        this.event_ = event;
    }

    public static Object jsxFunction_open(Context context, Scriptable scriptable, Object[] args, Function function) {
        String url = Window.getStringArg(0, args, null);
        String windowName = Window.getStringArg(1, args, "");
        String features = Window.getStringArg(2, args, null);
        boolean replaceCurrentEntryInBrowsingHistory = Window.getBooleanArg(3, args, false);
        Window thisWindow = (Window)scriptable;
        if (features != null || replaceCurrentEntryInBrowsingHistory) {
            thisWindow.getLog().debug((Object)("Window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + url + "] windowName=[" + windowName + "] features=[" + features + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]"));
        }
        WebClient webClient = thisWindow.webWindow_.getWebClient();
        if (StringUtils.isEmpty((String)url) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return webWindow.getScriptObject();
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        URL newUrl = thisWindow.makeUrlForOpenWindow(url);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, thisWindow.webWindow_);
        return newWebWindow.getScriptObject();
    }

    public static Popup jsxFunction_createPopup(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Popup popup = (Popup)thisWindow.makeJavaScriptObject("Popup");
        popup.init(thisWindow.getWebWindow().getWebClient());
        return popup;
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.length() == 0) {
            if (this.getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                return WebClient.URL_ABOUT_BLANK;
            }
            return null;
        }
        try {
            Page page = this.webWindow_.getEnclosedPage();
            if (page != null && page instanceof HtmlPage) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to create url for openWindow: relativeUrl=[" + urlString + "]"), (Throwable)e);
            return null;
        }
    }

    private static JavaScriptBackgroundJob createJavaScriptBackgroundJob(Object codeToExec, int timeout, Window thisWindow, boolean loopForever) {
        if (codeToExec == null) {
            throw Context.reportRuntimeError((String)"Function not provided");
        }
        if (codeToExec instanceof String) {
            String scriptString = (String)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptString, loopForever);
        }
        if (codeToExec instanceof Function) {
            Function scriptFunction = (Function)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptFunction, loopForever);
        }
        throw Context.reportRuntimeError((String)"Unknown type for function");
    }

    public static int jsxFunction_setTimeout(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Object codeToExec = Window.getObjectArg(0, args, null);
        int timeout = Window.getIntArg(1, args, 0);
        JavaScriptBackgroundJob job = Window.createJavaScriptBackgroundJob(codeToExec, timeout, thisWindow, false);
        int id = thisWindow.getWebWindow().getThreadManager().startThread(job, "window.setTimeout");
        return id;
    }

    public void jsxFunction_clearTimeout(int timeoutId) {
        this.getWebWindow().getThreadManager().stopThread(timeoutId);
    }

    public Navigator jsxGet_navigator() {
        return this.navigator_;
    }

    public Window jsxGet_window() {
        return this;
    }

    public Window jsxGet_self() {
        return this;
    }

    public Location jsxGet_location() {
        return this.location_;
    }

    public void jsxSet_location(String newLocation) throws IOException {
        this.location_.jsxSet_href(newLocation);
    }

    public Screen jsxGet_screen() {
        return this.screen_;
    }

    public History jsxGet_history() {
        return this.history_;
    }

    public void initialize(WebWindow webWindow) throws Exception {
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptObject((Object)this);
        this.document_ = (Document)this.makeJavaScriptObject("Document");
        this.document_.setWindow(this);
        this.navigator_ = (Navigator)this.makeJavaScriptObject("Navigator");
        this.navigator_.setParentScope((Scriptable)this);
        this.screen_ = (Screen)this.makeJavaScriptObject("Screen");
        this.history_ = (History)this.makeJavaScriptObject("History");
        this.location_ = (Location)this.makeJavaScriptObject("Location");
        this.location_.initialize(this);
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            Assert.notNull("document_", (Object)this.document_);
            this.document_.setDomNode(htmlPage);
        } else {
            this.setInitialized();
        }
    }

    public void initialize() {
        this.setInitialized();
    }

    public SimpleScriptable jsxGet_top() {
        WebWindow topWebWindow = this.webWindow_.getTopWindow();
        return (SimpleScriptable)((Object)topWebWindow.getScriptObject());
    }

    public SimpleScriptable jsxGet_parent() {
        WebWindow parentWebWindow = this.webWindow_.getParentWindow();
        return (SimpleScriptable)((Object)parentWebWindow.getScriptObject());
    }

    public Object jsxGet_opener() {
        WebWindow opener;
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            return opener.getScriptObject();
        }
        return null;
    }

    public Object jsxGet_frameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptObject();
        }
        return null;
    }

    public ElementArray jsxGet_frames() {
        if (this.frames_ == null) {
            HtmlUnitXPath xpath;
            try {
                xpath = new HtmlUnitXPath("//*[(name() = 'frame' or name() = 'iframe')]");
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed initializing frame collections: " + e.getMessage()));
            }
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            Transformer toEnclosedWindow = new Transformer(){

                public Object transform(Object obj) {
                    return ((BaseFrame)obj).getEnclosedWindow();
                }
            };
            this.frames_.init(page, (XPath)xpath, toEnclosedWindow);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void jsxFunction_focus() {
        this.webWindow_.getWebClient().setCurrentWindow(this.webWindow_);
    }

    public void jsxFunction_blur() {
        this.getLog().debug((Object)"Window.blur() not implemented");
    }

    public void jsxFunction_close() {
        this.getWebWindow().getWebClient().deregisterWebWindow(this.getWebWindow());
    }

    public boolean jsxGet_closed() {
        return !this.getWebWindow().getWebClient().getWebWindows().contains(this.getWebWindow());
    }

    public void jsxFunction_moveTo(int x, int y) {
        this.getLog().debug((Object)"Window.moveTo() not implemented");
    }

    public void jsxFunction_moveBy(int x, int y) {
        this.getLog().debug((Object)"Window.moveBy() not implemented");
    }

    public void jsxFunction_resizeTo(int width, int height) {
        this.getLog().debug((Object)"Window.resizeTo() not implemented");
    }

    public void jsxFunction_scroll(int x, int y) {
        this.getLog().debug((Object)"Window.scroll() not implemented");
    }

    public void jsxFunction_scrollBy(int x, int y) {
        this.getLog().debug((Object)"Window.scrollBy() not implemented");
    }

    public void jsxFunction_scrollByLines(int lines) {
        this.getLog().debug((Object)"Window.scrollByLines() not implemented");
    }

    public void jsxFunction_scrollByPages(int pages) {
        this.getLog().debug((Object)"Window.scrollByPages() not implemented");
    }

    public void jsxFunction_scrollTo(int x, int y) {
        this.getLog().debug((Object)"Window.scrollTo() not implemented");
    }

    public void jsxSet_onload(Function newOnload) {
        this.onload_ = newOnload;
    }

    public Function jsxGet_onload() {
        if (this.onload_ == null) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            List<String> listTagNames = Arrays.asList("body", "frameset");
            List listElements = page.getDocumentElement().getHtmlElementsByTagNames(listTagNames);
            if (!listElements.isEmpty()) {
                return ((HtmlElement)listElements.get(0)).getEventHandler("onload");
            }
            return null;
        }
        return this.onload_;
    }

    public List getListeners(String type) {
        return (List)ObjectUtils.defaultIfNull(this.eventHandlers_.get(type), (Object)Collections.EMPTY_LIST);
    }

    protected boolean addEventListener(String type, Function listener, boolean useCapture) {
        Vector<Function> listeners = (Vector<Function>)this.eventHandlers_.get(type);
        if (listeners == null) {
            listeners = new Vector<Function>();
            this.eventHandlers_.put(type, listeners);
        }
        if (listeners.contains(listener)) {
            this.getLog().debug((Object)(type + " listener already registered, skipping it (" + listener + ")"));
            return false;
        }
        listeners.add(listener);
        return true;
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.addEventListener(StringUtils.substring((String)type, (int)2), listener, true);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.addEventListener(type, listener, useCapture);
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.removeEventListener(StringUtils.substring((String)type, (int)2), listener, true);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.removeEventListener(type, listener, useCapture);
    }

    protected void removeEventListener(String type, Function listener, boolean useCapture) {
        List listeners = (List)this.eventHandlers_.get(type);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public String jsxGet_name() {
        return this.webWindow_.getName();
    }

    public void jsxSet_name(String newName) {
        this.webWindow_.setName(newName);
    }

    public String jsxGet_onerror() {
        this.getLog().debug((Object)"Window.onerror not implemented");
        return "";
    }

    public void jsxSet_onerror(String newValue) {
        this.getLog().debug((Object)"Window.onerror not implemented");
    }

    public Object get(String name, Scriptable start) {
        DomNode domNode;
        HtmlPage htmlPage;
        if (this.getDomNodeOrNull() == null && this.document_ != null && (htmlPage = this.document_.getHtmlPageOrNull()) != null) {
            this.setDomNode(htmlPage);
        }
        Object result = super.get(name, start);
        Window thisWindow = (Window)start;
        if (result == NOT_FOUND && (domNode = thisWindow.getDomNodeOrNull()) != null) {
            result = this.getFrameByName(domNode.getPage(), name);
        }
        if (result == NOT_FOUND && (domNode = thisWindow.getDomNodeOrNull()) != null && domNode.getPage().getWebClient().getBrowserVersion().isIE()) {
            ElementArray array = (ElementArray)((Object)thisWindow.document_.jsxFunction_getElementsByName(name));
            result = array.jsGet_length() == 1 ? array.get(0, (Scriptable)array) : (array.jsGet_length() > 1 ? array : thisWindow.document_.jsxFunction_getElementById(name));
        }
        return result;
    }

    private Object getFrameByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    public Object jsxFunction_execScript(String script, String language) {
        if ("javascript".equalsIgnoreCase(language) || "jscript".equalsIgnoreCase(language)) {
            this.jsxFunction_eval(script);
        } else if ("vbscript".equalsIgnoreCase(language)) {
            this.getLog().warn((Object)"VBScript not supported in Window.execScript().");
        } else {
            throw Context.reportRuntimeError((String)"Invalid class string");
        }
        return null;
    }

    public Object jsxFunction_eval(String script) {
        HtmlPage htmlPage = this.document_.getHtmlPage();
        return htmlPage.executeJavaScriptIfPossible(script, "Window.eval()", false, null).getJavaScriptResult();
    }

    public String jsxGet_status() {
        return this.status_;
    }

    public void jsxSet_status(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    public static int jsxFunction_setInterval(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Object codeToExec = Window.getObjectArg(0, args, null);
        int timeout = Window.getIntArg(1, args, 0);
        JavaScriptBackgroundJob job = Window.createJavaScriptBackgroundJob(codeToExec, timeout, thisWindow, true);
        int id = thisWindow.getWebWindow().getThreadManager().startThread(job, "window.setInterval");
        return id;
    }

    public void jsxFunction_clearInterval(int intervalID) {
        this.getWebWindow().getThreadManager().stopThread(intervalID);
    }

    public int jsxGet_innerWidth() {
        return 1276;
    }

    public int jsxGet_outerWidth() {
        return 1276;
    }

    public int jsxGet_innerHeight() {
        return 778;
    }

    public int jsxGet_outerHeight() {
        return 936;
    }

    public void jsxFunction_print() {
        this.getLog().debug((Object)"window.print() not implemented");
    }
}

