/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Style
extends SimpleScriptable {
    private static final long serialVersionUID = -1976370264911039311L;
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private HTMLElement jsElement_;
    private static final String[] STYLE_PROPERTIES = new String[]{"backgroundColor", "bottom", "clear", "clip", "color", "direction", "display", "font", "fontFamily", "fontSize", "fontStyle", "fontWeight", "fontWeight", "hasLayout", "height", "layoutFlow", "layoutGrid", "layoutGridMode", "left", "letterSpacing", "lineHeight", "maxHeight", "maxWidth", "minHeight", "minWidth", "padding", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "pixelBottom", "pixelHeight", "pixelLeft", "pixelRight", "pixelTop", "pixelWidth", "posBottom", "posHeight", "position", "posLeft", "posRight", "posTop", "posWidth", "right", "styleFloat", "textAutospace", "textDecoration", "textDecorationBlink", "textDecorationLineThrough", "textDecorationNone", "textDecorationOverline", "textDecorationUnderline", "textTransform", "textUnderlinePosition", "top", "unicodeBidi", "visibility", "width", "wordSpacing", "wordWrap", "zoom"};
    private static final Set STYLE_ALLOWED_PROPERTIES;

    public Style() {
    }

    Style(HTMLElement htmlElement) {
        this.setParentScope(htmlElement.getParentScope());
        this.initialize(htmlElement);
    }

    void initialize(HTMLElement htmlElement) {
        Assert.notNull("htmlElement", (Object)htmlElement);
        this.jsElement_ = htmlElement;
        this.setDomNode(htmlElement.getDomNodeOrNull(), false);
        if (htmlElement.getHtmlElementOrDie().getPage().getWebClient().getBrowserVersion().isIE()) {
            Iterator i = this.getStyleMap().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (!"behavior".equals(key)) continue;
                String value = (String)entry.getValue();
                try {
                    Object[] url = URL_FORMAT.parse(value);
                    if (url.length <= 0) continue;
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                    break;
                }
                catch (ParseException e) {
                    this.getLog().warn((Object)("Invalid behavior: '" + value + "'."));
                }
            }
        }
    }

    public Object get(String name, Scriptable start) {
        Object result = STYLE_ALLOWED_PROPERTIES.contains(name) ? this.getStyleAttribute(name) : super.get(name, start);
        return result;
    }

    protected String getStyleAttribute(String name) {
        String value = (String)this.getStyleMap().get(name);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void put(String name, Scriptable start, Object newValue) {
        if (this.jsElement_ == null || !STYLE_ALLOWED_PROPERTIES.contains(name)) {
            super.put(name, start, newValue);
            return;
        }
        String styleValue = (String)Context.jsToJava((Object)newValue, (Class)String.class);
        this.setStyleAttribute(name, styleValue);
    }

    protected void setStyleAttribute(String name, String newValue) {
        Map styleMap = this.getStyleMap();
        styleMap.put(name, newValue);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = styleMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(" ");
            buffer.append(entry.getKey());
            buffer.append(": ");
            buffer.append(entry.getValue());
            buffer.append(";");
        }
        buffer.deleteCharAt(0);
        this.jsElement_.getHtmlElementOrDie().setAttributeValue("style", buffer.toString());
    }

    private Map getStyleMap() {
        TreeMap<String, String> styleMap = new TreeMap<String, String>();
        String styleAttribute = this.jsElement_.getHtmlElementOrDie().getAttributeValue("style");
        StringTokenizer tokenizer = new StringTokenizer(styleAttribute, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim();
            String value = token.substring(index + 1).trim();
            styleMap.put(key, value);
        }
        return styleMap;
    }

    public String jsxGet_behavior() {
        return this.getStyleAttribute("behavior");
    }

    public void jsxSet_behavior(String newValue) {
        this.setStyleAttribute("behavior", newValue);
    }

    static {
        HashSet set = new HashSet();
        CollectionUtils.addAll(set, (Object[])STYLE_PROPERTIES);
        STYLE_ALLOWED_PROPERTIES = Collections.unmodifiableSet(set);
    }
}

