/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class Location
extends SimpleScriptable {
    private static final long serialVersionUID = -2907220432378132233L;
    private static final String UNKNOWN = "null";
    private Window window_;

    public void initialize(Window window) {
        this.window_ = window;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || String.class.equals(hint)) {
            return this.jsxGet_href();
        }
        return super.getDefaultValue(hint);
    }

    public String toString() {
        if (this.window_ != null) {
            return this.jsxGet_href();
        }
        return "[Uninitialized]";
    }

    public void jsxFunction_assign(String url) throws IOException {
        this.jsxSet_href(url);
    }

    public void jsxFunction_reload(boolean force) throws IOException {
        String url = this.jsxGet_href();
        if (UNKNOWN.equals(url)) {
            this.getLog().error((Object)"Unable to reload location: current URL is unknown.");
        } else {
            this.jsxSet_href(url);
        }
    }

    public void jsxFunction_replace(String url) throws IOException {
        this.jsxSet_href(url);
    }

    public String jsxGet_href() {
        Page page = this.window_.getWebWindow().getEnclosedPage();
        if (page == null) {
            return UNKNOWN;
        }
        return page.getWebResponse().getUrl().toExternalForm();
    }

    public void jsxSet_href(String newLocation) throws IOException {
        HtmlPage page = (HtmlPage)Location.getWindow(this.getStartingScope()).getWebWindow().getEnclosedPage();
        if (newLocation.startsWith("javascript:")) {
            String script = newLocation.substring(11);
            page.executeJavaScriptIfPossible(script, "new location value", false, null);
        } else {
            try {
                URL url = page.getFullyQualifiedUrl(newLocation);
                WebWindow webWindow = this.getWindow().getWebWindow();
                webWindow.getWebClient().getPage(webWindow, new WebRequestSettings(url));
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("jsxSet_location(\"" + newLocation + "\") Got MalformedURLException"), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                this.getLog().error((Object)("jsxSet_location(\"" + newLocation + "\") Got IOException"), (Throwable)e);
                throw e;
            }
        }
    }

    public String jsxGet_search() {
        String search = this.getUrl().getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    public void jsxSet_search(String search) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), search));
    }

    public String jsxGet_hash() {
        String hash = this.getUrl().getRef();
        if (hash == null) {
            return "";
        }
        return hash;
    }

    public void jsxSet_hash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    public String jsxGet_hostname() {
        return this.getUrl().getHost();
    }

    public void jsxSet_hostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    public String jsxGet_host() {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    public void jsxSet_host(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url1 = UrlUtils.getUrlWithNewHost(this.getUrl(), hostname);
        URL url2 = UrlUtils.getUrlWithNewPort(url1, port);
        this.setUrl(url2);
    }

    public String jsxGet_pathname() {
        return this.getUrl().getPath();
    }

    public void jsxSet_pathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    public String jsxGet_port() {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return String.valueOf(port);
    }

    public void jsxSet_port(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    public String jsxGet_protocol() {
        return this.getUrl().getProtocol() + ":";
    }

    public void jsxSet_protocol(String protocol) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), protocol));
    }

    private URL getUrl() {
        return this.window_.getWebWindow().getEnclosedPage().getWebResponse().getUrl();
    }

    private void setUrl(URL url) throws IOException {
        this.window_.getWebWindow().getWebClient().getPage(this.window_.getWebWindow(), new WebRequestSettings(url));
    }
}

