/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowImpl;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.ElementArray;
import com.gargoylesoftware.htmlunit.javascript.host.Attribute;
import com.gargoylesoftware.htmlunit.javascript.host.NodeImpl;
import com.gargoylesoftware.htmlunit.javascript.host.Style;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLElement
extends NodeImpl {
    private static final long serialVersionUID = -6864034414262085851L;
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    private static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    private static final int BEHAVIOR_ID_HOMEPAGE = 1;
    private static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    static final String POSITION_BEFORE_BEGIN = "beforeBegin";
    static final String POSITION_AFTER_BEGIN = "afterBegin";
    static final String POSITION_BEFORE_END = "beforeEnd";
    static final String POSITION_AFTER_END = "afterEnd";
    private final Set behaviors_ = new HashSet();
    private ElementArray all_;
    private int scrollLeft_ = 0;
    private int scrollTop_ = 0;
    private static final List OUTER_HTML_READONLY = Arrays.asList("caption", "col", "colgroup", "frameset", "html", "tbody", "td", "tfoot", "th", "thead", "tr");
    private Style style_;

    public void jsConstructor() {
    }

    public ElementArray jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.all_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath(".//*"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection all: " + e.getMessage()));
            }
        }
        return this.all_;
    }

    public Object jsxGet_style() {
        return this.style_;
    }

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.style_ = new Style(this);
    }

    public String jsxGet_id() {
        return this.getHtmlElementOrDie().getId();
    }

    public void jsxSet_id(String newId) {
        this.getHtmlElementOrDie().setId(newId);
    }

    public boolean jsxGet_disabled() {
        return this.getHtmlElementOrDie().isAttributeDefined("disabled");
    }

    public void jsxSet_disabled(boolean disabled) {
        HtmlElement element = this.getHtmlElementOrDie();
        if (disabled) {
            element.setAttributeValue("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    public String jsxGet_tagName() {
        return this.getHtmlElementOrDie().getTagName().toUpperCase();
    }

    public Object jsxGet_ownerDocument() {
        return this.getWindow().jsxGet_document();
    }

    public Object get(String name, Scriptable start) {
        String value;
        HtmlElement htmlElement;
        Object result = super.get(name, start);
        if (result == NOT_FOUND && (htmlElement = this.getHtmlElementOrNull()) != null && name.toLowerCase().equals(name) && HtmlElement.ATTRIBUTE_NOT_DEFINED != (value = htmlElement.getAttributeValue(name))) {
            this.getLog().debug((Object)("Found attribute for evalution of property \"" + name + "\" for of " + start));
            result = value;
        }
        return result;
    }

    public String jsxFunction_getAttribute(String attributeName) {
        String value = this.getHtmlElementOrDie().getAttributeValue(attributeName);
        if (value == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            return null;
        }
        return value;
    }

    public void jsxFunction_setAttribute(String name, String value) {
        this.getHtmlElementOrDie().setAttributeValue(name, value);
    }

    public void jsxFunction_removeAttribute(String name) {
        this.getHtmlElementOrDie().removeAttribute(name);
    }

    public Object jsxFunction_getAttributeNode(String attributeName) {
        Attribute att = (Attribute)this.makeJavaScriptObject("Attribute");
        att.init(attributeName, this.getHtmlElementOrDie());
        return att;
    }

    public Attribute jsxFunction_setAttributeNode(Attribute newAtt) {
        String name = newAtt.jsxGet_name();
        String value = newAtt.jsxGet_value();
        Attribute replacedAtt = (Attribute)((Object)this.jsxFunction_getAttributeNode(name));
        replacedAtt.detachFromParent();
        this.getHtmlElementOrDie().setAttributeValue(name, value);
        return replacedAtt;
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HtmlElement element = (HtmlElement)this.getDomNodeOrDie();
        ElementArray collection = (ElementArray)this.makeJavaScriptObject("ElementArray");
        try {
            String xpath = "//" + tagName.toLowerCase();
            collection.init(element, (XPath)new HtmlUnitXPath(xpath, HtmlUnitXPath.buildSubtreeNavigator(element)));
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection getElementsByTagName(" + tagName + "): " + e.getMessage()));
        }
        return collection;
    }

    public Object jsxGet_className() {
        return this.getHtmlElementOrDie().getAttributeValue("class");
    }

    public void jsxSet_className(String className) {
        this.getHtmlElementOrDie().setAttributeValue("class", className);
    }

    public String jsxGet_innerHTML() {
        StringBuffer buf = new StringBuffer();
        this.printChildren(buf, this.getDomNodeOrDie());
        return buf.toString();
    }

    public String jsxGet_innerText() {
        StringBuffer buf = new StringBuffer();
        this.printChildren(buf, this.getDomNodeOrDie(), false);
        return buf.toString();
    }

    public String jsxGet_outerHTML() {
        StringBuffer buf = new StringBuffer();
        this.printNode(buf, this.getDomNodeOrDie());
        return buf.toString();
    }

    private void printChildren(StringBuffer buffer, DomNode node) {
        this.printChildren(buffer, node, true);
    }

    private void printChildren(StringBuffer buffer, DomNode node, boolean asInnerHTML) {
        Iterator iter = node.getChildIterator();
        while (iter.hasNext()) {
            this.printNode(buffer, (DomNode)iter.next(), asInnerHTML);
        }
    }

    private void printNode(StringBuffer buffer, DomNode node) {
        this.printNode(buffer, node, true);
    }

    private void printNode(StringBuffer buffer, DomNode node, boolean asInnerHTML) {
        if (node instanceof DomComment) {
            buffer.append("<!--" + node.getNodeValue().replaceAll("  ", " ") + "-->");
        } else if (node instanceof DomCharacterData) {
            buffer.append(node.getNodeValue().replaceAll("  ", " "));
        } else if (asInnerHTML) {
            HtmlElement htmlElt = (HtmlElement)node;
            buffer.append("<");
            buffer.append(htmlElt.getTagName());
            Iterator iterator = htmlElt.getAttributeEntriesIterator();
            while (iterator.hasNext()) {
                buffer.append(' ');
                Map.Entry entry = (Map.Entry)iterator.next();
                buffer.append(entry.getKey());
                buffer.append("=\"");
                buffer.append(entry.getValue());
                buffer.append("\"");
            }
            if (htmlElt.getFirstChild() == null) {
                buffer.append("/");
            }
            buffer.append(">");
            this.printChildren(buffer, node, asInnerHTML);
            if (htmlElt.getFirstChild() != null) {
                buffer.append("</");
                buffer.append(htmlElt.getTagName());
                buffer.append(">");
            }
        } else {
            HtmlElement htmlElement = (HtmlElement)node;
            if (htmlElement.getTagName().equals("p")) {
                buffer.append("\r\n");
            }
            if (!htmlElement.getTagName().equals("script")) {
                this.printChildren(buffer, node, asInnerHTML);
            }
        }
    }

    public void jsxSet_innerHTML(String value) {
        DomNode domNode = this.getDomNodeOrDie();
        domNode.removeAllChildren();
        Iterator iter = this.parseHtmlSnippet(value).iterator();
        while (iter.hasNext()) {
            DomNode child = (DomNode)iter.next();
            domNode.appendChild(child);
        }
    }

    public void jsxSet_innerText(String value) {
        DomNode domNode = this.getDomNodeOrDie();
        domNode.removeAllChildren();
        DomText node = new DomText(this.getDomNodeOrDie().getPage(), value);
        domNode.appendChild(node);
    }

    public void jsxSet_outerHTML(String value) {
        DomNode domNode = this.getDomNodeOrDie();
        if (OUTER_HTML_READONLY.contains(domNode.getNodeName())) {
            throw Context.reportRuntimeError((String)("outerHTML is read-only for tag " + domNode.getNodeName()));
        }
        Iterator iter = this.parseHtmlSnippet(value).iterator();
        while (iter.hasNext()) {
            DomNode child = (DomNode)iter.next();
            domNode.insertBefore(child);
        }
        domNode.remove();
    }

    private Collection parseHtmlSnippet(String htmlSnippet) {
        if (htmlSnippet.indexOf(60) >= 0) {
            WebClient webClient = this.getDomNodeOrDie().getPage().getWebClient();
            boolean jsEnabled = webClient.isJavaScriptEnabled();
            webClient.setJavaScriptEnabled(false);
            StringWebResponse webResp = new StringWebResponse("<html><body>" + htmlSnippet + "</body></html>", this.getDomNodeOrDie().getPage().getWebResponse().getUrl());
            try {
                WebWindowImpl pseudoWindow = new WebWindowImpl(webClient){

                    public WebWindow getParentWindow() {
                        return null;
                    }

                    public WebWindow getTopWindow() {
                        return null;
                    }

                    protected void performRegistration() {
                    }
                };
                HtmlPage pseudoPage = HTMLParser.parse(webResp, pseudoWindow);
                HtmlBody body = (HtmlBody)pseudoPage.getDocumentElement().getLastChild();
                ArrayList<DomNode> nodes = new ArrayList<DomNode>();
                Iterator iter = body.getChildIterator();
                while (iter.hasNext()) {
                    DomNode child = (DomNode)iter.next();
                    nodes.add(this.copy(child, this.getHtmlElementOrDie().getPage()));
                }
                ArrayList<DomNode> arrayList = nodes;
                return arrayList;
            }
            catch (Exception e) {
                this.getLog().error((Object)"Unexpected exception occured while parsing html snippet", (Throwable)e);
                throw Context.reportRuntimeError((String)("Unexpected exception occured while parsing html snippet: " + e.getMessage()));
            }
            finally {
                webClient.setJavaScriptEnabled(jsEnabled);
            }
        }
        DomText node = new DomText(this.getDomNodeOrDie().getPage(), htmlSnippet);
        return Collections.singleton(node);
    }

    private DomNode copy(DomNode node, HtmlPage page) {
        DomNode copy;
        if (node instanceof DomText) {
            copy = new DomText(page, node.getNodeValue());
        } else if (node instanceof DomComment) {
            copy = new DomComment(page, node.getNodeValue());
        } else {
            HtmlElement htmlElt = (HtmlElement)node;
            IElementFactory factory = HTMLParser.getFactory(htmlElt.getNodeName());
            copy = factory.createElement(page, node.getNodeName(), this.readAttributes(htmlElt));
            Iterator iter = node.getChildIterator();
            while (iter.hasNext()) {
                DomNode child = (DomNode)iter.next();
                copy.appendChild(this.copy(child, page));
            }
        }
        return copy;
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        Iterator iter = element.getAttributeEntriesIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    public void jsxFunction_insertAdjacentHTML(String where, String text) {
        boolean append;
        DomNode node;
        DomNode currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError((String)("Illegal position value: \"" + where + "\""));
        }
        Iterator iter = this.parseHtmlSnippet(text).iterator();
        while (iter.hasNext()) {
            DomNode child = (DomNode)iter.next();
            if (append) {
                node.appendChild(child);
                continue;
            }
            node.insertBefore(child);
        }
    }

    public int jsxFunction_addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            Class<?> c = ((Object)((Object)this)).getClass();
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            Class<?> c = ((Object)((Object)this)).getClass();
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            Class<?> c = ((Object)((Object)this)).getClass();
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        this.getLog().warn((Object)("Unimplemented behavior: " + behavior));
        return -1;
    }

    public void jsxFunction_removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                this.getLog().warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_availHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_availWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_bufferDepth();
    }

    public int getColorDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_colorDepth();
    }

    public String getConnectionType() {
        return "modem";
    }

    public boolean getCookieEnabled() {
        return this.getWindow().jsxGet_navigator().jsxGet_cookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().jsxGet_navigator().jsxGet_cpuClass();
    }

    public int getHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_height();
    }

    public boolean getJavaEnabled() {
        return this.getWindow().jsxGet_navigator().jsxFunction_javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().jsxGet_navigator().jsxGet_platform();
    }

    public String getSystemLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_systemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_userLanguage();
    }

    public int getWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_width();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        this.getLog().debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
    }

    public void clearComponentRequest() {
        this.getLog().debug((Object)"Call to clearComponentRequest() ignored.");
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getWebResponse().getUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        DownloadBehaviorDownloader t = new DownloadBehaviorDownloader(url, callback);
        this.getLog().debug((Object)("Starting download thread for " + url));
        t.start();
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getWebResponse().getUrl();
            String home = this.getDomNodeOrDie().getPage().getWebClient().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getWebClient().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getWebClient();
        webClient.getPage(new URL(webClient.getHomePage()));
    }

    public void jsxSet_onclick(Function onclick) {
        this.getHtmlElementOrDie().setEventHandler("onclick", onclick);
    }

    public Function jsxGet_onclick() {
        return this.getHtmlElementOrDie().getEventHandler("onclick");
    }

    public Object jsxGet_children() {
        DomNode element = this.getDomNodeOrDie();
        ElementArray children = (ElementArray)this.makeJavaScriptObject("ElementArray");
        try {
            HtmlUnitXPath xpath = new HtmlUnitXPath("./*", HtmlUnitXPath.buildSubtreeNavigator(element));
            children.init(element, (XPath)xpath);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed initializing children: " + e.getMessage()));
        }
        return children;
    }

    public void jsxSet_ondblclick(Function ondblclick) {
        this.getHtmlElementOrDie().setEventHandler("ondblclick", ondblclick);
    }

    public Function jsxGet_ondblclick() {
        return this.getHtmlElementOrDie().getEventHandler("ondblclick");
    }

    public void jsxSet_onblur(Function onblur) {
        this.getHtmlElementOrDie().setEventHandler("onblur", onblur);
    }

    public Function jsxGet_onblur() {
        return this.getHtmlElementOrDie().getEventHandler("onblur");
    }

    public void jsxSet_onfocus(Function onfocus) {
        this.getHtmlElementOrDie().setEventHandler("onfocus", onfocus);
    }

    public Function jsxGet_onfocus() {
        return this.getHtmlElementOrDie().getEventHandler("onfocus");
    }

    public void jsxSet_onkeydown(Function onkeydown) {
        this.getHtmlElementOrDie().setEventHandler("onkeydown", onkeydown);
    }

    public Function jsxGet_onkeydown() {
        return this.getHtmlElementOrDie().getEventHandler("onkeydown");
    }

    public void jsxSet_onkeypress(Function onkeypress) {
        this.getHtmlElementOrDie().setEventHandler("onkeypress", onkeypress);
    }

    public Function jsxGet_onkeypress() {
        return this.getHtmlElementOrDie().getEventHandler("onkeypress");
    }

    public void jsxSet_onkeyup(Function onkeyup) {
        this.getHtmlElementOrDie().setEventHandler("onkeyup", onkeyup);
    }

    public Function jsxGet_onkeyup() {
        return this.getHtmlElementOrDie().getEventHandler("onkeyup");
    }

    public void jsxSet_onmousedown(Function onmousedown) {
        this.getHtmlElementOrDie().setEventHandler("onmousedown", onmousedown);
    }

    public Function jsxGet_onmousedown() {
        return this.getHtmlElementOrDie().getEventHandler("onmousedown");
    }

    public void jsxSet_onmousemove(Function onmousemove) {
        this.getHtmlElementOrDie().setEventHandler("onmousemove", onmousemove);
    }

    public Function jsxGet_onmousemove() {
        return this.getHtmlElementOrDie().getEventHandler("onmousemove");
    }

    public void jsxSet_onmouseout(Function onmouseout) {
        this.getHtmlElementOrDie().setEventHandler("onmouseout", onmouseout);
    }

    public Function jsxGet_onmouseout() {
        return this.getHtmlElementOrDie().getEventHandler("onmouseout");
    }

    public void jsxSet_onmouseover(Function onmouseover) {
        this.getHtmlElementOrDie().setEventHandler("onmouseover", onmouseover);
    }

    public Function jsxGet_onmouseover() {
        return this.getHtmlElementOrDie().getEventHandler("onmouseover");
    }

    public void jsxSet_onmouseup(Function onmouseup) {
        this.getHtmlElementOrDie().setEventHandler("onmouseup", onmouseup);
    }

    public Function jsxGet_onmouseup() {
        return this.getHtmlElementOrDie().getEventHandler("onmouseup");
    }

    public void jsxSet_onresize(Function onresize) {
        this.getHtmlElementOrDie().setEventHandler("onresize", onresize);
    }

    public Function jsxGet_onresize() {
        return this.getHtmlElementOrDie().getEventHandler("onresize");
    }

    public int jsxGet_offsetHeight() {
        return 1;
    }

    public int jsxGet_offsetWidth() {
        return 1;
    }

    public int jsxGet_offsetLeft() {
        return 1;
    }

    public int jsxGet_offsetTop() {
        return 1;
    }

    public Object jsxGet_offsetParent() {
        Object offsetParent = null;
        for (DomNode currentElement = this.getHtmlElementOrDie(); currentElement != null; currentElement = currentElement.getParentNode()) {
            DomNode parentNode = currentElement.getParentNode();
            if (!(parentNode instanceof HtmlTableDataCell) && !(parentNode instanceof HtmlTable) && !(parentNode instanceof HtmlBody)) continue;
            offsetParent = parentNode.getScriptObject();
            break;
        }
        return offsetParent;
    }

    public String toString() {
        return "HTMLElement for " + this.getHtmlElementOrNull();
    }

    public int jsxGet_scrollTop() {
        return this.scrollTop_;
    }

    public void jsxSet_scrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    public int jsxGet_scrollLeft() {
        return this.scrollLeft_;
    }

    public void jsxSet_scrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    public int jsxGet_scrollHeight() {
        return 10;
    }

    public int jsxGet_scrollWidth() {
        return 10;
    }

    private class DownloadBehaviorDownloader
    extends Thread {
        private final URL url_;
        private final Function callback_;
        private Context context_;

        public DownloadBehaviorDownloader(URL url, Function callback) {
            super("Downloader for behavior #default#download '" + url + "'");
            this.url_ = url;
            this.callback_ = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.context_ = Context.enter();
            try {
                WebClient wc = HTMLElement.this.getWindow().getWebWindow().getWebClient();
                String content = wc.getPage(this.url_).getWebResponse().getContentAsString();
                String message = "Downloaded content: ";
                message = content.length() > 512 ? message + content.substring(512) + " ..." : message + content;
                HTMLElement.this.getLog().debug((Object)message);
                Scriptable scope = this.callback_.getParentScope();
                Object[] args = new Object[]{content};
                this.callback_.call(this.context_, scope, scope, args);
            }
            catch (Exception e) {
                HTMLElement.this.getLog().error((Object)("Behavior #default#download: Cannot download " + this.url_), (Throwable)e);
            }
            finally {
                Context.exit();
            }
        }
    }
}

