/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.xpath.FunctionContextWrapper;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import com.gargoylesoftware.htmlunit.javascript.ElementArray;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attribute;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.NodeImpl;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.UniqueTag;

public final class Document
extends NodeImpl {
    private static final long serialVersionUID = -7646789903352066465L;
    private ElementArray all_;
    private ElementArray forms_;
    private ElementArray links_;
    private ElementArray images_;
    private ElementArray scripts_;
    private ElementArray anchors_;
    private final StringBuffer writeBuffer_ = new StringBuffer();
    private boolean writeInCurrentDocument_ = true;
    private String domain_;
    private Window window_;
    private final FunctionContextWrapper functionContext_ = new FunctionContextWrapper(XPathFunctionContext.getInstance());

    public Document() {
        this.functionContext_.registerFunction("lower-case", new LowerCaseFunction());
    }

    public void jsConstructor() {
    }

    void setWindow(Window window) {
        this.window_ = window;
    }

    public HtmlPage getHtmlPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    public HtmlPage getHtmlPageOrNull() {
        return (HtmlPage)this.getDomNodeOrNull();
    }

    public Object jsxGet_forms() {
        if (this.forms_ == null) {
            this.forms_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.forms_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath("//form"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.forms: " + e.getMessage()));
            }
        }
        return this.forms_;
    }

    public Object jsxGet_links() {
        if (this.links_ == null) {
            this.links_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.links_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath("//a[@href] | //area[@href]"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.links: " + e.getMessage()));
            }
        }
        return this.links_;
    }

    public Object jsxGet_anchors() {
        if (this.anchors_ == null) {
            this.anchors_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                String xpath = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE() ? "//a[@name or @id]" : "//a[@name]";
                this.anchors_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath(xpath));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.anchors: " + e.getMessage()));
            }
        }
        return this.anchors_;
    }

    public static void jsxFunction_write(Context context, Scriptable scriptable, Object[] args, Function function) {
        ((Document)scriptable).write(Document.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(Context.toString((Object)args[i]));
        }
        return buffer.toString();
    }

    public static void jsxFunction_writeln(Context context, Scriptable scriptable, Object[] args, Function function) {
        ((Document)scriptable).write(Document.concatArgsAsString(args) + "\n");
    }

    protected void write(String content) {
        this.getLog().debug((Object)("write: " + content));
        this.writeBuffer_.append(content);
        if (!this.writeInCurrentDocument_) {
            this.getLog().debug((Object)"written content added to buffer");
        } else {
            String bufferedContent = this.writeBuffer_.toString();
            if (this.canAlreadyBeParsed(bufferedContent)) {
                this.writeBuffer_.setLength(0);
                this.getLog().debug((Object)("parsing buffered content: " + bufferedContent));
                HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
                HtmlElement current = this.getLastHtmlElement(page.getDocumentElement());
                this.getLog().debug((Object)("current: " + current));
                if (current instanceof HtmlInlineFrame) {
                    current = (HtmlElement)current.getParentNode();
                }
                ((HTMLElement)((Object)this.getJavaScriptNode(current))).jsxFunction_insertAdjacentHTML("beforeEnd", bufferedContent);
            } else {
                this.getLog().debug((Object)"write: not enough content to parsed it now");
            }
        }
    }

    private boolean canAlreadyBeParsed(String content) {
        boolean tagOutside = false;
        boolean tagSart = true;
        int tagInName = 2;
        int tagInside = 3;
        int tagState = 0;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        block6: for (int index = 0; index < content.length(); ++index) {
            char currentChar = content.charAt(index);
            switch (tagState) {
                case 0: {
                    if (currentChar != '<') continue block6;
                    tagState = 1;
                    tagIsOpen = true;
                    continue block6;
                }
                case 1: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = 2;
                    continue block6;
                }
                case 2: {
                    if (Character.isLetter(currentChar)) continue block6;
                    String tagName = content.substring(tagNameBeginIndex, index);
                    if (tagName.equalsIgnoreCase("script")) {
                        if (tagIsOpen) {
                            ++scriptTagCount;
                        } else if (scriptTagCount > 0) {
                            --scriptTagCount;
                        }
                    }
                    if (currentChar == '>') {
                        tagState = 0;
                        continue block6;
                    }
                    tagState = 3;
                    continue block6;
                }
                case 3: {
                    if (currentChar != '>') continue block6;
                    tagState = 0;
                    continue block6;
                }
            }
        }
        return scriptTagCount <= 0 && tagState == 0;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    public String jsxGet_cookie() {
        HtmlPage page = this.getHtmlPage();
        HttpState state = page.getWebClient().getWebConnection().getState();
        URL url = page.getWebResponse().getUrl();
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        Cookie[] cookies = CookiePolicy.getDefaultSpec().match(url.getHost(), port, url.getPath(), secure, state.getCookies());
        if (cookies == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            if (i != 0) {
                buffer.append(";");
            }
            buffer.append(cookies[i].getName());
            buffer.append("=");
            buffer.append(cookies[i].getValue());
        }
        return buffer.toString();
    }

    public void jsxSet_cookie(String newCookie) {
        HttpState state = this.getHtmlPage().getWebClient().getWebConnection().getState();
        Cookie cookie = Document.buildCookie(newCookie, this.getHtmlPage().getWebResponse().getUrl());
        state.addCookie(cookie);
        this.getLog().info((Object)("Added cookie: " + cookie));
    }

    static Cookie buildCookie(String newCookie, URL currentURL) {
        StringTokenizer st = new StringTokenizer(newCookie, ";");
        String nameValue = st.nextToken();
        String name = StringUtils.substringBefore((String)nameValue, (String)"=").trim();
        String value = StringUtils.substringAfter((String)nameValue, (String)"=").trim();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("domain", currentURL.getHost());
        attributes.put("path", "");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexEqual = token.indexOf("=");
            if (indexEqual > -1) {
                attributes.put(token.substring(0, indexEqual).toLowerCase().trim(), token.substring(indexEqual + 1).trim());
                continue;
            }
            attributes.put(token.toLowerCase().trim(), Boolean.TRUE);
        }
        Date expires = null;
        String date = (String)attributes.get("expires");
        if (date != null) {
            try {
                expires = DateUtil.parseDate((String)date);
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        String domain = (String)attributes.get("domain");
        String path = (String)attributes.get("path");
        boolean secure = attributes.get("secure") != null;
        Cookie cookie = new Cookie(domain, name, value, path, expires, secure);
        return cookie;
    }

    public Location jsxGet_location() {
        return this.window_.jsxGet_location();
    }

    public void jsxSet_location(String location) throws IOException {
        this.window_.jsxSet_location(location);
    }

    public Object jsxGet_images() {
        if (this.images_ == null) {
            this.images_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.images_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath("//img"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.images: " + e.getMessage()));
            }
        }
        return this.images_;
    }

    public String jsxGet_referrer() {
        String referrer = this.getHtmlPage().getWebResponse().getResponseHeaderValue("referrer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public String jsxGet_URL() {
        return this.getHtmlPage().getWebResponse().getUrl().toExternalForm();
    }

    public ElementArray jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.all_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath("//*"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.all: " + e.getMessage()));
            }
        }
        return this.all_;
    }

    public static Object jsxFunction_open(Context context, Scriptable scriptable, Object[] args, Function function) {
        Document document = (Document)scriptable;
        if (!document.writeInCurrentDocument_) {
            document.getLog().warn((Object)"open() called when document is already open.");
        }
        document.writeInCurrentDocument_ = false;
        return null;
    }

    public void jsxFunction_close() throws IOException {
        if (this.writeInCurrentDocument_) {
            this.getLog().warn((Object)"close() called when document is not open.");
        } else {
            StringWebResponse webResponse = new StringWebResponse(this.writeBuffer_.toString());
            HtmlPage page = this.getDomNodeOrDie().getPage();
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
            this.writeInCurrentDocument_ = true;
            this.writeBuffer_.setLength(0);
        }
    }

    public Object jsxGet_documentElement() {
        return this.getScriptableFor(((HtmlPage)this.getDomNodeOrDie()).getDocumentElement());
    }

    public Object jsxGet_defaultView() {
        return this.getWindow();
    }

    public Object jsxGet_parentWindow() {
        return this.getWindow();
    }

    public Object jsxFunction_createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            HtmlElement htmlElement = this.getDomNodeOrDie().getPage().createElement(tagName);
            SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Attribute jsxFunction_createAttribute(String attributeName) {
        Attribute att = (Attribute)this.makeJavaScriptObject("Attribute");
        att.init(attributeName, null);
        return att;
    }

    public Object jsxFunction_createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a javascript object for the DOM node " + domNode.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_getElementById(String id) {
        Object result = null;
        try {
            HtmlElement htmlElement = ((HtmlPage)this.getDomNodeOrDie()).getDocumentElement().getHtmlElementById(id);
            SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException e) {
            BrowserVersion browser = this.getHtmlPage().getWebClient().getBrowserVersion();
            if (browser.isIE()) {
                ElementArray elements = (ElementArray)((Object)this.jsxFunction_getElementsByName(id));
                result = elements.get(0, (Scriptable)elements);
                if (result instanceof UniqueTag) {
                    return null;
                }
                this.getLog().warn((Object)("getElementById(" + id + ") did a getElementByName for Internet Explorer"));
                return result;
            }
            this.getLog().debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
        }
        return result;
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        ElementArray collection = (ElementArray)this.makeJavaScriptObject("ElementArray");
        try {
            HtmlUnitXPath xpath = new HtmlUnitXPath("//*[lower-case(name()) = '" + tagName.toLowerCase() + "']");
            xpath.setFunctionContext(this.functionContext_);
            collection.init(this.getHtmlPage(), (XPath)xpath);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection document.getElementsByTagName: " + e.getMessage()));
        }
        return collection;
    }

    public Object jsxFunction_getElementsByName(String elementName) {
        ElementArray collection = (ElementArray)this.makeJavaScriptObject("ElementArray");
        String exp = "//*[@name='" + elementName + "']";
        try {
            HtmlUnitXPath xpath = new HtmlUnitXPath(exp);
            collection.init(this.getHtmlPage(), (XPath)xpath);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection document.getElementsByName: " + e.getMessage()));
        }
        return collection;
    }

    public Object get(String name, Scriptable start) {
        HtmlPage htmlPage = (HtmlPage)this.getDomNodeOrNull();
        if (htmlPage == null) {
            return super.get(name, start);
        }
        ElementArray collection = (ElementArray)this.makeJavaScriptObject("ElementArray");
        String xpathExpr = "//*[(@name = '" + name + "' and (name() = 'img' or name() = 'form'))]";
        try {
            collection.init(htmlPage, (XPath)new HtmlUnitXPath(xpathExpr));
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection (using xpath " + xpathExpr + "): " + e.getMessage()));
        }
        int size = collection.jsGet_length();
        if (size == 1) {
            return collection.get(0, (Scriptable)collection);
        }
        if (size > 1) {
            return collection;
        }
        return super.get(name, start);
    }

    public Object jsxGet_body() {
        List<String> tagNames = Arrays.asList("body", "frameset");
        List list = this.getHtmlPage().getDocumentElement().getHtmlElementsByTagNames(tagNames);
        if (list.size() == 0) {
            return NOT_FOUND;
        }
        DomNode bodyElement = (DomNode)list.get(0);
        return this.getScriptableFor(bodyElement);
    }

    public String jsxGet_title() {
        return this.getHtmlPage().getTitleText();
    }

    public void jsxSet_title(String message) {
        this.getHtmlPage().setTitleText(message);
    }

    public String jsxGet_readyState() {
        DomNode node = this.getDomNodeOrDie();
        if (node instanceof HtmlPage) {
            return ((HtmlPage)node).getDocumentElement().getReadyState();
        }
        return this.getDomNodeOrDie().getReadyState();
    }

    public String jsxGet_domain() {
        if (this.domain_ == null) {
            this.domain_ = this.getHtmlPage().getWebResponse().getUrl().getHost();
            BrowserVersion browser = this.getHtmlPage().getWebClient().getBrowserVersion();
            if (browser.isNetscape()) {
                this.domain_ = this.domain_.toLowerCase();
            }
        }
        return this.domain_;
    }

    public void jsxSet_domain(String newDomain) {
        String currentDomain = this.jsxGet_domain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(".") == -1 || !currentDomain.toLowerCase().endsWith("." + newDomain.toLowerCase())) {
            throw Context.reportRuntimeError((String)("Illegal domain value, can not set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = this.getHtmlPage().getWebClient().getBrowserVersion().isNetscape() ? newDomain.toLowerCase() : newDomain;
    }

    public Object jsxGet_scripts() {
        if (this.scripts_ == null) {
            this.scripts_ = (ElementArray)this.makeJavaScriptObject("ElementArray");
            try {
                this.scripts_.init(this.getHtmlPage(), (XPath)new HtmlUnitXPath("//script"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.scripts: " + e.getMessage()));
            }
        }
        return this.scripts_;
    }

    public Object jsxGet_frames() {
        return this.getWindow().jsxGet_frames();
    }
}

