/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.XMLHttpRequest;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;

public class ActiveXObject
extends SimpleScriptable {
    private static final long serialVersionUID = 7327032075131452226L;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter must be a String.");
        }
        String activeXName = (String)args[0];
        if (ActiveXObject.isXMLHttpRequest((String)args[0])) {
            return ActiveXObject.buildXMLHTTPActiveX();
        }
        Map map = ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow().getWebClient().getActiveXObjectMap();
        if (map == null) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: the map is null.");
        }
        Object mapValue = map.get(activeXName);
        if (mapValue == null) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: no value for " + activeXName + "."));
        }
        if (!(mapValue instanceof String)) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: value for " + activeXName + " is not a String."));
        }
        String xClassString = (String)mapValue;
        Object object = null;
        try {
            Class<?> xClass = Class.forName(xClassString);
            object = xClass.newInstance();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + "."));
        }
        return Context.toObject(object, (Scriptable)ctorObj);
    }

    static boolean isXMLHttpRequest(String name) {
        return name != null && ("Microsoft.XMLHTTP".equals(name) || name.startsWith("Msxml2.XMLHTTP"));
    }

    private static Scriptable buildXMLHTTPActiveX() {
        XMLHttpRequest resp = new XMLHttpRequest();
        ActiveXObject.addProperty(resp, "onreadystatechange", "jsxGet_onreadystatechange", "jsxSet_onreadystatechange");
        ActiveXObject.addProperty(resp, "readyState", "jsxGet_readyState", null);
        ActiveXObject.addProperty(resp, "responseText", "jsxGet_responseText", null);
        ActiveXObject.addProperty(resp, "responseXML", "jsxGet_responseXML", null);
        ActiveXObject.addProperty(resp, "status", "jsxGet_status", null);
        ActiveXObject.addProperty(resp, "statusText", "jsxGet_statusText", null);
        ActiveXObject.addFunction(resp, "abort", "jsxFunction_abort");
        ActiveXObject.addFunction(resp, "abort", "jsxFunction_abort");
        ActiveXObject.addFunction(resp, "getAllResponseHeaders", "jsxFunction_getAllResponseHeaders");
        ActiveXObject.addFunction(resp, "getResponseHeader", "jsxFunction_getResponseHeader");
        ActiveXObject.addFunction(resp, "open", "jsxFunction_open");
        ActiveXObject.addFunction(resp, "send", "jsxFunction_send");
        ActiveXObject.addFunction(resp, "setRequestHeader", "jsxFunction_setRequestHeader");
        return resp;
    }

    private static void addFunction(SimpleScriptable scriptable, String jsMethodName, String javaMethodName) {
        Method javaFunction = ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), javaMethodName);
        FunctionObject fo = new FunctionObject(null, (Member)javaFunction, (Scriptable)scriptable);
        scriptable.defineProperty(jsMethodName, fo, 1);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, String getterName, String setterName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), getterName), ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), setterName), 4);
    }

    static Method getMethod(Class clazz, String name) {
        if (name == null) {
            return null;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    public String getClassName() {
        return "ActiveXObject";
    }
}

