/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorHandler;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class JavaScriptConfiguration {
    private static Document XmlDocument_;
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int NOT_FOUND = 3;
    private static Map ConfigurationMap_;
    private static HashMap ClassnameMap_;
    private static Map HtmlJavaScriptMap_;
    private final Map configuration_;
    private final BrowserVersion browser_;

    private JavaScriptConfiguration(BrowserVersion browser) {
        this.browser_ = browser;
        if (XmlDocument_ == null) {
            JavaScriptConfiguration.loadConfiguration();
        }
        if (XmlDocument_ == null) {
            throw new IllegalStateException("Configuration was not initialized - see log for details");
        }
        this.configuration_ = this.buildUsageMap(browser);
    }

    protected static boolean isDocumentLoaded() {
        return XmlDocument_ != null;
    }

    protected static void resetClassForTesting() {
        XmlDocument_ = null;
        ConfigurationMap_ = new HashMap(11);
    }

    protected static void setXmlDocument(Document document) {
        XmlDocument_ = document;
    }

    protected static void loadConfiguration() {
        try {
            Reader reader = JavaScriptConfiguration.getConfigurationFileAsReader();
            if (reader == null) {
                JavaScriptConfiguration.getLog().error((Object)"Unable to load JavaScriptConfiguration.xml");
            }
            JavaScriptConfiguration.loadConfiguration(reader);
            reader.close();
        }
        catch (Exception e) {
            JavaScriptConfiguration.getLog().error((Object)"Error when loading JavascriptConfiguration.xml", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected static void loadConfiguration(Reader configurationReader) {
        InputSource inputSource = new InputSource(configurationReader);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new StrictErrorHandler());
            XmlDocument_ = documentBuilder.parse(inputSource);
        }
        catch (SAXParseException parseException) {
            JavaScriptConfiguration.getLog().error((Object)("line=[" + parseException.getLineNumber() + "] columnNumber=[" + parseException.getColumnNumber() + "] systemId=[" + parseException.getSystemId() + "] publicId=[" + parseException.getPublicId() + "]"), (Throwable)parseException);
        }
        catch (Exception e) {
            JavaScriptConfiguration.getLog().error((Object)"Error when loading JavascriptConfiguration.xml", (Throwable)e);
        }
    }

    public static synchronized JavaScriptConfiguration getInstance(BrowserVersion browserVersion) {
        if (browserVersion == null) {
            throw new IllegalStateException("BrowserVersion must be defined");
        }
        JavaScriptConfiguration configuration = (JavaScriptConfiguration)ConfigurationMap_.get(browserVersion);
        if (configuration == null) {
            configuration = new JavaScriptConfiguration(browserVersion);
            ConfigurationMap_.put(browserVersion, configuration);
        }
        return configuration;
    }

    static JavaScriptConfiguration getAllEntries() {
        JavaScriptConfiguration configuration = new JavaScriptConfiguration(null);
        return configuration;
    }

    private static Log getLog() {
        return LogFactory.getLog((Class)JavaScriptConfiguration.class);
    }

    private static Reader getConfigurationFileAsReader() {
        String fileName = "/com/gargoylesoftware/htmlunit/javascript/configuration/JavaScriptConfiguration.xml";
        return new InputStreamReader(JavaScriptConfiguration.getResourceAsStream("/com/gargoylesoftware/htmlunit/javascript/configuration/JavaScriptConfiguration.xml"));
    }

    private static InputStream getResourceAsStream(String name) {
        String localizedName;
        Assert.notNull("name", name);
        InputStream inputStream = JavaScriptConfiguration.class.getResourceAsStream(name);
        if (inputStream == null) {
            try {
                localizedName = name.replace('/', File.separatorChar);
                inputStream = new FileInputStream(localizedName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                localizedName = ("./src/java" + name).replace('/', File.separatorChar);
                inputStream = new FileInputStream(localizedName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public Set keySet() {
        return this.configuration_.keySet();
    }

    private Map buildUsageMap(BrowserVersion browser) {
        HashMap<String, ClassConfiguration> classMap = new HashMap<String, ClassConfiguration>(30);
        for (Node node = XmlDocument_.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals("class")) continue;
            String className = element.getAttribute("name");
            if (this.testToExcludeElement(element)) continue;
            try {
                ClassConfiguration classConfiguration = this.parseClassElement(className, element);
                if (classConfiguration == null) continue;
                classMap.put(className, classConfiguration);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class was not found for '" + className + "'");
            }
        }
        return Collections.unmodifiableMap(classMap);
    }

    private ClassConfiguration parseClassElement(String className, Element element) throws ClassNotFoundException {
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return null;
        }
        String linkedClassname = element.getAttribute("classname");
        String superclassName = element.getAttribute("extends");
        String htmlClassname = element.getAttribute("htmlClass");
        boolean jsObjectFlag = false;
        String jsObjectStr = element.getAttribute("JSObject");
        if ("true".equalsIgnoreCase(jsObjectStr)) {
            jsObjectFlag = true;
        }
        ClassConfiguration classConfiguration = new ClassConfiguration(className, linkedClassname, superclassName, htmlClassname, jsObjectFlag);
        ClassnameMap_.put(linkedClassname, className);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tagName = childElement.getTagName();
            if (tagName.equals("property")) {
                this.parsePropertyElement(classConfiguration, childElement);
                continue;
            }
            if (tagName.equals("function")) {
                this.parseFunctionElement(classConfiguration, childElement);
                continue;
            }
            if (tagName.equals("javascript")) {
                JavaScriptConfiguration.getLog().debug((Object)("javascript tag not yet handled for class " + linkedClassname));
                continue;
            }
            if (tagName.equals("browser")) {
                JavaScriptConfiguration.getLog().debug((Object)("browser tag not yet handled for class " + linkedClassname));
                continue;
            }
            if (tagName.equals("doclink")) continue;
            throw new IllegalStateException("Do not understand element type '" + tagName + "' in '" + linkedClassname + "'");
        }
        return classConfiguration;
    }

    private void parsePropertyElement(ClassConfiguration classConfiguration, Element element) {
        String writeFlag;
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return;
        }
        if (this.testToExcludeElement(element)) {
            return;
        }
        String propertyName = element.getAttribute("name");
        boolean readable = false;
        boolean writeable = false;
        String readFlag = element.getAttribute("readable");
        if ("true".equalsIgnoreCase(readFlag)) {
            readable = true;
        }
        if ("true".equalsIgnoreCase(writeFlag = element.getAttribute("writable"))) {
            writeable = true;
        }
        classConfiguration.addProperty(propertyName, readable, writeable);
    }

    private void parseFunctionElement(ClassConfiguration classConfiguration, Element element) {
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return;
        }
        String propertyName = element.getAttribute("name");
        if (this.testToExcludeElement(element)) {
            return;
        }
        classConfiguration.addFunction(propertyName);
    }

    private boolean testToExcludeElement(Element element) {
        if (this.browser_ == null) {
            return false;
        }
        boolean browserConstraint = false;
        boolean allowBrowser = false;
        boolean javascriptConstraint = false;
        boolean allowJavascriptConstraint = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            if (childElement.getTagName().equals("browser")) {
                browserConstraint = true;
                if (!this.testToIncludeForBrowserConstraint(childElement, this.browser_)) continue;
                allowBrowser = true;
                continue;
            }
            if (!childElement.getTagName().equals("javascript")) continue;
            javascriptConstraint = true;
            if (!this.testToIncludeForJSConstraint(childElement, this.browser_)) continue;
            allowJavascriptConstraint = true;
        }
        if (browserConstraint && !allowBrowser) {
            return true;
        }
        return javascriptConstraint && !allowJavascriptConstraint;
    }

    protected boolean classConfigEquals(String classname, ClassConfiguration config) {
        ClassConfiguration myConfig = (ClassConfiguration)this.configuration_.get(classname);
        return config.equals(myConfig);
    }

    public BrowserVersion getBrowser() {
        return this.browser_;
    }

    public ClassConfiguration getClassConfiguration(String classname) {
        return (ClassConfiguration)this.configuration_.get(classname);
    }

    private boolean testToIncludeForBrowserConstraint(Element element, BrowserVersion browser) {
        if (!browser.getApplicationName().equals(element.getAttribute("name"))) {
            return false;
        }
        String max = element.getAttribute("max-version");
        float maxVersion = max.length() == 0 ? 0.0f : Float.parseFloat(max);
        if (maxVersion > 0.0f && browser.getBrowserVersionNumeric() > maxVersion) {
            return false;
        }
        String min = element.getAttribute("min-version");
        float minVersion = min.length() == 0 ? 0.0f : Float.parseFloat(min);
        return !(minVersion > 0.0f) || !(browser.getBrowserVersionNumeric() < minVersion);
    }

    private boolean testToIncludeForJSConstraint(Element element, BrowserVersion browser) {
        String max = element.getAttribute("max-version");
        float maxVersion = max.length() == 0 ? 0.0f : Float.parseFloat(max);
        if (maxVersion > 0.0f && browser.getJavaScriptVersionNumeric() > maxVersion) {
            return false;
        }
        String min = element.getAttribute("min-version");
        float minVersion = min.length() == 0 ? 0.0f : Float.parseFloat(min);
        return !(minVersion > 0.0f) || !(browser.getJavaScriptVersionNumeric() < minVersion);
    }

    protected Iterator keyIterator() {
        return this.configuration_.keySet().iterator();
    }

    protected Class getClassObject(String classname) {
        ClassConfiguration config = (ClassConfiguration)this.configuration_.get(classname);
        return config.getLinkedClass();
    }

    public Method getPropertyReadMethod(Class clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getPropertyReadMethod(classname, propertyName);
    }

    public Method getPropertyReadMethod(String classname, String propertyName) {
        while (classname.length() > 0) {
            ClassConfiguration config = (ClassConfiguration)this.configuration_.get(classname);
            if (config == null) {
                return null;
            }
            Method theMethod = config.getPropertyReadMethod(propertyName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    private ClassConfiguration.PropertyInfo findPropertyInChain(String classname, String propertyName) {
        String workname = classname;
        while (workname.length() > 0) {
            ClassConfiguration config = (ClassConfiguration)this.configuration_.get(workname);
            ClassConfiguration.PropertyInfo info = config.getPropertyInfo(propertyName);
            if (info != null) {
                return info;
            }
            workname = config.getExtendedClass();
        }
        return null;
    }

    public Method getPropertyWriteMethod(Class clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getPropertyWriteMethod(classname, propertyName);
    }

    public Method getPropertyWriteMethod(String classname, String propertyName) {
        while (classname.length() > 0) {
            ClassConfiguration config = (ClassConfiguration)this.configuration_.get(classname);
            Method theMethod = config.getPropertyWriteMethod(propertyName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    public Method getFunctionMethod(Class clazz, String functionName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getFunctionMethod(classname, functionName);
    }

    public Method getFunctionMethod(String classname, String functionName) {
        while (classname.length() > 0) {
            ClassConfiguration config = (ClassConfiguration)this.configuration_.get(classname);
            Method theMethod = config.getFunctionMethod(functionName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    public boolean propertyExists(Class clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.propertyExists(classname, propertyName);
    }

    public boolean propertyExists(String classname, String propertyName) {
        ClassConfiguration.PropertyInfo info = this.findPropertyInChain(classname, propertyName);
        return info != null;
    }

    private String getClassnameForClass(Class clazz) {
        String name = (String)ClassnameMap_.get(clazz.getName());
        if (name == null) {
            throw new IllegalStateException("Did not find the mapping of the class to the classname for " + clazz.getName());
        }
        return name;
    }

    public static synchronized Map getHtmlJavaScriptMapping() {
        if (HtmlJavaScriptMap_ != null) {
            return HtmlJavaScriptMap_;
        }
        JavaScriptConfiguration configuration = JavaScriptConfiguration.getAllEntries();
        Iterator it = configuration.keyIterator();
        HashMap map = new HashMap();
        while (it.hasNext()) {
            String jsClassname = (String)it.next();
            ClassConfiguration classConfig = configuration.getClassConfiguration(jsClassname);
            String htmlClassname = classConfig.getHtmlClassname();
            if (htmlClassname == null) continue;
            try {
                Class<?> htmlClass = Class.forName(htmlClassname);
                JavaScriptConfiguration.getLog().debug((Object)("Mapping " + htmlClass.getName() + " to " + jsClassname));
                while (!classConfig.isJsObject()) {
                    jsClassname = classConfig.getExtendedClass();
                    classConfig = configuration.getClassConfiguration(jsClassname);
                    JavaScriptConfiguration.getLog().debug((Object)("   testing to use " + jsClassname));
                }
                map.put(htmlClass, classConfig.getLinkedClass());
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        HtmlJavaScriptMap_ = Collections.unmodifiableMap(map);
        return HtmlJavaScriptMap_;
    }

    static {
        ConfigurationMap_ = new HashMap(11);
        ClassnameMap_ = new HashMap();
    }
}

