/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class SimpleScriptable
extends ScriptableObject {
    private static final long serialVersionUID = 3120000176890886780L;
    private DomNode domNode_;
    private boolean isInitialized_ = false;

    private JavaScriptConfiguration getJavaScriptConfiguration() {
        BrowserVersion browserVersion = this.getWindow().getWebWindow().getWebClient().getBrowserVersion();
        return JavaScriptConfiguration.getInstance(browserVersion);
    }

    public String getClassName() {
        String javaClassName = ((Object)((Object)this)).getClass().getName();
        int index = javaClassName.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("No dot in classname: " + javaClassName);
        }
        return javaClassName.substring(index + 1);
    }

    public SimpleScriptable makeJavaScriptObject(String className) {
        Context c = Context.enter();
        try {
            SimpleScriptable scriptable;
            SimpleScriptable simpleScriptable = scriptable = (SimpleScriptable)c.newObject((Scriptable)this, className);
            return simpleScriptable;
        }
        catch (Exception e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    public final DomNode getDomNodeOrDie() throws IllegalStateException {
        if (this.domNode_ == null) {
            String clazz = ((Object)((Object)this)).getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return this.domNode_;
    }

    public final HtmlElement getHtmlElementOrDie() throws IllegalStateException {
        return (HtmlElement)this.getDomNodeOrDie();
    }

    public final DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public final HtmlElement getHtmlElementOrNull() {
        return (HtmlElement)this.getDomNodeOrNull();
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        Assert.notNull("domNode", domNode);
        this.isInitialized_ = true;
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptObject((Object)this);
        }
    }

    protected void setInitialized() {
        this.isInitialized_ = true;
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        this.setDomNode(htmlElement);
    }

    public Object get(String name, Scriptable start) {
        Object result;
        if ("eval".equals(name) && start == this.getStartingScope()) {
            return super.get(name, start);
        }
        if (this.domNode_ == null && !this.isInitialized_) {
            Object result2 = super.get(name, start);
            if (result2 == NOT_FOUND) {
                this.getLog().debug((Object)("Property \"" + name + "\" of " + start + " not defined as pure js property"));
            }
            return result2;
        }
        JavaScriptConfiguration configuration = this.getJavaScriptConfiguration();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        Method propertyMethod = configuration.getPropertyReadMethod(clazz, name);
        Method functionMethod = configuration.getFunctionMethod(clazz, name);
        if (propertyMethod != null && functionMethod != null) {
            throw new IllegalStateException("Name is both a property and a function: name=[" + name + "] class=[" + clazz.getName() + "]");
        }
        if (propertyMethod == null) {
            result = functionMethod == null ? super.get(name, start) : new FunctionObject(name, (Member)functionMethod, (Scriptable)this);
        } else {
            try {
                result = propertyMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        if (result == NOT_FOUND) {
            this.getLog().debug((Object)("Property \"" + name + "\" of " + start + " not defined as fixed property"));
        }
        return result;
    }

    public void put(String name, Scriptable start, Object newValue) {
        SimpleScriptable simpleScriptable = (SimpleScriptable)start;
        if (simpleScriptable.domNode_ == null && !this.isInitialized_) {
            super.put(name, start, newValue);
            return;
        }
        JavaScriptConfiguration configuration = simpleScriptable.getJavaScriptConfiguration();
        Method setterMethod = configuration.getPropertyWriteMethod(((Object)((Object)this)).getClass(), name);
        if (setterMethod == null) {
            if (configuration.propertyExists(((Object)((Object)this)).getClass(), name)) {
                throw Context.reportRuntimeError((String)("Property \"" + name + "\" is not writable for " + start + ". " + "Cant set it to: " + newValue));
            }
            this.getLog().debug((Object)("No configured setter \"" + name + "\" found for " + start + ". Setting it as pure javascript property."));
            super.put(name, start, newValue);
        } else {
            Class<?> parameterClass = setterMethod.getParameterTypes()[0];
            if (parameterClass == String.class) {
                newValue = Context.toString((Object)newValue);
            } else if (Integer.TYPE.equals(parameterClass)) {
                newValue = new Integer(new Double(Context.toNumber((Object)newValue)).intValue());
            } else if (Boolean.TYPE.equals(parameterClass)) {
                newValue = Context.toBoolean((Object)newValue);
            }
            try {
                setterMethod.invoke((Object)simpleScriptable.findMatchingScriptable(start, setterMethod), newValue);
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    private Scriptable findMatchingScriptable(Scriptable start, Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Scriptable scriptable = start;
        while (!declaringClass.isInstance(start)) {
            if ((scriptable = scriptable.getPrototype()) != null) continue;
            throw new IllegalStateException("Couldn't find a matching scriptable");
        }
        return scriptable;
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((Object)((WebWindow)object).getScriptObject());
        }
        DomNode domNode = (DomNode)object;
        Object scriptObject = domNode.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)((Object)scriptObject);
        }
        return this.makeScriptableFor(domNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        Context.enter();
        try {
            SimpleScriptable scriptable;
            Class javaScriptClass = null;
            for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
                javaScriptClass = (Class)JavaScriptConfiguration.getHtmlJavaScriptMapping().get(c);
            }
            if (javaScriptClass == null) {
                scriptable = new HTMLElement();
                this.getLog().debug((Object)("No javascript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
            } else {
                try {
                    scriptable = (SimpleScriptable)((Object)javaScriptClass.newInstance());
                }
                catch (Exception e) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)e);
                }
            }
            if (domNode.getPage().getEnclosingWindow().getEnclosedPage() == domNode.getPage()) {
                scriptable.setParentScope((Scriptable)this.getWindow());
            } else {
                scriptable.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)((Scriptable)domNode.getPage().getScriptObject())));
            }
            scriptable.setDomNode(domNode);
            SimpleScriptable simpleScriptable = scriptable;
            return simpleScriptable;
        }
        finally {
            Context.exit();
        }
    }

    protected Transformer getTransformerScriptableFor() {
        return new Transformer(){

            public Object transform(Object obj) {
                return SimpleScriptable.this.getScriptableFor(obj);
            }
        };
    }

    public static Object getObjectArg(int index, Object[] args, Object defaultValue) {
        if (index >= args.length) {
            return defaultValue;
        }
        return args[index];
    }

    public static String getStringArg(int index, Object[] args, String defaultValue) {
        return Context.toString((Object)SimpleScriptable.getObjectArg(index, args, defaultValue));
    }

    public static boolean getBooleanArg(int index, Object[] args, boolean defaultValue) {
        Boolean defaultBoolean = defaultValue;
        return Context.toBoolean((Object)SimpleScriptable.getObjectArg(index, args, defaultBoolean));
    }

    public static int getIntArg(int index, Object[] args, int defaultValue) {
        return (int)Context.toNumber((Object)SimpleScriptable.getObjectArg(index, args, new Integer(defaultValue)));
    }

    public Object getDefaultValue(Class hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                return "[object]";
            }
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    protected Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow((Scriptable)this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope((Scriptable)s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        return (Scriptable)Context.getCurrentContext().getThreadLocal((Object)"startingScope");
    }

    public boolean has(String name, Scriptable start) {
        SimpleScriptable simpleScriptable = (SimpleScriptable)start;
        JavaScriptConfiguration configuration = simpleScriptable.getJavaScriptConfiguration();
        if ((start == start.getPrototype() || simpleScriptable.getDomNodeOrNull() != null) && configuration.getPropertyReadMethod(((Object)((Object)this)).getClass(), name) != null) {
            return true;
        }
        return super.has(name, start);
    }
}

