/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLSelectElement;
import com.gargoylesoftware.htmlunit.javascript.host.Option;
import org.mozilla.javascript.Scriptable;

public class OptionsArray
extends SimpleScriptable {
    private static final long serialVersionUID = -4790255174217201235L;
    private HtmlSelect htmlSelect_;

    public final void jsConstructor() {
    }

    public void initialize(HtmlSelect select) {
        Assert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        Object object = null;
        try {
            object = this.getScriptableFor(this.htmlSelect_.getOption(index));
        }
        catch (IndexOutOfBoundsException e) {
            object = NOT_FOUND;
        }
        return object;
    }

    public Object get(String name, Scriptable start) {
        Object object = super.get(name, start);
        if (object == NOT_FOUND) {
            Scriptable prototype = this.getPrototype();
            if (prototype instanceof OptionsArray) {
                object = prototype.get(name, start);
                if (object != NOT_FOUND) {
                    return object;
                }
            } else {
                return NOT_FOUND;
            }
            if (this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                HTMLSelectElement select = (HTMLSelectElement)((Object)this.htmlSelect_.getScriptObject());
                object = select.get(name, start);
            }
        }
        return object;
    }

    public Object jsFunction_item(int index) {
        return this.get(index, null);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            Option option = (Option)((Object)newValue);
            HtmlOption htmlOption = (HtmlOption)option.getHtmlElementOrNull();
            if (index >= this.jsGet_length()) {
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
    }

    public int jsGet_length() {
        return this.htmlSelect_.getOptionSize();
    }

    public void jsSet_length(int newLength) {
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                this.htmlSelect_.appendOption(new HtmlOption(this.htmlSelect_.getPage(), null));
            }
        }
    }

    public void jsFunction_add(Object newOptionObject, Object newIndex) {
        int index = this.jsGet_length();
        if (newIndex instanceof Number) {
            index = ((Number)newIndex).intValue();
        }
        this.put(index, null, newOptionObject);
    }
}

