/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.javascript.ScriptableWrapper;
import java.lang.reflect.Method;
import org.apache.commons.lang.ArrayUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class MethodWrapper
extends ScriptableObject
implements Function {
    private final Class clazz_;
    private final Method method_;
    private final int[] jsTypeTags_;

    MethodWrapper(String methodName, Class clazz) throws NoSuchMethodException {
        this(methodName, clazz, ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    MethodWrapper(String methodName, Class clazz, Class[] parameterTypes) throws NoSuchMethodException {
        this.clazz_ = clazz;
        this.method_ = clazz.getMethod(methodName, parameterTypes);
        this.jsTypeTags_ = new int[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.jsTypeTags_[i] = FunctionObject.getTypeTag((Class)parameterTypes[i]);
        }
    }

    public String getClassName() {
        return "function " + this.method_.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!(thisObj instanceof ScriptableWrapper)) throw this.buildInvalidCallException(thisObj);
        ScriptableWrapper wrapper = (ScriptableWrapper)thisObj;
        Object wrappedObject = wrapper.getWrappedObject();
        if (!this.clazz_.isInstance(wrappedObject)) throw this.buildInvalidCallException(thisObj);
        Object[] javaArgs = this.convertJSArgsToJavaArgs(context, scope, args);
        try {
            Object javaResp = this.method_.invoke(wrappedObject, javaArgs);
            return Context.javaToJS((Object)javaResp, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)scope));
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception calling wrapped function " + this.method_.getName() + ": " + e.getMessage()));
        }
    }

    private RuntimeException buildInvalidCallException(Scriptable thisObj) {
        return Context.reportRuntimeError((String)("Function " + this.method_.getName() + " called on incompatible object: " + thisObj));
    }

    Object[] convertJSArgsToJavaArgs(Context context, Scriptable scope, Object[] jsArgs) {
        if (jsArgs.length != this.jsTypeTags_.length) {
            throw Context.reportRuntimeError((String)("Bad number of parameters for function " + this.method_.getName() + ": expected " + this.jsTypeTags_.length + " got " + jsArgs.length));
        }
        Object[] javaArgs = new Object[jsArgs.length];
        for (int i = 0; i < jsArgs.length; ++i) {
            javaArgs[i] = FunctionObject.convertArg((Context)context, (Scriptable)scope, (Object)jsArgs[i], (int)this.jsTypeTags_[i]);
        }
        return javaArgs;
    }

    public Scriptable construct(Context context, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError((String)("Function " + this.method_.getName() + " can't be used as a constructor"));
    }
}

