/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.ElementArray;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.OptionsArray;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptEngine
extends ScriptEngine {
    private static final ThreadLocal javaScriptRunning_ = new ThreadLocal();
    private static final ContextListener contextListener_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    static /* synthetic */ Class class$com$gargoylesoftware$htmlunit$javascript$host$Window;

    public JavaScriptEngine(WebClient webClient) {
        super(webClient);
    }

    public void initialize(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        WebClient webClient = webWindow.getWebClient();
        Context context = Context.enter();
        try {
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
            Window window = (Window)context.initStandardObjects((ScriptableObject)new Window());
            Iterator it = jsConfig.keySet().iterator();
            while (it.hasNext()) {
                String jsClassName = (String)it.next();
                ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
                boolean isWindow = (class$com$gargoylesoftware$htmlunit$javascript$host$Window == null ? JavaScriptEngine.class$("com.gargoylesoftware.htmlunit.javascript.host.Window") : class$com$gargoylesoftware$htmlunit$javascript$host$Window).getName().equals(config.getLinkedClass().getName());
                if (!config.isJsObject() || isWindow) continue;
                this.configureClass(config, (Scriptable)window, jsClassName);
            }
            ScriptableObject.defineClass((Scriptable)window, (Class)ElementArray.class);
            ScriptableObject.defineClass((Scriptable)window, (Class)OptionsArray.class);
            window.initialize(webWindow);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
            throw new ScriptException(null, (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    private void configureClass(ClassConfiguration config, Scriptable scope, String name) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class jsHostClass = config.getLinkedClass();
        ScriptableObject.defineClass((Scriptable)scope, (Class)jsHostClass);
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)scope, (String)name);
        Iterator propertiesIterator = config.propertyKeys().iterator();
        while (propertiesIterator.hasNext()) {
            String entryKey = (String)propertiesIterator.next();
            Method readMethod = config.getPropertyReadMethod(entryKey);
            Method writeMethod = config.getPropertyWriteMethod(entryKey);
            prototype.defineProperty(entryKey, null, readMethod, writeMethod, 0);
        }
        Iterator functionsIterator = config.functionKeys().iterator();
        while (functionsIterator.hasNext()) {
            String entryKey = (String)functionsIterator.next();
            Method method = config.getFunctionMethod(entryKey);
            FunctionObject functionObject = new FunctionObject(entryKey, (Member)method, (Scriptable)prototype);
            prototype.defineProperty(entryKey, (Object)functionObject, 0);
        }
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElement) {
        Assert.notNull("sourceCode", sourceCode);
        sourceCode = this.preProcess(htmlPage, sourceCode, sourceName, htmlElement);
        sourceCode = sourceCode.trim();
        if (sourceCode.startsWith("<!--")) {
            int startIndex = 4;
            int endIndex = sourceCode.endsWith("-->") ? sourceCode.length() - 3 : sourceCode.length();
            char eachChar = sourceCode.charAt(startIndex);
            while (startIndex < endIndex && eachChar != '\n' && eachChar != '\r') {
                eachChar = sourceCode.charAt(++startIndex);
            }
            sourceCode = sourceCode.substring(startIndex, endIndex);
        }
        Object scope = htmlElement != null ? (Scriptable)htmlElement.getScriptObject() : (Window)((Object)htmlPage.getEnclosingWindow().getScriptObject());
        boolean lineNumber = true;
        Object securityDomain = null;
        Boolean javaScriptAlreadyRunning = (Boolean)javaScriptRunning_.get();
        javaScriptRunning_.set(Boolean.TRUE);
        Context context = Context.enter();
        context.putThreadLocal((Object)KEY_STARTING_SCOPE, scope);
        try {
            Object result;
            Object object = htmlPage;
            synchronized (object) {
                result = context.evaluateString(scope, sourceCode, sourceName, 1, securityDomain);
            }
            object = result;
            return object;
        }
        catch (Exception e) {
            ScriptException scriptException = new ScriptException(htmlPage, e, sourceCode);
            if (this.getWebClient().isThrowExceptionOnScriptError()) {
                throw scriptException;
            }
            this.getLog().info((Object)"Catched script exception", (Throwable)scriptException);
            Object var12_19 = null;
            return var12_19;
        }
        catch (TimeoutError e) {
            if (this.getWebClient().isThrowExceptionOnScriptError()) {
                throw new RuntimeException(e);
            }
            this.getLog().info((Object)"Catched script timeout error", (Throwable)e);
            Object var11_14 = null;
            return var11_14;
        }
        finally {
            javaScriptRunning_.set(javaScriptAlreadyRunning);
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(HtmlPage htmlPage, Object javaScriptFunction, Object thisObject, Object[] args, HtmlElement htmlElement) {
        Object scope = htmlElement != null ? (Scriptable)htmlElement.getScriptObject() : (Window)((Object)htmlPage.getEnclosingWindow().getScriptObject());
        Boolean javaScriptAlreadyRunning = (Boolean)javaScriptRunning_.get();
        javaScriptRunning_.set(Boolean.TRUE);
        Function function = (Function)javaScriptFunction;
        Context context = Context.enter();
        context.putThreadLocal((Object)KEY_STARTING_SCOPE, scope);
        try {
            Object object = this.callFunction(htmlPage, function, context, (Scriptable)scope, (Scriptable)thisObject, args);
            return object;
        }
        catch (Exception e) {
            String sourceCode = context.decompileFunction(function, 2);
            ScriptException scriptException = new ScriptException(htmlPage, e, sourceCode);
            if (this.getWebClient().isThrowExceptionOnScriptError()) {
                throw scriptException;
            }
            this.getLog().info((Object)"Catched script exception", (Throwable)scriptException);
            Object var13_16 = null;
            return var13_16;
        }
        catch (TimeoutError e) {
            if (this.getWebClient().isThrowExceptionOnScriptError()) {
                throw new RuntimeException(e);
            }
            this.getLog().info((Object)"Catched script timeout error", (Throwable)e);
            Object var11_14 = null;
            return var11_14;
        }
        finally {
            javaScriptRunning_.set(javaScriptAlreadyRunning);
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(HtmlPage htmlPage, Function function, Context context, Scriptable scope, Scriptable thisObject, Object[] args) {
        HtmlPage htmlPage2 = htmlPage;
        synchronized (htmlPage2) {
            return function.call(context, scope, thisObject, args);
        }
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(javaScriptRunning_.get());
    }

    public static void setTimeout(long timeout) {
        HtmlUnitContextFactory.setTimeout(timeout);
    }

    public static long getTimeout() {
        return HtmlUnitContextFactory.getTimeout();
    }

    public static int getContextCount() {
        return contextListener_.getContextCount();
    }

    static {
        HtmlUnitContextFactory contextFactory = new HtmlUnitContextFactory(JavaScriptEngine.getScriptEngineLog());
        ContextFactory.initGlobal((ContextFactory)contextFactory);
        contextListener_ = new ContextListener();
        contextFactory.addListener(contextListener_);
    }

    private static class ContextListener
    implements ContextFactory.Listener {
        private final Set contexts_ = Collections.synchronizedSet(new HashSet());

        private ContextListener() {
        }

        public void contextCreated(Context c) {
            this.contexts_.add(c);
        }

        public void contextReleased(Context c) {
            this.contexts_.remove(c);
        }

        public int getContextCount() {
            return this.contexts_.size();
        }
    }
}

