/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitWrapFactory;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorReporter;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import org.apache.commons.logging.Log;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public class HtmlUnitContextFactory
extends ContextFactory {
    private final Log log_;
    private static final int INSTRUCTION_COUNT_THRESHOLD = 10000;
    private static long Timeout_ = 0L;

    public HtmlUnitContextFactory(Log log) {
        Assert.notNull("log", log);
        this.log_ = log;
    }

    public static void setTimeout(long timeout) {
        Timeout_ = timeout;
    }

    public static long getTimeout() {
        return Timeout_;
    }

    protected Context makeContext() {
        TimeoutContext cx = new TimeoutContext();
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        cx.setErrorReporter(new StrictErrorReporter(this.log_));
        cx.setWrapFactory(new HtmlUnitWrapFactory());
        return cx;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.terminateScriptIfNecessary();
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.startClock();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    private static class TimeoutContext
    extends Context {
        private long startTime_;

        private TimeoutContext() {
        }

        public void startClock() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void terminateScriptIfNecessary() {
            long currentTime;
            if (Timeout_ > 0L && (currentTime = System.currentTimeMillis()) - this.startTime_ > Timeout_) {
                throw new TimeoutError(Timeout_, currentTime - this.startTime_);
            }
        }
    }
}

