/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class ElementArray
extends SimpleScriptable
implements Function {
    public static final String JS_OBJECT_NAME = "ElementArray";
    private static final long serialVersionUID = 4049916048017011764L;
    private XPath xpath_;
    private DomNode node_;
    private Transformer transformer_;

    public void init(DomNode node, XPath xpath) {
        this.init(node, xpath, NOPTransformer.INSTANCE);
    }

    public void init(DomNode node, XPath xpath, Transformer transformer) {
        this.node_ = node;
        this.xpath_ = xpath;
        this.transformer_ = transformer;
    }

    public final void jsConstructor() {
    }

    public final Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        return this.get(args[0]);
    }

    public final Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) throws JavaScriptException {
        return null;
    }

    private Object get(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        ElementArray array = (ElementArray)start;
        List elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableFor(this.transformer_.transform(elements.get(index)));
        }
        return NOT_FOUND;
    }

    private List getElements() {
        try {
            List list = this.xpath_.selectNodes((Object)this.node_);
            return list;
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Exeption getting elements: " + e.getMessage()));
        }
    }

    public final Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        ElementArray currentArray = (ElementArray)start;
        List elements = currentArray.getElements();
        CollectionUtils.transform((Collection)elements, (Transformer)this.transformer_);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof HtmlElement) {
                HtmlElement element = (HtmlElement)next;
                String id = element.getId();
                if (id == null || !id.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by id) to " + element));
                return this.getScriptableFor(element);
            }
            if (next instanceof WebWindow) {
                WebWindow window = (WebWindow)next;
                String windowName = window.getName();
                if (windowName == null || !windowName.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + window));
                return this.getScriptableFor(window);
            }
            this.getLog().debug((Object)("Unrecognized type in array: \"" + next.getClass().getName() + "\""));
        }
        ElementArray array = (ElementArray)currentArray.makeJavaScriptObject(JS_OBJECT_NAME);
        try {
            String newCondition = "@name = '" + name + "'";
            String currentXPathExpr = currentArray.xpath_.toString();
            String xpathExpr = currentXPathExpr.endsWith("]") ? currentXPathExpr.substring(0, currentXPathExpr.length() - 1) + " and " + newCondition + "]" : currentXPathExpr + "[" + newCondition + "]";
            XPath xpathName = currentArray.xpath_.getNavigator().parseXPath(xpathExpr);
            array.init(currentArray.node_, xpathName);
        }
        catch (SAXPathException e) {
            throw Context.reportRuntimeError((String)("Failed getting sub elements by name" + e.getMessage()));
        }
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List subElements = array.getElements();
        if (subElements.size() > 1) {
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + (Object)((Object)array) + " with " + subElements.size() + " elements"));
            return array;
        }
        if (subElements.size() == 1) {
            SimpleScriptable singleResult = this.getScriptableFor(subElements.get(0));
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + (Object)((Object)singleResult)));
            return singleResult;
        }
        return NOT_FOUND;
    }

    public final int jsGet_length() {
        return this.getElements().size();
    }

    public final Object jsFunction_item(Object index) {
        return this.get(index);
    }

    public final Object jsFunction_namedItem(String name) {
        return this.get(name);
    }

    public final Object jsFunction_tags(String tagName) {
        ElementArray array = (ElementArray)this.makeJavaScriptObject(JS_OBJECT_NAME);
        try {
            String newXPathExpr = this.xpath_.toString() + "[name() = '" + tagName.toLowerCase() + "']";
            array.init(this.node_, this.xpath_.getNavigator().parseXPath(newXPathExpr));
        }
        catch (SAXPathException e) {
            throw Context.reportRuntimeError((String)("Failed call tags: " + e.getMessage()));
        }
        return array;
    }

    public String toString() {
        if (this.xpath_ != null) {
            return super.toString() + "<" + this.xpath_.toString() + ">";
        }
        return super.toString();
    }

    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof ElementArray) {
            ElementArray otherArray = (ElementArray)((Object)other);
            if (this.node_ == otherArray.node_ && this.xpath_.toString().equals(otherArray.xpath_.toString()) && this.transformer_.equals(otherArray.transformer_)) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }
}

