/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.NodeIterator;
import java.util.Iterator;

public final class Util {
    private Util() {
    }

    public static Iterator getFollowingSiblingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                return this.getNextNode(node);
            }

            protected DomNode getNextNode(DomNode node) {
                return node.getNextSibling();
            }
        };
    }

    public static Iterator getPrecedingSiblingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                return this.getNextNode(node);
            }

            protected DomNode getNextNode(DomNode node) {
                return node.getPreviousSibling();
            }
        };
    }

    public static Iterator getFollowingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode sibling = node.getNextSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return sibling;
            }

            protected DomNode getNextNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode n = node.getFirstChild();
                if (n == null) {
                    n = node.getNextSibling();
                }
                if (n == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return n;
            }
        };
    }

    public static Iterator getPrecedingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode sibling = node.getPreviousSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return sibling;
            }

            protected DomNode getNextNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode n = node.getLastChild();
                if (n == null) {
                    n = node.getPreviousSibling();
                }
                if (n == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return n;
            }
        };
    }
}

