/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public final class InputElementFactory
implements IElementFactory {
    public static final InputElementFactory instance = new InputElementFactory();

    private InputElementFactory() {
    }

    public HtmlElement createElement(HtmlPage page, String tagName, Attributes attributes) {
        HtmlInput result;
        String type = null;
        if (attributes != null) {
            type = attributes.getValue("type");
        }
        type = type == null ? "" : type.toLowerCase();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                attributeMap.put(attributes.getLocalName(i), attributes.getValue(i));
            }
        }
        if (type.length() == 0) {
            attributeMap.put("type", "text");
            result = new HtmlTextInput(page, attributeMap);
        } else if (type.equals("submit")) {
            result = new HtmlSubmitInput(page, attributeMap);
        } else if (type.equals("checkbox")) {
            result = new HtmlCheckBoxInput(page, attributeMap);
        } else if (type.equals("radio")) {
            result = new HtmlRadioButtonInput(page, attributeMap);
        } else if (type.equals("text")) {
            result = new HtmlTextInput(page, attributeMap);
        } else if (type.equals("hidden")) {
            result = new HtmlHiddenInput(page, attributeMap);
        } else if (type.equals("password")) {
            result = new HtmlPasswordInput(page, attributeMap);
        } else if (type.equals("image")) {
            result = new HtmlImageInput(page, attributeMap);
        } else if (type.equals("reset")) {
            result = new HtmlResetInput(page, attributeMap);
        } else if (type.equals("button")) {
            result = new HtmlButtonInput(page, attributeMap);
        } else if (type.equals("file")) {
            result = new HtmlFileInput(page, attributeMap);
        } else {
            this.getLog().info((Object)("Bad input type: \"" + type + "\", creating a text input"));
            result = new HtmlTextInput(page, attributeMap);
        }
        return result;
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }
}

