/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.util.Map;

public class HtmlTextArea
extends FocusableElement
implements DisabledElement,
SubmittableElement {
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;

    public HtmlTextArea(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            DomText child = (DomText)this.getFirstChild();
            if (child != null) {
                this.defaultValue_ = child.getData();
                if (this.defaultValue_ == null) {
                    this.defaultValue_ = "";
                }
            } else {
                this.defaultValue_ = "";
            }
        }
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public final String getText() {
        return this.getChildrenAsText();
    }

    public final void setText(String newValue) {
        this.initDefaultValue();
        DomText child = (DomText)this.getFirstChild();
        if (child == null) {
            DomText newChild = new DomText(this.getPage(), newValue);
            this.appendChild(newChild);
        } else {
            child.setData(newValue);
        }
        this.getPage().executeOnChangeHandlerIfAppropriate(this);
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getText())};
    }

    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        this.defaultValue_ = defaultValue == null ? "" : defaultValue;
    }

    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    public void setDefaultChecked(boolean defaultChecked) {
    }

    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getRowsAttribute() {
        return this.getAttributeValue("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttributeValue("cols");
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }
}

