/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class HtmlTableRow
extends ClickableElement {
    public static final String TAG_NAME = "tr";

    public HtmlTableRow(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public CellIterator getCellIterator() {
        return new CellIterator();
    }

    public List getCells() {
        ArrayList<Object> result = new ArrayList<Object>();
        CellIterator iterator = this.getCellIterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableCell getCell(int index) throws IndexOutOfBoundsException {
        int count = 0;
        CellIterator iterator = this.getCellIterator();
        while (iterator.hasNext()) {
            HtmlTableCell next = iterator.nextCell();
            if (count == index) {
                return next;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getCharAttribute() {
        return this.getAttributeValue("char");
    }

    public final String getCharoffAttribute() {
        return this.getAttributeValue("charoff");
    }

    public final String getValignAttribute() {
        return this.getAttributeValue("valign");
    }

    public HtmlTable getEnclosingTable() {
        return (HtmlTable)this.getEnclosingElement("table");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeValue("bgcolor");
    }

    public class CellIterator
    implements Iterator {
        private HtmlTableCell nextCell_;
        private HtmlForm currentForm_;

        public CellIterator() {
            this.setNextCell(HtmlTableRow.this.getFirstChild());
        }

        public boolean hasNext() {
            return this.nextCell_ != null;
        }

        public Object next() throws NoSuchElementException {
            return this.nextCell();
        }

        public void remove() throws IllegalStateException {
            if (this.nextCell_ == null) {
                throw new IllegalStateException();
            }
            if (this.nextCell_.getPreviousSibling() != null) {
                this.nextCell_.getPreviousSibling().remove();
            }
        }

        public HtmlTableCell nextCell() throws NoSuchElementException {
            if (this.nextCell_ != null) {
                HtmlTableCell result = this.nextCell_;
                this.setNextCell(this.nextCell_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextCell(DomNode node) {
            this.nextCell_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableCell) {
                    this.nextCell_ = (HtmlTableCell)next;
                    return;
                }
                if (this.currentForm_ != null || !(next instanceof HtmlForm)) continue;
                this.currentForm_ = (HtmlForm)next;
                this.setNextCell(next.getFirstChild());
                return;
            }
            if (this.currentForm_ != null) {
                HtmlForm form = this.currentForm_;
                this.currentForm_ = null;
                this.setNextCell(form.getNextSibling());
            }
        }
    }
}

