/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlCaption;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class HtmlTable
extends ClickableElement {
    public static final String TAG_NAME = "table";

    public HtmlTable(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public final HtmlTableCell getCellAt(int rowIndex, int columnIndex) {
        RowIterator rowIterator = this.getRowIterator();
        int rowNo = 0;
        while (rowIterator.hasNext()) {
            HtmlTableRow row = rowIterator.nextRow();
            HtmlTableRow.CellIterator cellIterator = row.getCellIterator();
            int colNo = 0;
            while (cellIterator.hasNext()) {
                HtmlTableCell cell = cellIterator.nextCell();
                if (rowNo <= rowIndex && rowNo + cell.getRowSpan() > rowIndex && colNo <= columnIndex && colNo + cell.getColumnSpan() > columnIndex) {
                    return cell;
                }
                ++colNo;
            }
            ++rowNo;
        }
        return null;
    }

    private RowIterator getRowIterator() {
        return new RowIterator();
    }

    public List getRows() {
        ArrayList<Object> result = new ArrayList<Object>();
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableRow getRow(int index) throws IndexOutOfBoundsException {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            HtmlTableRow next = iterator.nextRow();
            if (count == index) {
                return next;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getRowCount() {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public final HtmlTableRow getRowById(String id) throws ElementNotFoundException {
        RowIterator iterator = new RowIterator();
        while (iterator.hasNext()) {
            HtmlTableRow row = (HtmlTableRow)iterator.next();
            if (!row.getIdAttribute().equals(id)) continue;
            return row;
        }
        throw new ElementNotFoundException("tr", "id", id);
    }

    public String getCaptionText() {
        HtmlElement.ChildElementsIterator iterator = this.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlCaption)) continue;
            return element.asText();
        }
        return null;
    }

    public HtmlTableHeader getHeader() {
        HtmlElement.ChildElementsIterator iterator = this.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableHeader)) continue;
            return (HtmlTableHeader)element;
        }
        return null;
    }

    public HtmlTableFooter getFooter() {
        HtmlElement.ChildElementsIterator iterator = this.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableFooter)) continue;
            return (HtmlTableFooter)element;
        }
        return null;
    }

    public List getBodies() {
        ArrayList<HtmlElement> bodies = new ArrayList<HtmlElement>();
        HtmlElement.ChildElementsIterator iterator = this.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableBody)) continue;
            bodies.add(element);
        }
        return bodies;
    }

    public final String getSummaryAttribute() {
        return this.getAttributeValue("summary");
    }

    public final String getWidthAttribute() {
        return this.getAttributeValue("width");
    }

    public final String getBorderAttribute() {
        return this.getAttributeValue("border");
    }

    public final String getFrameAttribute() {
        return this.getAttributeValue("frame");
    }

    public final String getRulesAttribute() {
        return this.getAttributeValue("rules");
    }

    public final String getCellSpacingAttribute() {
        return this.getAttributeValue("cellspacing");
    }

    public final String getCellPaddingAttribute() {
        return this.getAttributeValue("cellpadding");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeValue("bgcolor");
    }

    private class RowIterator
    implements Iterator {
        private HtmlTableRow nextRow_;
        private TableRowGroup currentGroup_;

        public RowIterator() {
            this.setNextRow(HtmlTable.this.getFirstChild());
        }

        public boolean hasNext() {
            return this.nextRow_ != null;
        }

        public Object next() throws NoSuchElementException {
            return this.nextRow();
        }

        public void remove() throws IllegalStateException {
            if (this.nextRow_ == null) {
                throw new IllegalStateException();
            }
            if (this.nextRow_.getPreviousSibling() != null) {
                this.nextRow_.getPreviousSibling().remove();
            }
        }

        public HtmlTableRow nextRow() throws NoSuchElementException {
            if (this.nextRow_ != null) {
                HtmlTableRow result = this.nextRow_;
                this.setNextRow(this.nextRow_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextRow(DomNode node) {
            this.nextRow_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableRow) {
                    this.nextRow_ = (HtmlTableRow)next;
                    return;
                }
                if (this.currentGroup_ != null || !(next instanceof TableRowGroup)) continue;
                this.currentGroup_ = (TableRowGroup)next;
                this.setNextRow(next.getFirstChild());
                return;
            }
            if (this.currentGroup_ != null) {
                TableRowGroup group = this.currentGroup_;
                this.currentGroup_ = null;
                this.setNextRow(group.getNextSibling());
            }
        }
    }
}

