/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class HtmlSelect
extends FocusableElement
implements DisabledElement,
SubmittableElement {
    public static final String TAG_NAME = "select";
    private String[] fakeSelectedValues_;

    public HtmlSelect(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public List getSelectedOptions() {
        ArrayList<HtmlElement> result;
        if (this.isMultipleSelectEnabled()) {
            result = new ArrayList<HtmlElement>();
            DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
            while (iterator.hasNext()) {
                HtmlElement element = iterator.nextElement();
                if (!(element instanceof HtmlOption) || !((HtmlOption)element).isSelected()) continue;
                result.add(element);
            }
        } else {
            result = new ArrayList(1);
            HtmlOption firstOption = null;
            HtmlOption lastOption = null;
            DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
            while (iterator.hasNext()) {
                HtmlElement element = iterator.nextElement();
                if (!(element instanceof HtmlOption)) continue;
                HtmlOption option = (HtmlOption)element;
                if (firstOption == null) {
                    firstOption = option;
                }
                if (!option.isSelected()) continue;
                lastOption = option;
            }
            if (lastOption != null) {
                result.add(lastOption);
            } else if (firstOption != null) {
                int theSize;
                try {
                    theSize = Integer.parseInt(this.getSizeAttribute());
                }
                catch (NumberFormatException e) {
                    theSize = 1;
                }
                if (theSize <= 1) {
                    result.add(firstOption);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List getOptions() {
        List elementList = this.getHtmlElementsByTagName("option");
        return Collections.unmodifiableList(elementList);
    }

    public HtmlOption getOption(int index) {
        List elementList = this.getHtmlElementsByTagName("option");
        return (HtmlOption)elementList.get(index);
    }

    public int getOptionSize() {
        List elementList = this.getHtmlElementsByTagName("option");
        return elementList.size();
    }

    public void setOptionSize(int newLength) {
        List elementList = this.getHtmlElementsByTagName("option");
        for (int i = elementList.size() - 1; i >= newLength; --i) {
            ((HtmlElement)elementList.get(i)).remove();
        }
    }

    public void removeOption(int index) {
        HtmlElement.ChildElementsIterator iterator = new HtmlElement.ChildElementsIterator();
        int i = 0;
        while (iterator.hasNext()) {
            HtmlElement element = iterator.nextElement();
            if (i == index) {
                element.remove();
                return;
            }
            ++i;
        }
    }

    public void replaceOption(int index, HtmlOption newOption) {
        HtmlElement.ChildElementsIterator iterator = new HtmlElement.ChildElementsIterator();
        int i = 0;
        while (iterator.hasNext()) {
            HtmlElement element = iterator.nextElement();
            if (i == index) {
                element.replace(newOption);
                return;
            }
            ++i;
        }
        if (newOption.isSelected()) {
            this.setSelectedAttribute(newOption, true);
        }
    }

    public void appendOption(HtmlOption newOption) {
        this.appendChild(newOption);
    }

    public DomNode appendChild(DomNode node) {
        HtmlOption option;
        DomNode response = super.appendChild(node);
        if (node instanceof HtmlOption && (option = (HtmlOption)node).isSelected()) {
            this.setSelectedAttribute(option, true);
        }
        return response;
    }

    public Page setSelectedAttribute(String optionValue, boolean isSelected) {
        try {
            return this.setSelectedAttribute(this.getOptionByValue(optionValue), isSelected);
        }
        catch (ElementNotFoundException e) {
            throw new IllegalArgumentException("No option found with value: " + optionValue);
        }
    }

    public Page setSelectedAttribute(HtmlOption selectedOption, boolean isSelected) {
        boolean triggerHandler;
        boolean bl = triggerHandler = selectedOption.isSelected() != isSelected;
        if (this.isMultipleSelectEnabled()) {
            selectedOption.setSelectedInternal(isSelected);
        } else {
            Iterator iterator = this.getOptions().iterator();
            while (iterator.hasNext()) {
                HtmlOption option;
                option.setSelectedInternal((option = (HtmlOption)iterator.next()) == selectedOption && isSelected);
            }
        }
        if (triggerHandler) {
            return this.getPage().executeOnChangeHandlerIfAppropriate(this);
        }
        return this.getPage();
    }

    public void fakeSelectedAttribute(String optionValue) {
        Assert.notNull("optionValue", optionValue);
        this.fakeSelectedAttribute(new String[]{optionValue});
    }

    public void fakeSelectedAttribute(String[] optionValues) {
        Assert.notNull("optionValues", optionValues);
        this.fakeSelectedValues_ = optionValues;
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        KeyValuePair[] pairs;
        String name = this.getNameAttribute();
        if (ArrayUtils.isEmpty((Object[])this.fakeSelectedValues_)) {
            List selectedOptions = this.getSelectedOptions();
            int optionCount = selectedOptions.size();
            pairs = new KeyValuePair[optionCount];
            for (int i = 0; i < optionCount; ++i) {
                HtmlOption option = (HtmlOption)selectedOptions.get(i);
                pairs[i] = new KeyValuePair(name, option.getValueAttribute());
            }
        } else {
            ArrayList<KeyValuePair> pairsList = new ArrayList<KeyValuePair>();
            for (int i = 0; i < this.fakeSelectedValues_.length; ++i) {
                if (this.fakeSelectedValues_[i].length() <= 0) continue;
                pairsList.add(new KeyValuePair(name, this.fakeSelectedValues_[i]));
            }
            pairs = pairsList.toArray(new KeyValuePair[pairsList.size()]);
        }
        return pairs;
    }

    boolean isValidForSubmission() {
        return this.getOptionSize() > 0 || this.fakeSelectedValues_ != null && this.fakeSelectedValues_.length > 0;
    }

    public void reset() {
        Iterator iterator = this.getOptions().iterator();
        while (iterator.hasNext()) {
            HtmlOption option = (HtmlOption)iterator.next();
            option.reset();
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.setSelectedAttribute(defaultValue, true);
    }

    public String getDefaultValue() {
        List options = this.getSelectedOptions();
        if (options.size() > 0) {
            return ((HtmlOption)options.get(0)).getValueAttribute();
        }
        return "";
    }

    public void setDefaultChecked(boolean defaultChecked) {
    }

    public boolean isDefaultChecked() {
        return false;
    }

    public boolean isMultipleSelectEnabled() {
        return this.getAttributeValue("multiple") != ATTRIBUTE_NOT_DEFINED;
    }

    public HtmlOption getOptionByValue(String value) throws ElementNotFoundException {
        Assert.notNull("value", value);
        return (HtmlOption)this.getOneHtmlElementByAttribute("option", "value", value);
    }

    public String asText() {
        List options = this.isMultipleSelectEnabled() ? this.getOptions() : this.getSelectedOptions();
        boolean isFirstTimeThrough = true;
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = options.iterator();
        while (iterator.hasNext()) {
            HtmlOption currentOption;
            if (isFirstTimeThrough) {
                isFirstTimeThrough = false;
            } else {
                buffer.append("\n");
            }
            if ((currentOption = (HtmlOption)iterator.next()) == null) continue;
            buffer.append(currentOption.asText());
        }
        return buffer.toString();
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getSizeAttribute() {
        return this.getAttributeValue("size");
    }

    public final String getMultipleAttribute() {
        return this.getAttributeValue("multiple");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }
}

