/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Map;

public class HtmlScript
extends HtmlElement {
    public static final String TAG_NAME = "script";
    private static int EventHandlerId_;

    public HtmlScript(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public final String getCharsetAttribute() {
        return this.getAttributeValue("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttributeValue("language");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getEventAttribute() {
        return this.getAttributeValue("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttributeValue("for");
    }

    public final String getDeferAttribute() {
        return this.getAttributeValue("defer");
    }

    public DomNode appendChild(DomNode node) {
        DomNode response = super.appendChild(node);
        if (this.getSrcAttribute() == HtmlElement.ATTRIBUTE_NOT_DEFINED && this.isExecutionNeeded()) {
            String scriptCode;
            DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
            if (this.getEventAttribute() != ATTRIBUTE_NOT_DEFINED && this.getHtmlForAttribute() != ATTRIBUTE_NOT_DEFINED) {
                String eventName = this.getEventAttribute();
                if (eventName.endsWith("()")) {
                    eventName = eventName.substring(0, eventName.length() - 2);
                }
                String scriptEventHandler = this.getHtmlForAttribute() + "." + eventName;
                String evhName = "htmlunit_evh_JJLL" + EventHandlerId_;
                scriptCode = "function " + evhName + "()\n{" + textNode.getData() + "}\n" + scriptEventHandler + "=" + evhName + ";";
            } else {
                scriptCode = textNode.getData();
            }
            this.getPage().executeJavaScriptIfPossible(scriptCode, "Embedded script in " + this.getPage().getWebResponse().getUrl().toExternalForm() + " from (" + this.getStartLineNumber() + ", " + this.getStartColumnNumber() + ") to (" + this.getEndLineNumber() + ", " + this.getEndColumnNumber() + ")", false, null);
        }
        return response;
    }

    private boolean isExecutionNeeded() {
        HtmlPage page = this.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        if (!HtmlPage.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            this.getLog().warn((Object)("Script is not javascript (type: " + this.getTypeAttribute() + ", language: " + this.getLanguageAttribute() + "). Skipping execution."));
            return false;
        }
        return true;
    }

    void executeScriptIfNeeded() {
        HtmlPage page = this.getPage();
        if (!this.isExecutionNeeded()) {
            return;
        }
        if (this.getSrcAttribute() != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            this.getLog().debug((Object)("Loading external javascript: " + this.getSrcAttribute()));
            page.loadExternalJavaScriptFile(this.getSrcAttribute(), this.getCharsetAttribute());
        }
    }

    public String asText() {
        return "";
    }
}

