/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.IOException;
import java.util.Map;
import org.mozilla.javascript.Function;

public class HtmlRadioButtonInput
extends HtmlInput {
    private boolean defaultCheckedState_;

    public HtmlRadioButtonInput(HtmlPage page, Map attributes) {
        super(page, attributes);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", "on");
        }
        this.defaultCheckedState_ = this.isAttributeDefined("checked");
    }

    public void reset() {
        if (this.defaultCheckedState_) {
            this.setAttributeValue("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
    }

    public void setChecked(boolean isChecked) {
        boolean changed;
        HtmlForm form = this.getEnclosingForm();
        boolean bl = changed = this.isChecked() != isChecked;
        if (isChecked) {
            try {
                form.setCheckedRadioButton(this.getNameAttribute(), this.getValueAttribute());
            }
            catch (ElementNotFoundException e) {
                throw new IllegalStateException("Can't find this element when going up to the form and back down.");
            }
        } else {
            this.removeAttribute("checked");
        }
        Function onchangeHandler = this.getEventHandler("onchange");
        HtmlPage page = this.getPage();
        if (changed && onchangeHandler != null && page.getWebClient().isJavaScriptEnabled()) {
            this.getPage().runEventHandler(onchangeHandler, new Event(this));
        }
    }

    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        this.setChecked(true);
        return defaultPage;
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isNetscape()) {
            this.setChecked(defaultChecked);
        }
    }

    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    protected boolean isStateUpdateFirst() {
        return true;
    }
}

