/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public final class HtmlPage
extends DomNode
implements Page {
    private final WebClient webClient_;
    private String originalCharset_ = null;
    private final WebResponse webResponse_;
    private final Map idMap_ = new HashMap();
    private HtmlElement documentElement_ = null;
    private FocusableElement elementWithFocus_ = null;
    private WebWindow enclosingWindow_;
    private static int FunctionWrapperCount_ = 0;
    private final Log javascriptLog_ = LogFactory.getLog((String)"com.gargoylesoftware.htmlunit.javascript");
    private static final int TAB_INDEX_NOT_SPECIFIED = -10;
    private static final int TAB_INDEX_OUT_OF_BOUNDS = -20;

    public HtmlPage(URL originatingUrl, WebResponse webResponse, WebWindow webWindow) {
        super(null);
        this.webClient_ = webWindow.getWebClient();
        this.webResponse_ = webResponse;
        this.setEnclosingWindow(webWindow);
    }

    public HtmlPage getPage() {
        return this;
    }

    public void initialize() throws IOException {
        this.loadFrames();
        this.getDocumentElement().setReadyState("complete");
        this.executeOnLoadHandlersIfNeeded();
        this.executeRefreshIfNeeded();
    }

    public void cleanUp() throws IOException {
        this.deregisterFramesIfNeeded();
    }

    public short getNodeType() {
        return 0;
    }

    public String getNodeName() {
        return "#document";
    }

    public HtmlElement getDocumentElement() {
        if (this.documentElement_ == null) {
            DomNode childNode;
            for (childNode = this.getFirstChild(); childNode != null && !(childNode instanceof HtmlElement); childNode = childNode.getNextSibling()) {
            }
            this.documentElement_ = (HtmlElement)childNode;
        }
        return this.documentElement_;
    }

    public String getPageEncoding() {
        if (this.originalCharset_ != null) {
            return this.originalCharset_;
        }
        List list = this.getMetaTags("content-type");
        for (int i = 0; i < list.size(); ++i) {
            HtmlMeta meta = (HtmlMeta)list.get(i);
            String contents = meta.getContentAttribute();
            int pos = contents.toLowerCase().indexOf("charset=");
            if (pos < 0) continue;
            this.originalCharset_ = contents.substring(pos + 8);
            this.getLog().debug((Object)("Page Encoding detected: " + this.originalCharset_));
            return this.originalCharset_;
        }
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.webResponse_.getContentCharSet();
        }
        return this.originalCharset_;
    }

    public HtmlElement createElement(String tagName) {
        String tagLower = tagName.toLowerCase();
        return HTMLParser.getFactory(tagLower).createElement(this, tagLower, null);
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List getAnchors() {
        return this.getDocumentElement().getHtmlElementsByTagNames(Collections.singletonList("a"));
    }

    public HtmlAnchor getFirstAnchorByText(String text) throws ElementNotFoundException {
        Assert.notNull("text", text);
        Iterator iterator = this.getAnchors().iterator();
        while (iterator.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)iterator.next();
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentElement().getHtmlElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List getForms() {
        return this.getDocumentElement().getHtmlElementsByTagNames(Arrays.asList("form"));
    }

    public WebClient getWebClient() {
        return this.webClient_;
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        List baseElements = this.getDocumentElement().getHtmlElementsByTagNames(Collections.singletonList("base"));
        if (baseElements.isEmpty()) {
            baseUrl = this.webResponse_.getUrl();
        } else {
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            String href = htmlBase.getHrefAttribute();
            if (StringUtils.isEmpty((String)href)) {
                baseUrl = this.webResponse_.getUrl();
            } else {
                try {
                    baseUrl = new URL(href);
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((Object)("Invalid base url: \"" + href + "\", ignoring it"));
                    baseUrl = this.webResponse_.getUrl();
                }
            }
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget;
        List baseElements = this.getDocumentElement().getHtmlElementsByTagNames(Collections.singletonList("base"));
        if (baseElements.isEmpty()) {
            resolvedTarget = elementTarget;
        } else if (elementTarget != null && elementTarget.length() > 0) {
            resolvedTarget = elementTarget;
        } else {
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            resolvedTarget = htmlBase.getTargetAttribute();
        }
        return resolvedTarget;
    }

    public WebResponse getWebResponse() {
        return this.webResponse_;
    }

    public List getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>(this.getTabbableElements());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            list.set(i, ((HtmlElement)list.get(i)).getAttributeValue("id"));
        }
        return Collections.unmodifiableList(list);
    }

    public List getTabbableElements() {
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            boolean isDisabled;
            HtmlElement element = iterator.nextElement();
            String tagName = element.getTagName();
            if (!acceptableTagNames.contains(tagName) || (isDisabled = element.isAttributeDefined("disabled")) || this.getTabIndex(element) == -20) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator createTabOrderComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                HtmlElement element1 = (HtmlElement)object1;
                HtmlElement element2 = (HtmlElement)object2;
                int tabIndex1 = HtmlPage.this.getTabIndex(element1);
                int tabIndex2 = HtmlPage.this.getTabIndex(element2);
                int result = tabIndex1 > 0 && tabIndex2 > 0 ? tabIndex1 - tabIndex2 : (tabIndex1 > 0 ? -1 : (tabIndex2 > 0 ? 1 : (tabIndex1 == tabIndex2 ? 0 : tabIndex2 - tabIndex1)));
                return result;
            }
        };
    }

    private int getTabIndex(HtmlElement element) {
        String tabIndexAttribute = element.getAttributeValue("tabindex");
        if (tabIndexAttribute == null || tabIndexAttribute.length() == 0) {
            return -10;
        }
        int tabIndex = Integer.parseInt(tabIndexAttribute);
        if (tabIndex >= 0 && tabIndex <= Short.MAX_VALUE) {
            return tabIndex;
        }
        return -20;
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return (HtmlElement)elements.get(0);
    }

    public List getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = ("" + accessKey).toLowerCase();
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            String accessKeyAttribute;
            HtmlElement element = iterator.nextElement();
            if (!acceptableTagNames.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttributeValue("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public void assertAllTabIndexAttributesSet() {
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        List tabbableElements = this.getDocumentElement().getHtmlElementsByTagNames(acceptableTagNames);
        Iterator iterator = tabbableElements.iterator();
        while (iterator.hasNext()) {
            HtmlElement htmlElement = (HtmlElement)iterator.next();
            int tabIndex = this.getTabIndex(htmlElement);
            if (tabIndex == -20) {
                this.webClient_.assertionFailed("Illegal value for tab index: " + htmlElement.getAttributeValue("tabindex"));
                continue;
            }
            if (tabIndex != -10) continue;
            this.webClient_.assertionFailed("tabindex not set for " + htmlElement);
        }
    }

    public void assertAllAccessKeyAttributesUnique() {
        ArrayList<String> accessKeyList = new ArrayList<String>();
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            String id = iterator.nextElement().getAttributeValue("accesskey");
            if (id == null || id.length() == 0) continue;
            if (accessKeyList.contains(id)) {
                this.webClient_.assertionFailed("Duplicate access key: " + id);
                continue;
            }
            accessKeyList.add(id);
        }
    }

    public void assertAllIdAttributesUnique() {
        ArrayList<String> idList = new ArrayList<String>();
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            String id = iterator.nextElement().getAttributeValue("id");
            if (id == null || id.length() == 0) continue;
            if (idList.contains(id)) {
                this.webClient_.assertionFailed("Duplicate ID: " + id);
                continue;
            }
            idList.add(id);
        }
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, boolean wrapSourceInFunction, HtmlElement htmlElement) {
        Object result;
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (!this.getWebClient().isJavaScriptEnabled() || engine == null) {
            return new ScriptResult(null, this);
        }
        String prefix = "javascript:";
        int prefixLength = "javascript:".length();
        if (sourceCode.length() > prefixLength && sourceCode.substring(0, prefixLength).equalsIgnoreCase("javascript:")) {
            sourceCode = sourceCode.substring(prefixLength);
        }
        WebWindow window = this.getEnclosingWindow();
        this.getWebClient().pushClearFirstWindow();
        if (wrapSourceInFunction) {
            String wrapperName = "GargoyleWrapper" + FunctionWrapperCount_++;
            sourceCode = "function " + wrapperName + "() {" + sourceCode + "\n}";
            this.getJsLog().debug((Object)("Now build JS function\n" + sourceCode));
            engine.execute(this, sourceCode, "Wrapper definition for " + sourceName, htmlElement);
            result = engine.execute(this, wrapperName + "()", sourceName, htmlElement);
        } else {
            result = engine.execute(this, sourceCode, sourceName, htmlElement);
        }
        WebWindow firstWindow = this.getWebClient().popFirstWindow();
        if (firstWindow == null) {
            firstWindow = window;
        }
        return new ScriptResult(result, firstWindow.getEnclosedPage());
    }

    public ScriptResult executeJavaScriptFunctionIfPossible(Function function, Scriptable thisObject, Object[] args, HtmlElement htmlElementScope) {
        WebWindow window = this.getEnclosingWindow();
        this.getWebClient().pushClearFirstWindow();
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (!this.getWebClient().isJavaScriptEnabled() || engine == null) {
            return new ScriptResult(null, this);
        }
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        WebWindow firstWindow = this.getWebClient().popFirstWindow();
        if (firstWindow == null) {
            firstWindow = window;
        }
        return new ScriptResult(result, firstWindow.getEnclosedPage());
    }

    protected Log getJsLog() {
        return this.javascriptLog_;
    }

    void loadExternalJavaScriptFile(String srcAttribute, String charset) {
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (this.getWebClient().isJavaScriptEnabled() && engine != null) {
            URL scriptURL;
            try {
                scriptURL = this.getFullyQualifiedUrl(srcAttribute);
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("Unable to build url for script src tag [" + srcAttribute + "]"));
                if (this.getWebClient().isThrowExceptionOnScriptError()) {
                    throw new ScriptException(this, (Throwable)e);
                }
                return;
            }
            engine.execute(this, this.loadJavaScriptFromUrl(scriptURL, charset), scriptURL.toExternalForm(), null);
        }
    }

    public static boolean isJavaScript(String typeAttribute, String languageAttribute) {
        boolean isJavaScript = languageAttribute != null && languageAttribute.length() != 0 ? TextUtil.startsWithIgnoreCase(languageAttribute, "javascript") : (typeAttribute != null && typeAttribute.length() != 0 ? typeAttribute.equalsIgnoreCase("text/javascript") : true);
        return isJavaScript;
    }

    private String loadJavaScriptFromUrl(URL url, String charset) {
        String scriptEncoding = charset;
        this.getPageEncoding();
        try {
            WebRequestSettings requestSettings = new WebRequestSettings(url);
            WebResponse webResponse = this.getWebClient().loadWebResponse(requestSettings);
            if (webResponse.getStatusCode() == 200) {
                String contentType = webResponse.getContentType();
                String contentCharset = webResponse.getContentCharSet();
                if (!contentType.equalsIgnoreCase("text/javascript") && !contentType.equalsIgnoreCase("application/x-javascript")) {
                    this.getLog().warn((Object)("Expected content type of text/javascript or application/x-javascript for remotely loaded javascript element " + url + " but got [" + webResponse.getContentType() + "]"));
                }
                if (StringUtils.isEmpty((String)scriptEncoding)) {
                    scriptEncoding = !contentCharset.equals("ISO-8859-1") ? contentCharset : (!this.originalCharset_.equals("ISO-8859-1") ? this.originalCharset_ : "ISO-8859-1");
                }
                byte[] data = webResponse.getResponseBody();
                return EncodingUtil.getString((byte[])data, (int)0, (int)data.length, (String)scriptEncoding);
            }
            this.getLog().error((Object)("Error loading javascript from [" + url.toExternalForm() + "] status=[" + webResponse.getStatusCode() + " " + webResponse.getStatusMessage() + "]"));
            throw new FailingHttpStatusCodeException(webResponse);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error loading javascript from [" + url.toExternalForm() + "]: "), (Throwable)e);
            if (this.getWebClient().isThrowExceptionOnScriptError()) {
                throw new ScriptException(this, (Throwable)e);
            }
            return "";
        }
    }

    public WebWindow getEnclosingWindow() {
        return this.enclosingWindow_;
    }

    public void setEnclosingWindow(WebWindow window) {
        this.enclosingWindow_ = window;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            this.getLog().debug((Object)"No title element, creating one");
            HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class);
            if (head == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            titleElement = new HtmlTitle(this, Collections.EMPTY_MAP);
            if (head.getFirstChild() != null) {
                head.getFirstChild().insertBefore(titleElement);
            } else {
                head.appendChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private HtmlElement getFirstChildElement(HtmlElement startElement, Class clazz) {
        HtmlElement.ChildElementsIterator iterator = startElement.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class);
        if (head != null) {
            return (HtmlTitle)this.getFirstChildElement(head, HtmlTitle.class);
        }
        return null;
    }

    private void executeOnLoadHandlersIfNeeded() {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return;
        }
        Window jsWindow = (Window)((Object)this.getEnclosingWindow().getScriptObject());
        if (jsWindow != null) {
            Event loadEvent = new Event(this.getDocumentElement());
            ArrayList onLoadHandlers = new ArrayList(jsWindow.getListeners("load"));
            Iterator iter = onLoadHandlers.iterator();
            while (iter.hasNext()) {
                Function listener = (Function)iter.next();
                this.getLog().debug((Object)("Executing load listener for the window: " + listener));
                this.runEventHandler(listener, loadEvent, true);
            }
            if (jsWindow.jsxGet_onload() != null) {
                this.getLog().debug((Object)"Executing onload handler for the window");
                this.runEventHandler(jsWindow.jsxGet_onload(), loadEvent);
            }
        }
        List list = this.getDocumentElement().getHtmlElementsByTagNames(Arrays.asList("frame", "iframe"));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            BaseFrame frame = (BaseFrame)iter.next();
            this.getLog().debug((Object)("Executing onload handler for " + frame));
            this.executeOneOnLoadHandler(frame);
        }
    }

    private void executeOneOnLoadHandler(HtmlElement element) {
        this.executeEventHandler(element, "onload");
    }

    private void executeEventHandler(HtmlElement element, String handlerName) {
        Function function = element.getEventHandler(handlerName);
        if (function != null) {
            this.getLog().debug((Object)("Executing " + handlerName + " handler, for " + element));
            this.runEventHandler(function, new Event(element));
        }
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        int time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.length() == 0) {
            return;
        }
        int index = refreshString.indexOf(";");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Integer.parseInt(refreshString);
            }
            catch (NumberFormatException e) {
                this.getLog().error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                return;
            }
            url = this.webResponse_.getUrl();
        } else {
            time = Integer.parseInt(refreshString.substring(0, index));
            if ((index = refreshString.indexOf("URL=", index)) == -1) {
                index = refreshString.indexOf("url=", index);
            }
            if (index == -1) {
                this.getLog().error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                return;
            }
            StringBuffer buffer = new StringBuffer(refreshString.substring(index + 4));
            if (buffer.charAt(0) == '\"' || buffer.charAt(0) == '\'') {
                buffer.deleteCharAt(0);
            }
            if (buffer.charAt(buffer.length() - 1) == '\"' || buffer.charAt(buffer.length() - 1) == '\'') {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            String urlString = buffer.toString();
            try {
                url = this.getFullyQualifiedUrl(urlString);
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("Malformed url in refresh string: " + refreshString), (Throwable)e);
                throw e;
            }
        }
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, time);
    }

    private String getRefreshStringOrNull() {
        Iterator iterator = this.getMetaTags("refresh").iterator();
        boolean javaScriptEnabled = this.getWebClient().isJavaScriptEnabled();
        while (iterator.hasNext()) {
            HtmlMeta meta = (HtmlMeta)iterator.next();
            if (javaScriptEnabled && this.getFirstParent(meta, "noscript") != null) continue;
            return meta.getContentAttribute();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private DomNode getFirstParent(DomNode node, String nodeName) {
        for (DomNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.getNodeName().equals(nodeName)) continue;
            return parent;
        }
        return null;
    }

    public void deregisterFramesIfNeeded() {
        Iterator iter = this.getFrames().iterator();
        while (iter.hasNext()) {
            HtmlPage page;
            WebWindow window = (WebWindow)iter.next();
            this.webClient_.deregisterWebWindow(window);
            if (!(window.getEnclosedPage() instanceof HtmlPage) || (page = (HtmlPage)window.getEnclosedPage()) == null) continue;
            page.deregisterFramesIfNeeded();
        }
    }

    public List getFrames() {
        ArrayList<WebWindow> list = new ArrayList<WebWindow>();
        WebWindow enclosingWindow = this.getEnclosingWindow();
        Iterator iter = this.getWebClient().getWebWindows().iterator();
        while (iter.hasNext()) {
            WebWindow window = (WebWindow)iter.next();
            if (enclosingWindow != window.getParentWindow() || enclosingWindow == window) continue;
            list.add(window);
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        List frames = this.getFrames();
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            FrameWindow frame = (FrameWindow)iter.next();
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public HtmlElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        if (element != null) {
            Page newPage;
            if (element instanceof FocusableElement) {
                ((FocusableElement)element).focus();
            }
            if ((newPage = element instanceof HtmlAnchor ? ((HtmlAnchor)element).click() : (element instanceof HtmlArea ? ((HtmlArea)element).click() : (element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : (element instanceof HtmlLabel ? ((HtmlLabel)element).click() : (element instanceof HtmlLegend ? ((HtmlLegend)element).click() : (element instanceof HtmlTextArea ? ((HtmlTextArea)element).click() : this))))))) != this && this.getElementWithFocus() == element) {
                this.getElementWithFocus().blur();
            }
        }
        return this.getElementWithFocus();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.moveFocusToElement(null);
            return null;
        }
        FocusableElement elementWithFocus = this.getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(0) : (index == elements.size() - 1 ? (HtmlElement)elements.get(0) : (HtmlElement)elements.get(index + 1)));
        if (elementToGiveFocus instanceof FocusableElement) {
            this.moveFocusToElement((FocusableElement)elementToGiveFocus);
        }
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.moveFocusToElement(null);
            return null;
        }
        FocusableElement elementWithFocus = this.getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(elements.size() - 1) : (index == 0 ? (HtmlElement)elements.get(elements.size() - 1) : (HtmlElement)elements.get(index - 1)));
        if (elementToGiveFocus instanceof FocusableElement) {
            this.moveFocusToElement((FocusableElement)elementToGiveFocus);
        }
        return elementToGiveFocus;
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        List elements = (List)this.idMap_.get(id);
        if (elements != null) {
            return (HtmlElement)elements.get(0);
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    void addIdElement(HtmlElement idElement) {
        String id = idElement.getId();
        if (!StringUtils.isEmpty((String)id)) {
            Vector<HtmlElement> elements = (Vector<HtmlElement>)this.idMap_.get(id);
            if (elements == null) {
                elements = new Vector<HtmlElement>();
                elements.add(idElement);
                this.idMap_.put(id, elements);
            } else if (!elements.contains(idElement)) {
                elements.add(idElement);
            }
        }
    }

    void removeIdElement(HtmlElement idElement, boolean recursive) {
        List elements = (List)this.idMap_.remove(idElement.getAttributeValue("id"));
        if (elements != null && elements.size() != 1) {
            elements.remove(idElement);
            this.idMap_.put(idElement.getAttributeValue("id"), elements);
        }
        if (recursive) {
            HtmlElement.ChildElementsIterator iter = idElement.getChildElementsIterator();
            while (iter.hasNext()) {
                HtmlElement child = (HtmlElement)iter.next();
                this.removeIdElement(child, true);
            }
        }
    }

    void removeIdElement(HtmlElement idElement) {
        this.removeIdElement(idElement, false);
    }

    Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        Function onchange = htmlElement.getEventHandler("onchange");
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (onchange != null && this.getWebClient().isJavaScriptEnabled() && engine != null && !engine.isScriptRunning()) {
            ScriptResult scriptResult = this.runEventHandler(onchange, new Event(htmlElement));
            if (this.getWebClient().getWebWindows().contains(this.getEnclosingWindow())) {
                return this.getEnclosingWindow().getEnclosedPage();
            }
            return scriptResult.getNewPage();
        }
        return this;
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof HtmlElement) {
            this.addIdElement((HtmlElement)node);
        }
        if (node instanceof HtmlScript) {
            HtmlScript scriptNode = (HtmlScript)node;
            this.getLog().debug((Object)("Script node added: " + scriptNode.asXml()));
            scriptNode.executeScriptIfNeeded();
        }
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeIdElement((HtmlElement)node, true);
        }
    }

    void loadFrames() {
        List<String> frameTags = Arrays.asList("frame", "iframe");
        List frames = this.getDocumentElement().getHtmlElementsByTagNames(frameTags);
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            ((BaseFrame)iter.next()).loadInnerPage();
        }
    }

    public String asXml() {
        return this.getDocumentElement().asXml();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HtmlPage(");
        buffer.append(this.getWebResponse().getUrl());
        buffer.append(")@");
        buffer.append(this.hashCode());
        return buffer.toString();
    }

    protected ScriptResult runEventHandler(Function handler, Event event) {
        return this.runEventHandler(handler, event, false);
    }

    protected ScriptResult runEventHandler(Function handler, Event event, boolean isListener) {
        Window window = (Window)((Object)this.getEnclosingWindow().getScriptObject());
        Object[] args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        if (this.getWebClient().getBrowserVersion().isIE()) {
            window.setEvent((Object)event);
        }
        if (isListener || !this.getWebClient().getBrowserVersion().isIE()) {
            args = new Object[]{event};
        }
        SimpleScriptable target = (SimpleScriptable)((Object)event.jsxGet_target());
        ScriptResult result = this.executeJavaScriptFunctionIfPossible(handler, (Scriptable)target, args, target.getHtmlElementOrDie());
        window.setEvent(null);
        return result;
    }

    public boolean moveFocusToElement(FocusableElement newElement) {
        if (this.elementWithFocus_ == newElement) {
            return true;
        }
        if (newElement != null && newElement.getPage() != this) {
            throw new IllegalArgumentException("Can't move focus to an element from an other page");
        }
        if (this.elementWithFocus_ != null) {
            this.executeEventHandler(this.elementWithFocus_, "onblur");
        }
        this.elementWithFocus_ = newElement;
        if (newElement != null) {
            this.executeEventHandler(this.elementWithFocus_, "onfocus");
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    public FocusableElement getElementWithFocus() {
        return this.elementWithFocus_;
    }

    protected List getMetaTags(String httpEquiv) {
        String nameLC = httpEquiv.toLowerCase();
        List tags = this.getDocumentElement().getHtmlElementsByTagNames(Collections.singletonList("meta"));
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            HtmlMeta element = (HtmlMeta)iter.next();
            if (nameLC.equals(element.getHttpEquivAttribute().toLowerCase())) continue;
            iter.remove();
        }
        return tags;
    }
}

