/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

public class HtmlImage
extends ClickableElement {
    public static final String TAG_NAME = "img";
    private int lastIsMapClickX_ = 0;
    private int lastIsMapClickY_ = 0;

    public HtmlImage(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttributeValue("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeValue("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeValue("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttributeValue("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getBorderAttribute() {
        return this.getAttributeValue("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeValue("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeValue("vspace");
    }

    public Page click(int x, int y) throws IOException {
        this.lastIsMapClickX_ = x;
        this.lastIsMapClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlAnchor anchor = (HtmlAnchor)this.getEnclosingElement("a");
        if (anchor == null) {
            return super.doClickAction(defaultPage);
        }
        if (this.getIsmapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String suffix = "?" + this.lastIsMapClickX_ + "," + this.lastIsMapClickY_;
            return anchor.doClickAction(defaultPage, suffix);
        }
        return anchor.doClickAction(defaultPage);
    }
}

