/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.Function;

public class HtmlForm
extends ClickableElement {
    public static final String TAG_NAME = "form";
    private static final Collection SUBMITTABLE_ELEMENT_NAMES = Arrays.asList("input", "button", "select", "textarea", "isindex");
    private KeyValuePair fakeSelectedRadioButton_ = null;

    public HtmlForm(HtmlPage htmlPage, Map attributes) {
        super(htmlPage, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public Page submit(String buttonName) throws IOException, ElementNotFoundException {
        List inputList = this.getHtmlElementsByAttribute("input", "name", buttonName);
        Iterator iterator = inputList.iterator();
        while (iterator.hasNext()) {
            HtmlInput input = (HtmlInput)iterator.next();
            if (!input.getTypeAttribute().equals("submit")) continue;
            return this.submit(input);
        }
        HtmlButton button = (HtmlButton)this.getOneHtmlElementByAttribute("button", "name", buttonName);
        return this.submit(button);
    }

    public Page submit() throws IOException {
        return this.submit((SubmittableElement)null);
    }

    public Page submit(SubmittableElement submitElement) throws IOException {
        URL url;
        HtmlPage htmlPage = this.getPage();
        if (htmlPage.getWebClient().isJavaScriptEnabled()) {
            ScriptResult scriptResult;
            Function onsubmit;
            if (submitElement != null && (onsubmit = this.getEventHandler("onsubmit")) != null && Boolean.FALSE.equals((scriptResult = this.getPage().runEventHandler(onsubmit, new Event(this))).getJavaScriptResult())) {
                return scriptResult.getNewPage();
            }
            String action = this.getActionAttribute();
            if (TextUtil.startsWithIgnoreCase(action, "javascript:")) {
                return htmlPage.executeJavaScriptIfPossible(action, "Form action", false, this).getNewPage();
            }
        } else if (TextUtil.startsWithIgnoreCase(this.getActionAttribute(), "javascript:")) {
            return htmlPage;
        }
        List parameters = this.getParameterListForSubmit(submitElement);
        SubmitMethod method = SubmitMethod.getInstance(this.getAttributeValue("method"));
        String actionUrl = this.getActionAttribute();
        if (SubmitMethod.GET.equals(method)) {
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"#");
            NameValuePair[] pairs = new NameValuePair[parameters.size()];
            parameters.toArray(pairs);
            String queryFromFields = EncodingUtil.formUrlEncode((NameValuePair[])pairs, (String)this.getPage().getPageEncoding());
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"?") + "?" + queryFromFields;
            parameters.clear();
        }
        try {
            url = htmlPage.getFullyQualifiedUrl(actionUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a valid url: " + actionUrl);
        }
        WebRequestSettings settings = new WebRequestSettings(url, method);
        settings.setRequestParameters(parameters);
        settings.setEncodingType(FormEncodingType.getInstance(this.getEnctypeAttribute()));
        settings.setCharset(this.getSubmitCharset());
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        return htmlPage.getWebClient().getPage(webWindow, htmlPage.getResolvedTarget(this.getTargetAttribute()), settings);
    }

    private String getSubmitCharset() {
        if (this.getAcceptCharsetAttribute().length() > 0) {
            return this.getAcceptCharsetAttribute().trim().replaceAll("[ ,].*", "");
        }
        return this.getPage().getPageEncoding();
    }

    public final List getParameterListForSubmit(SubmittableElement submitElement) {
        Collection submittableElements = this.getSubmittableElements(submitElement);
        ArrayList<KeyValuePair> parameterList = new ArrayList<KeyValuePair>(submittableElements.size());
        Iterator iterator = submittableElements.iterator();
        while (iterator.hasNext()) {
            SubmittableElement element = (SubmittableElement)iterator.next();
            KeyValuePair[] pairs = element.getSubmitKeyValuePairs();
            for (int i = 0; i < pairs.length; ++i) {
                parameterList.add(pairs[i]);
            }
        }
        if (this.fakeSelectedRadioButton_ != null) {
            this.adjustParameterListToAccountForFakeSelectedRadioButton(parameterList);
        }
        return parameterList;
    }

    public Page reset() {
        ScriptResult scriptResult;
        String onReset;
        HtmlPage htmlPage = this.getPage();
        if (htmlPage.getWebClient().isJavaScriptEnabled() && (onReset = this.getOnResetAttribute()).length() != 0 && (scriptResult = htmlPage.executeJavaScriptIfPossible(onReset, "onReset", true, this)).getJavaScriptResult().equals(Boolean.FALSE)) {
            return scriptResult.getNewPage();
        }
        DomNode.DescendantElementsIterator elementIterator = this.getAllHtmlChildElements();
        while (elementIterator.hasNext()) {
            Object next = elementIterator.next();
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)next).reset();
        }
        return htmlPage;
    }

    public Collection getSubmittableElements(SubmittableElement submitElement) {
        ArrayList<HtmlElement> submittableElements = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!this.isSubmittable(element, submitElement)) continue;
            submittableElements.add(element);
        }
        return submittableElements;
    }

    private boolean isValidForSubmission(HtmlElement element, SubmittableElement submitElement) {
        String type;
        String tagName = element.getTagName();
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName.toLowerCase())) {
            return false;
        }
        if (element.isAttributeDefined("disabled")) {
            return false;
        }
        if (element == submitElement && element instanceof HtmlImageInput) {
            return true;
        }
        if (!tagName.equals("isindex") && !element.isAttributeDefined("name")) {
            return false;
        }
        if (!tagName.equals("isindex") && element.getAttributeValue("name").equals("")) {
            return false;
        }
        if (tagName.equals("input") && ((type = element.getAttributeValue("type").toLowerCase()).equals("radio") || type.equals("checkbox"))) {
            return element.isAttributeDefined("checked");
        }
        if (tagName.equals("select")) {
            return ((HtmlSelect)element).isValidForSubmission();
        }
        return true;
    }

    private boolean isSubmittable(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        String type;
        String tagName = element.getTagName();
        if (!this.isValidForSubmission(element, submitElement)) {
            return false;
        }
        if (element == submitElement) {
            return true;
        }
        if (tagName.equals("input") && ((type = (input = (HtmlInput)element).getTypeAttribute().toLowerCase()).equals("submit") || type.equals("image") || type.equals("reset") || type.equals("button"))) {
            return false;
        }
        return !tagName.equals("button");
    }

    public List getInputsByName(String name) {
        return this.getHtmlElementsByAttribute("input", "name", name);
    }

    public final HtmlInput getInputByName(String name) throws ElementNotFoundException {
        List inputs = this.getHtmlElementsByAttribute("input", "name", name);
        if (inputs.size() == 0) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (HtmlInput)inputs.get(0);
    }

    public HtmlRadioButtonInput getRadioButtonInput(String name, String value) throws ElementNotFoundException {
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            HtmlRadioButtonInput input;
            HtmlElement element = iterator.nextElement();
            if (!(element instanceof HtmlRadioButtonInput) || !element.getAttributeValue("name").equals(name) || !(input = (HtmlRadioButtonInput)element).getValueAttribute().equals(value)) continue;
            return input;
        }
        throw new ElementNotFoundException("input", "value", value);
    }

    public List getSelectsByName(String name) {
        return this.getHtmlElementsByAttribute("select", "name", name);
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return (HtmlSelect)list.get(0);
    }

    public List getButtonsByName(String name) throws ElementNotFoundException {
        return this.getHtmlElementsByAttribute("button", "name", name);
    }

    public List getTextAreasByName(String name) {
        return this.getHtmlElementsByAttribute("textarea", "name", name);
    }

    public List getRadioButtonsByName(String name) {
        Assert.notNull("name", name);
        ArrayList<HtmlElement> results = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlRadioButtonInput) || !element.getAttributeValue("name").equals(name)) continue;
            results.add(element);
        }
        return results;
    }

    public void setCheckedRadioButton(String name, String value) throws ElementNotFoundException {
        HtmlRadioButtonInput inputToSelect = this.getRadioButtonInput(name, value);
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            HtmlElement element = iterator.nextElement();
            if (!(element instanceof HtmlRadioButtonInput) || !element.getAttributeValue("name").equals(name)) continue;
            HtmlRadioButtonInput input = (HtmlRadioButtonInput)element;
            if (input == inputToSelect) {
                input.setAttributeValue("checked", "checked");
                continue;
            }
            input.removeAttribute("checked");
        }
    }

    public final void fakeCheckedRadioButton(String name, String value) throws ElementNotFoundException {
        this.fakeSelectedRadioButton_ = new KeyValuePair(name, value);
    }

    private void adjustParameterListToAccountForFakeSelectedRadioButton(List list) {
        String fakeRadioButtonName = this.fakeSelectedRadioButton_.getKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            KeyValuePair pair = (KeyValuePair)((Object)iterator.next());
            if (!pair.getKey().equals(fakeRadioButtonName)) continue;
            iterator.remove();
        }
        list.add(this.fakeSelectedRadioButton_);
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        Assert.notNull("name", name);
        DomNode.DescendantElementsIterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            HtmlRadioButtonInput input;
            HtmlElement element = iterator.nextElement();
            if (!(element instanceof HtmlRadioButtonInput) || !element.getAttributeValue("name").equals(name) || !(input = (HtmlRadioButtonInput)element).isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getActionAttribute() {
        return this.getAttributeValue("action");
    }

    public final void setActionAttribute(String action) {
        this.setAttributeValue("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttributeValue("method");
    }

    public final void setMethodAttribute(String method) {
        this.setAttributeValue("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttributeValue("name", name);
    }

    public final String getEnctypeAttribute() {
        return this.getAttributeValue("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        this.setAttributeValue("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttributeValue("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttributeValue("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttributeValue("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttributeValue("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttributeValue("target");
    }

    public final void setTargetAttribute(String target) {
        this.setAttributeValue("target", target);
    }

    public HtmlInput getInputByValue(String value) throws ElementNotFoundException {
        return (HtmlInput)this.getOneHtmlElementByAttribute("input", "value", value);
    }

    public List getInputsByValue(String value) {
        return this.getHtmlElementsByAttribute("input", "value", value);
    }
}

