/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringEscapeUtils;
import org.mozilla.javascript.Function;

public abstract class HtmlElement
extends DomNode {
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String("");
    private Map attributes_;

    protected HtmlElement(HtmlPage htmlPage, Map attributes) {
        super(htmlPage);
        if (attributes != null) {
            this.attributes_ = attributes;
            this.attributesToEventHandlers();
        } else {
            this.attributes_ = Collections.EMPTY_MAP;
        }
    }

    public DomNode cloneNode(boolean deep) {
        HtmlElement newnode = (HtmlElement)super.cloneNode(deep);
        newnode.attributes_ = new HashMap();
        Iterator it = this.attributes_.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if ("id".equals(key)) continue;
            newnode.setAttributeValue((String)key, (String)this.attributes_.get(key));
        }
        newnode.setId(ATTRIBUTE_VALUE_EMPTY);
        return newnode;
    }

    public final String getAttributeValue(String attributeName) {
        String value = (String)this.attributes_.get(attributeName.toLowerCase());
        if (value != null) {
            return value;
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    public final void setAttributeValue(String attributeName, String attributeValue) {
        boolean isId;
        String value = attributeValue;
        if (this.attributes_ == Collections.EMPTY_MAP) {
            this.attributes_ = new HashMap();
        }
        if (value.length() == 0) {
            value = ATTRIBUTE_VALUE_EMPTY;
        }
        if (isId = attributeName.equalsIgnoreCase("id")) {
            this.getPage().removeIdElement(this);
        }
        this.attributes_.put(attributeName.toLowerCase(), value);
        if (isId) {
            this.getPage().addIdElement(this);
        }
    }

    public final void removeAttribute(String attributeName) {
        if (attributeName.equalsIgnoreCase("id")) {
            this.getPage().removeIdElement(this);
        }
        this.attributes_.remove(attributeName.toLowerCase());
    }

    public boolean isAttributeDefined(String attributeName) {
        return this.attributes_.get(attributeName.toLowerCase()) != null;
    }

    public Iterator getAttributeEntriesIterator() {
        return new MapEntryWrappingIterator(this.attributes_.entrySet().iterator(), this);
    }

    public abstract String getTagName();

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public final String getId() {
        return this.getAttributeValue("id");
    }

    public final void setId(String newId) {
        this.setAttributeValue("id", newId);
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase();
        for (DomNode currentNode = this.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void keyDown(int keyCode) {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return;
        }
        HtmlPage page = this.getPage();
        Function function = this.getEventHandler("onkeydown");
        if (function != null && page.getWebClient().isJavaScriptEnabled()) {
            this.getPage().runEventHandler(function, new Event(this, keyCode));
        }
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<" + this.getTagName().toLowerCase());
        Map attributeMap = this.attributes_;
        Iterator it = attributeMap.keySet().iterator();
        while (it.hasNext()) {
            printWriter.print(" ");
            String name = (String)it.next();
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)attributeMap.get(name).toString()));
            printWriter.print("\"");
        }
        if (!hasChildren) {
            printWriter.print("/");
        }
        printWriter.println(">");
        this.printChildrenAsXml(indent, printWriter);
        if (hasChildren) {
            printWriter.println(indent + "</" + this.getTagName().toLowerCase() + ">");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index == -1) {
            buffer.append(className);
        } else {
            buffer.append(className.substring(index + 1));
        }
        buffer.append("[<");
        buffer.append(this.getTagName());
        Iterator iterator = this.attributes_.keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(' ');
            String name = (String)iterator.next();
            buffer.append(name);
            buffer.append("=\"");
            buffer.append(this.attributes_.get(name));
            buffer.append("\"");
        }
        buffer.append(">]");
        return buffer.toString();
    }

    protected final void notImplemented() {
        throw new RuntimeException("Not implemented yet");
    }

    protected final void assertNotEmpty(String description, String string) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException("String may not be empty: " + description);
        }
    }

    public final HtmlElement getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        Assert.notNull("elementName", elementName);
        Assert.notNull("attributeName", attributeName);
        Assert.notNull("attributeValue", attributeValue);
        List list = this.getHtmlElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return (HtmlElement)list.get(0);
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        return this.getPage().getHtmlElementById(id);
    }

    public boolean hasHtmlElementWithId(String id) {
        try {
            this.getHtmlElementById(id);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    public final List getHtmlElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
        String lowerCaseTagName = elementName.toLowerCase();
        while (iterator.hasNext()) {
            String attValue;
            HtmlElement next = iterator.nextElement();
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttributeValue(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final List getHtmlElementsByTagNames(List acceptableTagNames) {
        ArrayList list = new ArrayList();
        Iterator iterator = acceptableTagNames.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next().toString().toLowerCase();
            list.addAll(this.getHtmlElementsByTagName(next));
        }
        return list;
    }

    public final List getHtmlElementsByTagName(String tagName) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
        String lowerCaseTagName = tagName.toLowerCase();
        while (iterator.hasNext()) {
            HtmlElement next = iterator.nextElement();
            if (!lowerCaseTagName.equals(next.getTagName())) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        List children = this.getHtmlElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = this.getPage().createElement(tagName);
            this.appendChild(child);
        } else {
            child = (HtmlElement)children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        List children = this.getHtmlElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            HtmlElement child = (HtmlElement)children.get(i);
            child.remove();
        }
    }

    public final ChildElementsIterator getChildElementsIterator() {
        return new ChildElementsIterator();
    }

    private void attributesToEventHandlers() {
        Iterator iter = this.attributes_.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String eventName = (String)entry.getKey();
            if (!eventName.startsWith("on")) continue;
            this.setEventHandler(eventName, (String)entry.getValue());
        }
    }

    public static class MapEntryWrappingIterator
    implements Iterator {
        private final Iterator baseIter_;
        private final HtmlElement element_;

        public MapEntryWrappingIterator(Iterator iterator, HtmlElement htmlElement) {
            this.baseIter_ = iterator;
            this.element_ = htmlElement;
        }

        public boolean hasNext() {
            return this.baseIter_.hasNext();
        }

        public Object next() {
            return new HtmlAttr(this.element_, (Map.Entry)this.baseIter_.next());
        }

        public void remove() {
            this.baseIter_.remove();
        }
    }

    protected class ChildElementsIterator
    implements Iterator {
        private HtmlElement nextElement_;

        public ChildElementsIterator() {
            if (HtmlElement.this.getFirstChild() != null) {
                if (HtmlElement.this.getFirstChild() instanceof HtmlElement) {
                    this.nextElement_ = (HtmlElement)HtmlElement.this.getFirstChild();
                } else {
                    this.setNextElement(HtmlElement.this.getFirstChild());
                }
            }
        }

        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            if (this.nextElement_.getPreviousSibling() != null) {
                this.nextElement_.getPreviousSibling().remove();
            }
        }

        public HtmlElement nextElement() {
            if (this.nextElement_ != null) {
                HtmlElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            this.nextElement_ = (HtmlElement)next;
        }
    }
}

