/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

public class HtmlCheckBoxInput
extends HtmlInput {
    private boolean defaultCheckedState_ = this.isAttributeDefined("checked");

    public HtmlCheckBoxInput(HtmlPage page, Map attributes) {
        super(page, attributes);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", "on");
        }
    }

    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    public void setChecked(boolean isChecked) {
        if (isChecked) {
            this.setAttributeValue("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        this.getPage().executeOnChangeHandlerIfAppropriate(this);
    }

    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        if (this.isChecked()) {
            this.setChecked(false);
        } else {
            this.setChecked(true);
        }
        return super.doClickAction(defaultPage);
    }

    protected boolean isStateUpdateFirst() {
        return true;
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isNetscape()) {
            this.setChecked(defaultChecked);
        }
    }

    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }
}

