/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class HtmlArea
extends FocusableElement {
    public static final String TAG_NAME = "area";

    public HtmlArea(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public String getTagName() {
        return TAG_NAME;
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlPage enclosingPage = this.getPage();
        WebClient webClient = enclosingPage.getWebClient();
        String href = this.getHrefAttribute();
        if (href != null && href.length() > 0) {
            URL url;
            HtmlPage page = this.getPage();
            if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
                return page.executeJavaScriptIfPossible(href, "javascript url", true, this).getNewPage();
            }
            try {
                url = enclosingPage.getFullyQualifiedUrl(this.getHrefAttribute());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Not a valid url: " + this.getHrefAttribute());
            }
            WebRequestSettings settings = new WebRequestSettings(url, SubmitMethod.getInstance(this.getAttributeValue("method")));
            WebWindow webWindow = enclosingPage.getEnclosingWindow();
            return webClient.getPage(webWindow, enclosingPage.getResolvedTarget(this.getTargetAttribute()), settings);
        }
        return defaultPage;
    }

    public final String getShapeAttribute() {
        return this.getAttributeValue("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeValue("coords");
    }

    public final String getHrefAttribute() {
        return this.getAttributeValue("href");
    }

    public final String getNoHrefAttribute() {
        return this.getAttributeValue("nohref");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeValue("target");
    }
}

