/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlAddress;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBaseFont;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalOverride;
import com.gargoylesoftware.htmlunit.html.HtmlBlockQuote;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlCaption;
import com.gargoylesoftware.htmlunit.html.HtmlCenter;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionDescription;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionList;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionTerm;
import com.gargoylesoftware.htmlunit.html.HtmlDeletedText;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFieldSet;
import com.gargoylesoftware.htmlunit.html.HtmlFont;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlHeader1;
import com.gargoylesoftware.htmlunit.html.HtmlHeader2;
import com.gargoylesoftware.htmlunit.html.HtmlHeader3;
import com.gargoylesoftware.htmlunit.html.HtmlHeader4;
import com.gargoylesoftware.htmlunit.html.HtmlHeader5;
import com.gargoylesoftware.htmlunit.html.HtmlHeader6;
import com.gargoylesoftware.htmlunit.html.HtmlHorizontalRule;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInlineQuotation;
import com.gargoylesoftware.htmlunit.html.HtmlInsertedText;
import com.gargoylesoftware.htmlunit.html.HtmlIsIndex;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlMenu;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.html.HtmlParameter;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumn;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumnGroup;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeaderCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextDirection;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    private static final Map ELEMENT_FACTORIES = new HashMap();
    private static boolean IgnoreOutsideContent_ = false;

    private static void putFactory(String tagName, Class elementClass) {
        ELEMENT_FACTORIES.put(tagName, new DefaultElementFactory(elementClass));
    }

    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        IgnoreOutsideContent_ = ignoreOutsideContent;
    }

    public static boolean getIgnoreOutsideContent() {
        return IgnoreOutsideContent_;
    }

    public static IElementFactory getFactory(String tagName) {
        IElementFactory result = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    private HTMLParser() {
    }

    public static HtmlPage parse(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(webResponse, webWindow);
        String charSet = webResponse.getContentCharSet();
        if (!HTMLParser.isSupportedCharacterSet(charSet)) {
            charSet = "ISO-8859-1";
        }
        XMLInputSource in = new XMLInputSource(null, webResponse.getUrl().toString(), null, webResponse.getContentAsStream(), charSet);
        try {
            domBuilder.parse(in);
        }
        catch (XNIException e) {
            Throwable origin = HTMLParser.extractNestedException(e);
            throw new RuntimeException("Failed parsing content from " + webResponse.getUrl(), origin);
        }
        return domBuilder.page_;
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    private static boolean isSupportedCharacterSet(String charset) {
        try {
            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), charset);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        HTMLParser.putFactory("a", HtmlAnchor.class);
        HTMLParser.putFactory("applet", HtmlApplet.class);
        HTMLParser.putFactory("address", HtmlAddress.class);
        HTMLParser.putFactory("area", HtmlArea.class);
        HTMLParser.putFactory("base", HtmlBase.class);
        HTMLParser.putFactory("basefont", HtmlBaseFont.class);
        HTMLParser.putFactory("bdo", HtmlBidirectionalOverride.class);
        HTMLParser.putFactory("blockquote", HtmlBlockQuote.class);
        HTMLParser.putFactory("body", HtmlBody.class);
        HTMLParser.putFactory("br", HtmlBreak.class);
        HTMLParser.putFactory("button", HtmlButton.class);
        HTMLParser.putFactory("caption", HtmlCaption.class);
        HTMLParser.putFactory("center", HtmlCenter.class);
        HTMLParser.putFactory("col", HtmlTableColumn.class);
        HTMLParser.putFactory("colgroup", HtmlTableColumnGroup.class);
        HTMLParser.putFactory("dd", HtmlDefinitionDescription.class);
        HTMLParser.putFactory("del", HtmlDeletedText.class);
        HTMLParser.putFactory("dir", HtmlTextDirection.class);
        HTMLParser.putFactory("div", HtmlDivision.class);
        HTMLParser.putFactory("dl", HtmlDefinitionList.class);
        HTMLParser.putFactory("dt", HtmlDefinitionTerm.class);
        HTMLParser.putFactory("fieldset", HtmlFieldSet.class);
        HTMLParser.putFactory("font", HtmlFont.class);
        HTMLParser.putFactory("form", HtmlForm.class);
        HTMLParser.putFactory("frame", HtmlFrame.class);
        HTMLParser.putFactory("frameset", HtmlFrameSet.class);
        HTMLParser.putFactory("h1", HtmlHeader1.class);
        HTMLParser.putFactory("h2", HtmlHeader2.class);
        HTMLParser.putFactory("h3", HtmlHeader3.class);
        HTMLParser.putFactory("h4", HtmlHeader4.class);
        HTMLParser.putFactory("h5", HtmlHeader5.class);
        HTMLParser.putFactory("h6", HtmlHeader6.class);
        HTMLParser.putFactory("head", HtmlHead.class);
        HTMLParser.putFactory("hr", HtmlHorizontalRule.class);
        HTMLParser.putFactory("html", HtmlHtml.class);
        HTMLParser.putFactory("iframe", HtmlInlineFrame.class);
        HTMLParser.putFactory("img", HtmlImage.class);
        HTMLParser.putFactory("ins", HtmlInsertedText.class);
        HTMLParser.putFactory("isindex", HtmlIsIndex.class);
        HTMLParser.putFactory("label", HtmlLabel.class);
        HTMLParser.putFactory("legend", HtmlLegend.class);
        HTMLParser.putFactory("li", HtmlListItem.class);
        HTMLParser.putFactory("link", HtmlLink.class);
        HTMLParser.putFactory("map", HtmlMap.class);
        HTMLParser.putFactory("menu", HtmlMenu.class);
        HTMLParser.putFactory("meta", HtmlMeta.class);
        HTMLParser.putFactory("noframes", HtmlNoFrames.class);
        HTMLParser.putFactory("noscript", HtmlNoScript.class);
        HTMLParser.putFactory("object", HtmlObject.class);
        HTMLParser.putFactory("ol", HtmlOrderedList.class);
        HTMLParser.putFactory("optgroup", HtmlOptionGroup.class);
        HTMLParser.putFactory("option", HtmlOption.class);
        HTMLParser.putFactory("p", HtmlParagraph.class);
        HTMLParser.putFactory("param", HtmlParameter.class);
        HTMLParser.putFactory("pre", HtmlPreformattedText.class);
        HTMLParser.putFactory("q", HtmlInlineQuotation.class);
        HTMLParser.putFactory("script", HtmlScript.class);
        HTMLParser.putFactory("select", HtmlSelect.class);
        HTMLParser.putFactory("span", HtmlSpan.class);
        HTMLParser.putFactory("style", HtmlStyle.class);
        HTMLParser.putFactory("title", HtmlTitle.class);
        HTMLParser.putFactory("table", HtmlTable.class);
        HTMLParser.putFactory("tbody", HtmlTableBody.class);
        HTMLParser.putFactory("td", HtmlTableDataCell.class);
        HTMLParser.putFactory("th", HtmlTableHeaderCell.class);
        HTMLParser.putFactory("tr", HtmlTableRow.class);
        HTMLParser.putFactory("textarea", HtmlTextArea.class);
        HTMLParser.putFactory("tfoot", HtmlTableFooter.class);
        HTMLParser.putFactory("thead", HtmlTableHeader.class);
        HTMLParser.putFactory("ul", HtmlUnorderedList.class);
    }

    private static class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler {
        private final WebResponse webResponse_;
        private final WebWindow webWindow_;
        private HtmlPage page_;
        private Locator locator_;
        private final Stack stack_ = new Stack();
        private DomNode currentNode_;
        private StringBuffer characters_;
        private boolean headParsed_ = false;

        public HtmlUnitDOMBuilder(WebResponse webResponse, WebWindow webWindow) {
            super((XMLParserConfiguration)new HTMLConfiguration());
            boolean reportErrors;
            this.webResponse_ = webResponse;
            this.webWindow_ = webWindow;
            HTMLParserListener listener = webWindow.getWebClient().getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(listener, webResponse.getUrl()));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature("http://cyberneko.org/html/features/augmentations", true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature("http://cyberneko.org/html/features/balance-tags/ignore-outside-content", IgnoreOutsideContent_);
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        public void parse(XMLInputSource inputSource) throws IOException {
            super.parse(inputSource);
        }

        public Locator getLocator() {
            return this.locator_;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        public void startDocument() throws SAXException {
            this.page_ = new HtmlPage(this.webResponse_.getUrl(), this.webResponse_, this.webWindow_);
            this.webWindow_.setEnclosedPage(this.page_);
            this.page_.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.currentNode_ = this.page_;
            this.stack_.push(this.currentNode_);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            HtmlElement newElement;
            IElementFactory factory;
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (tagLower.equals("head")) {
                this.headParsed_ = true;
            } else if (!this.headParsed_ && (tagLower.equals("body") || tagLower.equals("frameset"))) {
                factory = this.getElementFactory("head");
                newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendChild(newElement);
                this.headParsed_ = true;
            } else if (tagLower.equals("tr") && this.currentNode_.getNodeName().equals("table")) {
                factory = this.getElementFactory("tbody");
                newElement = factory.createElement(this.page_, "tbody", null);
                this.currentNode_.appendChild(newElement);
                this.currentNode_ = newElement;
                this.stack_.push(this.currentNode_);
            }
            factory = this.getElementFactory(tagLower);
            newElement = factory.createElement(this.page_, tagLower, atts);
            newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.currentNode_.appendChild(newElement);
            this.currentNode_ = newElement;
            this.stack_.push(this.currentNode_);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            DomNode previousNode = (DomNode)this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            if (!this.currentNode_.getNodeName().equalsIgnoreCase(localName)) {
                this.stack_.pop();
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = (DomNode)this.stack_.peek();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuffer();
            }
            this.characters_.append(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuffer();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() > 0) {
                DomText text = new DomText(this.page_, this.characters_.toString());
                this.currentNode_.appendChild(text);
                this.characters_.setLength(0);
            }
        }

        private IElementFactory getElementFactory(String tagName) {
            IElementFactory factory = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
            if (factory != null) {
                return factory;
            }
            return UnknownElementFactory.instance;
        }

        public void endDocument() throws SAXException {
            this.page_.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void comment(char[] ch, int start, int length) {
            DomComment comment = new DomComment(this.page_, String.valueOf(ch, start, length));
            this.currentNode_.appendChild(comment);
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void startDTD(String name, String publicId, String systemId) {
        }

        public void startEntity(String name) {
        }
    }
}

