/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;

public class DomText
extends DomCharacterData {
    public static final String NODE_NAME = "#text";

    public DomText(HtmlPage page, String data) {
        super(page, data);
    }

    public DomText splitText(int offset) {
        if (offset < 0 || offset > this.getLength()) {
            throw new IllegalArgumentException("offset: " + offset + " data.length: " + this.getLength());
        }
        DomText newText = new DomText(this.getPage(), this.getData().substring(offset));
        this.setData(this.getData().substring(0, offset));
        if (this.getParentNode() != null) {
            newText.setParentNode(this.getParentNode());
            newText.setPreviousSibling(this);
            newText.setNextSibling(this.getNextSibling());
            this.setNextSibling(newText);
        }
        return newText;
    }

    public String asText() {
        String text = this.getData();
        if (!(this.getParentNode() instanceof HtmlTextArea)) {
            text = DomText.reduceWhitespace(text);
        }
        return text;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return NODE_NAME;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent);
        printWriter.println(StringEscapeUtils.escapeXml((String)this.getData()));
        this.printChildrenAsXml(indent, printWriter);
    }

    public String toString() {
        return this.asText();
    }
}

