/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.mozilla.javascript.Function;

public abstract class DomNode
implements Cloneable {
    public static final short DOCUMENT_NODE = 0;
    public static final short ELEMENT_NODE = 1;
    public static final short TEXT_NODE = 3;
    public static final short ATTRIBUTE_NODE = 4;
    public static final short COMMENT_NODE = 5;
    public static final String READY_STATE_UNINITIALIZED = "uninitialized";
    public static final String READY_STATE_LOADING = "loading";
    public static final String READY_STATE_COMPLETE = "complete";
    private final HtmlPage htmlPage_;
    private DomNode parent_;
    private DomNode previousSibling_;
    private DomNode nextSibling_;
    private DomNode firstChild_;
    private Object scriptObject_;
    private Map eventHandlers_;
    private String readyState_ = "loading";
    private PropertyChangeSupport propertyChangeSupport_ = null;
    public static final String PROPERTY_ELEMENT = "element";
    private int startLineNumber_;
    private int startColumnNumber_;
    private int endLineNumber_;
    private int endColumnNumber_;

    protected DomNode(HtmlPage htmlPage) {
        this.htmlPage_ = htmlPage;
        this.eventHandlers_ = Collections.EMPTY_MAP;
        this.startLineNumber_ = 0;
        this.startColumnNumber_ = 0;
        this.endLineNumber_ = 0;
        this.endColumnNumber_ = 0;
    }

    void setStartLocation(int startLineNumber, int startColumnNumber) {
        this.startLineNumber_ = startLineNumber;
        this.startColumnNumber_ = startColumnNumber;
    }

    void setEndLocation(int endLineNumber, int endColumnNumber) {
        this.endLineNumber_ = endLineNumber;
        this.endColumnNumber_ = endColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber_;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber_;
    }

    public int getEndLineNumber() {
        return this.endLineNumber_;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber_;
    }

    public HtmlPage getPage() {
        return this.htmlPage_;
    }

    public void setScriptObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    public DomNode getLastChild() {
        if (this.firstChild_ != null) {
            return this.firstChild_.previousSibling_;
        }
        return null;
    }

    public DomNode getParentNode() {
        return this.parent_;
    }

    protected void setParentNode(DomNode parent) {
        this.parent_ = parent;
    }

    public DomNode getPreviousSibling() {
        if (this.parent_ == null || this == this.parent_.firstChild_) {
            return null;
        }
        return this.previousSibling_;
    }

    public DomNode getNextSibling() {
        return this.nextSibling_;
    }

    public DomNode getFirstChild() {
        return this.firstChild_;
    }

    protected void setPreviousSibling(DomNode previous) {
        this.previousSibling_ = previous;
    }

    protected void setNextSibling(DomNode next) {
        this.nextSibling_ = next;
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String asText() {
        String text = this.getChildrenAsText();
        text = DomNode.reduceWhitespace(text);
        return text;
    }

    protected final String getChildrenAsText() {
        StringBuffer buffer = new StringBuffer();
        Iterator childIterator = this.getChildIterator();
        if (!childIterator.hasNext()) {
            return "";
        }
        boolean isText = false;
        StringBuffer textBuffer = new StringBuffer();
        while (childIterator.hasNext()) {
            DomNode node = (DomNode)childIterator.next();
            if (node instanceof DomText) {
                textBuffer.append(((DomText)node).getData());
                isText = true;
                continue;
            }
            if (isText) {
                buffer.append(DomNode.reduceWhitespace(textBuffer.toString()));
                textBuffer.setLength(0);
                isText = false;
            }
            buffer.append(" ");
            buffer.append(node.asText());
            buffer.append(" ");
        }
        if (isText) {
            String text = textBuffer.toString();
            if (!(this instanceof HtmlTextArea)) {
                text = DomNode.reduceWhitespace(text);
            }
            buffer.append(text);
        }
        return buffer.toString();
    }

    protected static String reduceWhitespace(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        int length = text.length();
        boolean whitespace = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\u00a0') {
                ch = ' ';
            }
            if (whitespace) {
                if (Character.isWhitespace(ch)) continue;
                buffer.append(ch);
                whitespace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                whitespace = true;
                buffer.append(' ');
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString().trim();
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public String asXml() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXml("", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.println(indent + this);
        this.printChildrenAsXml(indent, printWriter);
    }

    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.printXml(indent + "  ", printWriter);
        }
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String x) {
    }

    public DomNode cloneNode(boolean deep) {
        DomNode newnode;
        try {
            newnode = (DomNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported for node [" + this + "]");
        }
        newnode.parent_ = null;
        newnode.nextSibling_ = null;
        newnode.previousSibling_ = null;
        newnode.firstChild_ = null;
        newnode.scriptObject_ = null;
        if (deep) {
            DomNode child = this.firstChild_;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling_;
            }
        }
        return newnode;
    }

    public Object getScriptObject() {
        if (this.scriptObject_ == null) {
            if (this == this.getPage()) {
                throw new IllegalStateException("No script object associated with the HtmlPage");
            }
            this.scriptObject_ = ((SimpleScriptable)((Object)this.getPage().getScriptObject())).makeScriptableFor(this);
        }
        return this.scriptObject_;
    }

    public DomNode appendChild(DomNode node) {
        if (node != this) {
            node.basicRemove();
        }
        if (this.firstChild_ == null) {
            this.firstChild_ = node;
            this.firstChild_.previousSibling_ = node;
        } else {
            DomNode last = this.getLastChild();
            last.nextSibling_ = node;
            node.previousSibling_ = last;
            node.nextSibling_ = null;
            this.firstChild_.previousSibling_ = node;
        }
        node.parent_ = this;
        this.getHtmlPage().notifyNodeAdded(node);
        return node;
    }

    private HtmlPage getHtmlPage() {
        if (this instanceof HtmlPage) {
            return (HtmlPage)this;
        }
        return this.htmlPage_;
    }

    public void insertBefore(DomNode newNode) throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException();
        }
        if (newNode != this) {
            newNode.basicRemove();
        }
        if (this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = newNode;
        } else {
            this.previousSibling_.nextSibling_ = newNode;
        }
        newNode.previousSibling_ = this.previousSibling_;
        newNode.nextSibling_ = this;
        this.previousSibling_ = newNode;
        newNode.parent_ = this.parent_;
        this.getHtmlPage().notifyNodeAdded(newNode);
    }

    public void remove() throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException();
        }
        this.basicRemove();
        this.getHtmlPage().notifyNodeRemoved(this);
    }

    private void basicRemove() {
        if (this.parent_ != null && this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = this.nextSibling_;
        } else if (this.previousSibling_ != null && this.previousSibling_.nextSibling_ == this) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null && this.nextSibling_.previousSibling_ == this) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        if (this.parent_ != null && this == this.parent_.getLastChild()) {
            this.parent_.firstChild_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
        this.parent_ = null;
    }

    public void replace(DomNode newNode) throws IllegalStateException {
        this.insertBefore(newNode);
        this.remove();
    }

    public Iterator getChildIterator() {
        return new ChildIterator();
    }

    public final Function getEventHandler(String eventName) {
        return (Function)this.eventHandlers_.get(eventName);
    }

    public final void setEventHandler(String eventName, Function eventHandler) {
        if (this.eventHandlers_ == Collections.EMPTY_MAP) {
            this.eventHandlers_ = new HashMap();
        }
        this.eventHandlers_.put(eventName, eventHandler);
    }

    public final void setEventHandler(String eventName, String jsSnippet) {
        EventHandler function = new EventHandler(this, jsSnippet);
        this.setEventHandler(eventName, (Function)function);
        this.getLog().debug((Object)("Created event handler " + function.getFunctionName() + " for " + eventName + " on " + this));
    }

    public final void removeEventHandler(String eventName) {
        this.eventHandlers_.remove(eventName);
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ == null) {
            this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.removePropertyChangeListener(listener);
        }
    }

    protected final synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public DescendantElementsIterator getAllHtmlChildElements() {
        return new DescendantElementsIterator();
    }

    public String getReadyState() {
        return this.readyState_;
    }

    public void setReadyState(String state) {
        this.readyState_ = state;
    }

    public void removeAllChildren() {
        if (this.getFirstChild() == null) {
            return;
        }
        Iterator it = this.getChildIterator();
        while (it.hasNext()) {
            DomNode child = (DomNode)it.next();
            child.removeAllChildren();
            it.remove();
        }
    }

    public List getByXPath(String xpathExpr) throws JaxenException {
        if (xpathExpr == null) {
            throw new NullPointerException("Null is not a valid xpath expression");
        }
        Navigator navigator = HtmlUnitXPath.buildSubtreeNavigator(this);
        HtmlUnitXPath xpath = new HtmlUnitXPath(xpathExpr, navigator);
        return xpath.selectNodes(this);
    }

    protected class DescendantElementsIterator
    implements Iterator {
        private HtmlElement nextElement_;

        protected DescendantElementsIterator() {
            this.nextElement_ = this.getFirstChildElement(DomNode.this);
        }

        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            if (this.nextElement_.getPreviousSibling() != null) {
                this.nextElement_.getPreviousSibling().remove();
            }
        }

        public HtmlElement nextElement() {
            HtmlElement result = this.nextElement_;
            this.setNextElement();
            return result;
        }

        private void setNextElement() {
            HtmlElement next = this.getFirstChildElement(this.nextElement_);
            if (next == null) {
                next = this.getNextSibling(this.nextElement_);
            }
            if (next == null) {
                next = this.getNextElementUpwards(this.nextElement_);
            }
            this.nextElement_ = next;
        }

        private HtmlElement getNextElementUpwards(DomNode startingNode) {
            DomNode next;
            if (startingNode == DomNode.this) {
                return null;
            }
            DomNode parent = startingNode.getParentNode();
            if (parent == DomNode.this) {
                return null;
            }
            for (next = parent.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            if (next == null) {
                return this.getNextElementUpwards(parent);
            }
            return (HtmlElement)next;
        }

        private HtmlElement getFirstChildElement(DomNode parent) {
            DomNode node;
            for (node = parent.getFirstChild(); node != null && !(node instanceof HtmlElement); node = node.getNextSibling()) {
            }
            return (HtmlElement)node;
        }

        private HtmlElement getNextSibling(HtmlElement element) {
            DomNode node;
            for (node = element.getNextSibling(); node != null && !(node instanceof HtmlElement); node = node.getNextSibling()) {
            }
            return (HtmlElement)node;
        }
    }

    protected class ChildIterator
    implements Iterator {
        private DomNode nextNode_;
        private DomNode currentNode_;

        protected ChildIterator() {
            this.nextNode_ = DomNode.this.firstChild_;
            this.currentNode_ = null;
        }

        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        public Object next() {
            if (this.nextNode_ != null) {
                this.currentNode_ = this.nextNode_;
                this.nextNode_ = this.nextNode_.nextSibling_;
                return this.currentNode_;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException();
            }
            this.currentNode_.remove();
        }
    }
}

