/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.xml.sax.Attributes;

class DefaultElementFactory
implements IElementFactory {
    private static final Class[] CONSTRUCTOR_ARGS = new Class[]{HtmlPage.class, Map.class};
    private final Constructor constructor_;

    public DefaultElementFactory(Class elementClass) {
        if (!HtmlElement.class.isAssignableFrom(elementClass)) {
            throw new ClassCastException(elementClass + " is not a subclass of " + HtmlElement.class);
        }
        try {
            this.constructor_ = elementClass.getConstructor(CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new ObjectInstantiationException("required constructor not found in " + elementClass, e);
        }
    }

    public HtmlElement createElement(HtmlPage page, String tagName, Attributes attributes) {
        try {
            OrderedMap attributeMap = null;
            if (attributes != null) {
                attributeMap = ListOrderedMap.decorate(new HashMap(attributes.getLength()));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attributeMap.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            HtmlElement element = (HtmlElement)this.constructor_.newInstance(page, attributeMap);
            return element;
        }
        catch (IllegalAccessException e) {
            throw new ObjectInstantiationException("Exception when calling constructor [" + this.constructor_ + "]", e);
        }
        catch (InstantiationException e) {
            throw new ObjectInstantiationException("Exception when calling constructor [" + this.constructor_ + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException("Exception when calling constructor [" + this.constructor_ + "]", e.getTargetException());
        }
    }
}

