/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.IOException;
import java.util.Map;
import org.mozilla.javascript.Function;

public abstract class ClickableElement
extends StyledElement {
    protected ClickableElement(HtmlPage page, Map attributes) {
        super(page, attributes);
    }

    public Page click() throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = this.getPage();
        Function function = this.getEventHandler("onclick");
        if (function != null && page.getWebClient().isJavaScriptEnabled()) {
            boolean stateUpdated = false;
            if (this.isStateUpdateFirst()) {
                this.doClickAction(page);
                stateUpdated = true;
            }
            ScriptResult scriptResult = this.getPage().runEventHandler(function, new Event(this));
            Page scriptPage = scriptResult.getNewPage();
            if (stateUpdated || Boolean.FALSE.equals(scriptResult.getJavaScriptResult())) {
                return scriptPage;
            }
            return this.doClickAction(scriptPage);
        }
        return this.doClickAction(page);
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        return defaultPage;
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }
}

