/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class BaseFrame
extends StyledElement {
    private final WebWindow enclosedWindow_ = new FrameWindow(this);

    protected BaseFrame(HtmlPage page, Map attributes) {
        super(page, attributes);
        try {
            this.getPage().getWebClient().pushClearFirstWindow();
            this.getPage().getWebClient().getPage(this.enclosedWindow_, new WebRequestSettings(WebClient.URL_ABOUT_BLANK));
            this.getPage().getWebClient().popFirstWindow();
        }
        catch (FailingHttpStatusCodeException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void loadInnerPage() {
        String source = this.getSrcAttribute();
        if (source.length() == 0) {
            source = "about:blank";
        }
        this.getPage().getWebClient().pushClearFirstWindow();
        this.loadInnerPageIfPossible(source);
        this.getPage().getWebClient().popFirstWindow();
    }

    private void loadInnerPageIfPossible(String srcAttribute) {
        if (srcAttribute.length() != 0) {
            URL url = null;
            try {
                url = this.getPage().getFullyQualifiedUrl(srcAttribute);
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("Bad url in src attribute of " + this.getTagName() + ": url=[" + srcAttribute + "]"), (Throwable)e);
            }
            try {
                this.getPage().getWebClient().getPage(this.enclosedWindow_, new WebRequestSettings(url));
            }
            catch (FailingHttpStatusCodeException e) {
            }
            catch (IOException e) {
                this.getLog().error((Object)("IOException when getting content for " + this.getTagName() + ": url=[" + url.toExternalForm() + "]"), (Throwable)e);
            }
        }
    }

    public abstract String getTagName();

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttributeValue("name", name);
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getFrameBorderAttribute() {
        return this.getAttributeValue("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttributeValue("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttributeValue("marginheight");
    }

    public final String getNoResizeAttribute() {
        return this.getAttributeValue("noresize");
    }

    public final String getScrollingAttribute() {
        return this.getAttributeValue("scrolling");
    }

    public final String getOnLoadAttribute() {
        return this.getAttributeValue("onload");
    }

    public Page getEnclosedPage() {
        return this.getEnclosedWindow().getEnclosedPage();
    }

    public WebWindow getEnclosedWindow() {
        return this.enclosedWindow_;
    }

    public final void setSrcAttribute(String attribute) {
        this.setAttributeValue("src", attribute);
        this.loadInnerPageIfPossible(attribute);
    }

    public final class FrameWindow
    extends com.gargoylesoftware.htmlunit.html.FrameWindow {
        FrameWindow(BaseFrame frame) {
            super(frame);
        }
    }
}

