/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponseImpl
implements WebResponse {
    private final Log log_ = LogFactory.getLog((Class)WebResponseImpl.class);
    private URL url_;
    private SubmitMethod requestMethod_;
    private long loadTime_;
    private WebResponseData responseData_;

    public WebResponseImpl(WebResponseData responseData, URL url, SubmitMethod requestMethod, long loadTime) {
        this.responseData_ = responseData;
        this.url_ = url;
        this.requestMethod_ = requestMethod;
        this.loadTime_ = loadTime;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    public String getContentAsString() {
        try {
            return new String(this.responseData_.getBody(), this.getContentCharSet());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public InputStream getContentAsStream() throws IOException {
        return new ByteArrayInputStream(this.responseData_.getBody());
    }

    public URL getUrl() {
        return this.url_;
    }

    public SubmitMethod getRequestMethod() {
        return this.requestMethod_;
    }

    public List getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        Iterator iterator = this.responseData_.getResponseHeaders().iterator();
        while (iterator.hasNext()) {
            NameValuePair pair = (NameValuePair)iterator.next();
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public long getLoadTimeInMilliSeconds() {
        return this.loadTime_;
    }

    public String getContentCharSet() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        String charSet = StringUtils.substringAfter((String)contentTypeHeader, (String)"charset=");
        if (StringUtils.isEmpty((String)charSet)) {
            this.log_.debug((Object)"No charset specified in header, trying to guess it from content");
            byte[] markerUTF8 = new byte[]{-17, -69, -65};
            if (ArrayUtils.isEquals((Object)markerUTF8, (Object)ArrayUtils.subarray((byte[])this.responseData_.getBody(), (int)0, (int)3))) {
                this.log_.debug((Object)"UTF-8 marker found");
                charSet = "UTF-8";
            } else {
                this.log_.debug((Object)"Nothing guessed, supposing that it is ISO-8859-1");
                charSet = "ISO-8859-1";
            }
        }
        return charSet;
    }

    public byte[] getResponseBody() {
        return this.responseData_.getBody();
    }
}

