/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.ImmediateRefreshHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.protocol.javascript.Handler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebClient {
    private WebConnection webConnection_;
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private CredentialsProvider credentialsProvider_ = new DefaultCredentialsProvider();
    private final String proxyHost_;
    private final int proxyPort_;
    private final Map proxyBypassHosts_;
    private ScriptEngine scriptEngine_;
    private boolean javaScriptEnabled_ = true;
    private String homePage_;
    private FocusableElement elementWithFocus_;
    private final Map requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private static final int ALLOWED_REDIRECTIONS_SAME_URL = 20;
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private StatusHandler statusHandler_;
    private BrowserVersion browserVersion_ = BrowserVersion.getDefault();
    private boolean isRedirectEnabled_ = true;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private final Set webWindowListeners_ = new HashSet(5);
    private final List webWindows_ = Collections.synchronizedList(new ArrayList());
    private WebWindow currentWindow_;
    private Stack firstWindowStack_ = new Stack();
    private int timeout_ = 0;
    private HTMLParserListener htmlParserListener_;
    private static URLStreamHandler JavaScriptUrlStreamHandler_ = new Handler();
    private static URLStreamHandler AboutUrlStreamHandler_ = new com.gargoylesoftware.htmlunit.protocol.about.Handler();
    public static final URL URL_ABOUT_BLANK;
    private static final WebResponse WEB_RESPONSE_FOR_ABOUT_BLANK;
    private ScriptPreProcessor scriptPreProcessor_;
    private Map activeXObjectMap_ = Collections.EMPTY_MAP;
    private RefreshHandler refreshHandler_ = new ImmediateRefreshHandler();
    private boolean throwExceptionOnScriptError_ = true;

    public WebClient() {
        this(BrowserVersion.FULL_FEATURED_BROWSER);
    }

    public WebClient(BrowserVersion browserVersion) {
        Assert.notNull("browserVersion", browserVersion);
        this.homePage_ = "http://www.gargoylesoftware.com/";
        this.browserVersion_ = browserVersion;
        this.proxyHost_ = null;
        this.proxyPort_ = 0;
        this.proxyBypassHosts_ = new HashMap();
        try {
            this.scriptEngine_ = WebClient.createJavaScriptEngineIfPossible(this);
        }
        catch (NoClassDefFoundError e) {
            this.scriptEngine_ = null;
        }
        this.currentWindow_ = new TopLevelWindow("", this);
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        Assert.notNull("browserVersion", browserVersion);
        Assert.notNull("proxyHost", proxyHost);
        this.homePage_ = "http://www.gargoylesoftware.com/";
        this.browserVersion_ = browserVersion;
        this.proxyHost_ = proxyHost;
        this.proxyPort_ = proxyPort;
        this.proxyBypassHosts_ = new HashMap();
        try {
            this.scriptEngine_ = WebClient.createJavaScriptEngineIfPossible(this);
        }
        catch (NoClassDefFoundError e) {
            this.scriptEngine_ = null;
        }
        this.currentWindow_ = new TopLevelWindow("", this);
    }

    private static JavaScriptEngine createJavaScriptEngineIfPossible(WebClient webClient) {
        try {
            Class.forName("org.mozilla.javascript.Context");
            return new JavaScriptEngine(webClient);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public synchronized WebConnection getWebConnection() {
        if (this.webConnection_ == null) {
            this.webConnection_ = new HttpWebConnection(this);
        }
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        Assert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public Page getPage(WebWindow webWindow, WebRequestSettings parameters) throws IOException, FailingHttpStatusCodeException {
        boolean wasResponseSuccessful;
        this.getLog().debug((Object)("Get page for window named '" + webWindow.getName() + "', using " + parameters));
        String protocol = parameters.getURL().getProtocol();
        WebResponse webResponse = protocol.equals("javascript") ? this.makeWebResponseForJavaScriptUrl(webWindow, parameters.getURL()) : this.loadWebResponse(parameters);
        String contentType = webResponse.getContentType();
        int statusCode = webResponse.getStatusCode();
        boolean bl = wasResponseSuccessful = statusCode >= 200 && statusCode < 300;
        if (this.printContentOnFailingStatusCode_ && !wasResponseSuccessful) {
            this.getLog().info((Object)("statusCode=[" + statusCode + "] contentType=[" + contentType + "]"));
            this.getLog().info((Object)webResponse.getContentAsString());
        }
        this.loadWebResponseInto(webResponse, webWindow);
        if (this.isThrowExceptionOnFailingStatusCode() && !wasResponseSuccessful) {
            throw new FailingHttpStatusCodeException(webResponse);
        }
        return webWindow.getEnclosedPage();
    }

    public Page getPage(WebWindow opener, String target, WebRequestSettings params) throws FailingHttpStatusCodeException, IOException {
        return this.getPage(this.openTargetWindow(opener, target, "_self"), params);
    }

    public Page getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        return this.getPage(new URL(url));
    }

    public Page getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow(), new WebRequestSettings(url));
    }

    public Page getPage(WebRequestSettings request) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow(), request);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException {
        Assert.notNull("webResponse", webResponse);
        Assert.notNull("webWindow", webWindow);
        Page oldPage = webWindow.getEnclosedPage();
        if (oldPage != null) {
            oldPage.cleanUp();
        }
        Page newPage = this.pageCreator_.createPage(webResponse, webWindow);
        if (!this.firstWindowStack_.empty() && this.firstWindowStack_.peek() == null) {
            this.firstWindowStack_.pop();
            this.firstWindowStack_.push(webWindow);
        }
        if (webWindow.getEnclosedPage() == newPage) {
            newPage.initialize();
        }
        this.fireWindowContentChanged(new WebWindowEvent(webWindow, 3, oldPage, newPage));
        return newPage;
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean getPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean getThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public boolean isThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        Assert.notNull("credentialsProvider", credentialsProvider);
        this.credentialsProvider_ = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public void assertionFailed(String message) {
        try {
            Class clazz = AssertionFailedError.class;
            Constructor constructor = clazz.getConstructor(String.class);
            Error error = (Error)constructor.newInstance(message);
            throw error;
        }
        catch (Exception e) {
            throw new IllegalStateException(message);
        }
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine_;
    }

    public void setScriptEngine(ScriptEngine engine) {
        this.scriptEngine_ = engine;
    }

    public void setJavaScriptEnabled(boolean isEnabled) {
        this.javaScriptEnabled_ = isEnabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_ && this.scriptEngine_ != null;
    }

    public String getHomePage() {
        return this.homePage_;
    }

    public void setHomePage(String homePage) {
        this.homePage_ = homePage;
    }

    public void addHostsToProxyBypass(String pattern) {
        this.proxyBypassHosts_.put(pattern, Pattern.compile(pattern));
    }

    public void removeHostsFromProxyBypass(String pattern) {
        this.proxyBypassHosts_.remove(pattern);
    }

    private boolean shouldBypassProxy(String hostname) {
        boolean bypass = false;
        Iterator i = this.proxyBypassHosts_.values().iterator();
        while (i.hasNext()) {
            Pattern p = (Pattern)i.next();
            if (!p.matcher(hostname).find()) continue;
            bypass = true;
            break;
        }
        return bypass;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler_ = statusHandler;
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        Assert.notNull("window", window);
        this.currentWindow_ = window;
    }

    public WebWindow popFirstWindow() {
        return (WebWindow)this.firstWindowStack_.pop();
    }

    public void pushClearFirstWindow() {
        this.firstWindowStack_.push(null);
    }

    public void addWebWindowListener(WebWindowListener listener) {
        Assert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        Assert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        Iterator iterator = new ArrayList(this.webWindowListeners_).iterator();
        while (iterator.hasNext()) {
            WebWindowListener listener = (WebWindowListener)iterator.next();
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        Iterator iterator = new ArrayList(this.webWindowListeners_).iterator();
        while (iterator.hasNext()) {
            WebWindowListener listener = (WebWindowListener)iterator.next();
            listener.webWindowOpened(event);
        }
    }

    private void fireWindowClosed(WebWindowEvent event) {
        Iterator iterator = new ArrayList(this.webWindowListeners_).iterator();
        while (iterator.hasNext()) {
            WebWindowListener listener = (WebWindowListener)iterator.next();
            listener.webWindowClosed(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        Assert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, this.getCurrentWindow());
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window = this.openTargetWindow(opener, windowName, "_blank");
        if (url != null) {
            try {
                this.getPage(window, new WebRequestSettings(url));
            }
            catch (IOException e) {
                this.getLog().error((Object)"Error when loading content into window", (Throwable)e);
            }
        } else {
            this.initializeEmptyWindow(window);
        }
        return window;
    }

    private WebWindow openTargetWindow(WebWindow opener, String windowName, String defaultName) {
        Assert.notNull("opener", opener);
        Assert.notNull("defaultName", defaultName);
        String windowToOpen = windowName;
        if (windowToOpen == null || windowToOpen.length() == 0) {
            windowToOpen = defaultName;
        }
        WebWindow webWindow = null;
        if (windowToOpen.equals("_self")) {
            webWindow = opener;
            windowToOpen = "";
        } else if (windowToOpen.equals("_parent")) {
            webWindow = opener.getParentWindow();
            windowToOpen = "";
        } else if (windowToOpen.equals("_top")) {
            webWindow = opener.getTopWindow();
            windowToOpen = "";
        } else if (windowToOpen.equals("_blank")) {
            windowToOpen = "";
        } else if (windowToOpen.length() != 0) {
            try {
                webWindow = this.getWebWindowByName(windowToOpen);
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        if (webWindow == null) {
            webWindow = new TopLevelWindow(windowToOpen, this);
            this.fireWindowOpened(new WebWindowEvent(webWindow, 1, null, null));
        }
        if (webWindow instanceof TopLevelWindow && webWindow != opener.getTopWindow()) {
            ((TopLevelWindow)webWindow).setOpener(opener);
        }
        return webWindow;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setPageCreator(PageCreator pageCreator) {
        Assert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        Assert.notNull("name", name);
        Iterator iterator = this.webWindows_.iterator();
        while (iterator.hasNext()) {
            WebWindow webWindow = (WebWindow)iterator.next();
            if (!webWindow.getName().equals(name)) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void initialize(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.initialize(webWindow);
        }
    }

    public void initialize(Page newPage) {
        Assert.notNull("newPage", newPage);
        if (this.scriptEngine_ != null) {
            ((Window)((Object)newPage.getEnclosingWindow().getScriptObject())).initialize(newPage);
        }
    }

    public void initializeEmptyWindow(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        if (this.scriptEngine_ != null) {
            this.initialize(webWindow);
            ((Window)((Object)webWindow.getScriptObject())).initialize();
        }
    }

    public void registerWebWindow(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        this.webWindows_.add(webWindow);
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        this.webWindows_.remove(webWindow);
        if (this.getCurrentWindow() == webWindow) {
            if (this.webWindows_.size() == 0) {
                this.setCurrentWindow(new TopLevelWindow("", this));
            } else {
                this.setCurrentWindow((WebWindow)this.webWindows_.get(0));
            }
        }
        this.fireWindowClosed(new WebWindowEvent(webWindow, 2, webWindow.getEnclosedPage(), null));
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private static URL makeUrl(String urlString) throws MalformedURLException {
        Assert.notNull("urlString", urlString);
        if (TextUtil.startsWithIgnoreCase(urlString, "javascript:")) {
            return new URL(null, urlString, JavaScriptUrlStreamHandler_);
        }
        if (TextUtil.startsWithIgnoreCase(urlString, "about:")) {
            return new URL(null, urlString, AboutUrlStreamHandler_);
        }
        return new URL(urlString);
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String stringToTokenize;
        if (StringUtils.isEmpty((String)relativeUrl)) {
            return baseUrl;
        }
        String parseUrl = relativeUrl;
        int schemeIndex = parseUrl.indexOf(":");
        if (schemeIndex != -1) {
            boolean isProtocolSpecified = true;
            for (int i = 0; i < schemeIndex; ++i) {
                if (Character.isLetter(parseUrl.charAt(i))) continue;
                isProtocolSpecified = false;
                break;
            }
            if (isProtocolSpecified) {
                return WebClient.makeUrl(parseUrl);
            }
        }
        if (parseUrl.startsWith("//")) {
            return WebClient.makeUrl(baseUrl.getProtocol() + ":" + parseUrl);
        }
        int fragmentIndex = parseUrl.lastIndexOf("#");
        if (fragmentIndex != -1) {
            parseUrl = parseUrl.substring(0, fragmentIndex);
        }
        String stringQuery = null;
        int queryIndex = parseUrl.lastIndexOf("?");
        if (queryIndex != -1) {
            stringQuery = parseUrl.substring(queryIndex);
            parseUrl = parseUrl.substring(0, queryIndex);
        }
        String stringParameters = null;
        int parametersIndex = parseUrl.lastIndexOf(";");
        if (parametersIndex != -1) {
            stringParameters = parseUrl.substring(parametersIndex);
            parseUrl = parseUrl.substring(0, parametersIndex);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        if (parseUrl.trim().length() == 0) {
            stringToTokenize = baseUrl.getPath();
        } else if (parseUrl.startsWith("/")) {
            stringToTokenize = parseUrl;
        } else {
            String path = baseUrl.getPath();
            if (!path.endsWith("/") && parseUrl.length() != 0) {
                path = path + "/..";
            }
            stringToTokenize = path + "/" + parseUrl;
        }
        String pathToTokenize = stringToTokenize;
        StringTokenizer tokenizer = new StringTokenizer(pathToTokenize, "/");
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        for (int i = 0; i < tokens.size(); ++i) {
            String oneToken = (String)tokens.get(i);
            if (oneToken.length() == 0 || oneToken.equals(".")) {
                tokens.remove(i--);
                continue;
            }
            if (!oneToken.equals("..")) continue;
            tokens.remove(i--);
            if (i < 0) continue;
            tokens.remove(i--);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(baseUrl.getProtocol());
        buffer.append("://");
        buffer.append(baseUrl.getHost());
        int port = baseUrl.getPort();
        if (port != -1) {
            buffer.append(":");
            buffer.append(port);
        }
        Iterator iterator = tokens.iterator();
        while (iterator.hasNext()) {
            buffer.append("/");
            buffer.append(iterator.next());
        }
        if (pathToTokenize.endsWith("/")) {
            buffer.append("/");
        }
        if (stringParameters != null) {
            buffer.append(stringParameters);
        }
        if (stringQuery != null) {
            buffer.append(stringQuery);
        }
        String newUrlString = buffer.toString();
        return WebClient.makeUrl(newUrlString);
    }

    private WebResponse makeWebResponseForAboutUrl(URL url) {
        String urlWithoutQuery = StringUtils.substringBefore((String)url.toExternalForm(), (String)"?");
        if (!StringUtils.substringAfter((String)urlWithoutQuery, (String)"about:").equalsIgnoreCase("blank")) {
            throw new IllegalArgumentException(url.toExternalForm() + "is not supported, only about:blank is supported now.");
        }
        return WEB_RESPONSE_FOR_ABOUT_BLANK;
    }

    private WebResponse makeWebResponseForFileUrl(URL url) throws IOException {
        File file = FileUtils.toFile((URL)url);
        final String contentType = this.guessContentType(file);
        if (contentType.startsWith("text")) {
            String encoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            String str = IOUtils.toString((InputStream)new FileInputStream(file), (String)encoding);
            return new StringWebResponse(str, url){

                public String getContentType() {
                    return contentType;
                }
            };
        }
        byte[] data = IOUtils.toByteArray((InputStream)new FileInputStream(file));
        return new BinaryWebResponse(data, url, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String guessContentType(File file) {
        String contentType = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            contentType = URLConnection.guessContentTypeFromStream(inputStream);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(inputStream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (contentType == null) {
            contentType = URLConnection.guessContentTypeFromName(file.getName());
        }
        if (contentType == null) {
            contentType = file.getName().endsWith(".js") ? "text/javascript" : "application/octet-stream";
        }
        return contentType;
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, URL url) {
        if (!(webWindow instanceof FrameWindow)) {
            throw new IllegalArgumentException("javascript urls can only be used to load content into frames and iframes");
        }
        FrameWindow frameWindow = (FrameWindow)webWindow;
        HtmlPage enclosingPage = frameWindow.getEnclosingPage();
        ScriptResult scriptResult = enclosingPage.executeJavaScriptIfPossible(url.toExternalForm(), "javascript url", false, null);
        String contentString = scriptResult.getJavaScriptResult().toString();
        return new StringWebResponse(contentString);
    }

    public final WebResponse loadWebResponse(WebRequestSettings webRequestSettings) throws IOException {
        String protocol = webRequestSettings.getURL().getProtocol();
        WebResponse response = protocol.equals("about") ? this.makeWebResponseForAboutUrl(webRequestSettings.getURL()) : (protocol.equals("file") ? this.makeWebResponseForFileUrl(webRequestSettings.getURL()) : this.loadWebResponseFromWebConnection(webRequestSettings, 20));
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebResponse loadWebResponseFromWebConnection(WebRequestSettings webRequestSettings, int nbAllowedRedirections) throws IOException {
        URL url = webRequestSettings.getURL();
        SubmitMethod method = webRequestSettings.getSubmitMethod();
        List parameters = webRequestSettings.getRequestParameters();
        Assert.notNull("url", url);
        Assert.notNull("method", method);
        Assert.notNull("parameters", parameters);
        this.getLog().debug((Object)("Load response for " + url.toExternalForm()));
        if (webRequestSettings.getProxyHost() == null && !this.shouldBypassProxy(webRequestSettings.getURL().getHost())) {
            webRequestSettings.setProxyHost(this.proxyHost_);
            webRequestSettings.setProxyPort(this.proxyPort_);
        }
        URL fixedUrl = this.encodeUrl(url);
        webRequestSettings.setURL(fixedUrl);
        webRequestSettings.getAdditionalHeaders().putAll(this.requestHeaders_);
        WebResponse webResponse = this.getWebConnection().getResponse(webRequestSettings);
        int statusCode = webResponse.getStatusCode();
        if (statusCode < 301) return webResponse;
        if (statusCode > 307) return webResponse;
        if (!this.isRedirectEnabled()) return webResponse;
        URL newUrl = null;
        String locationString = null;
        try {
            locationString = webResponse.getResponseHeaderValue("Location");
            newUrl = WebClient.expandUrl(fixedUrl, locationString);
        }
        catch (MalformedURLException e) {
            this.getLog().warn((Object)("Got a redirect status code [" + statusCode + " " + webResponse.getStatusMessage() + "] but the location is not a valid url [" + locationString + "]. Skipping redirection processing."));
            return webResponse;
        }
        this.getLog().debug((Object)("Got a redirect status code [" + statusCode + "] new location=[" + locationString + "]"));
        if (webRequestSettings.getSubmitMethod().equals(SubmitMethod.GET) && webResponse.getUrl().toExternalForm().equals(locationString)) {
            if (nbAllowedRedirections == 0) {
                this.getLog().warn((Object)("Max redirections allowed to the same location reached for [" + locationString + "]. Skipping redirection."));
                return webResponse;
            }
            this.getLog().debug((Object)("Got a redirect with location same as the page we just loaded. Nb self redirection allowed: " + nbAllowedRedirections));
            return this.loadWebResponseFromWebConnection(webRequestSettings, nbAllowedRedirections - 1);
        }
        if ((statusCode == 301 || statusCode == 307) && method.equals(SubmitMethod.GET)) {
            WebRequestSettings wrs = new WebRequestSettings(newUrl);
            wrs.setRequestParameters(parameters);
            return this.loadWebResponse(wrs);
        }
        if (statusCode > 303) return webResponse;
        WebRequestSettings wrs = new WebRequestSettings(newUrl);
        wrs.setSubmitMethod(SubmitMethod.GET);
        return this.loadWebResponse(wrs);
    }

    protected URL encodeUrl(URL url) throws MalformedURLException, URIException {
        String path = url.getPath();
        String fixedPath = this.encode(path, URI.allowed_abs_path);
        String query = url.getQuery();
        String fixedQuery = this.encode(query, URI.allowed_query);
        if (!StringUtils.equals((String)path, (String)fixedPath) || !StringUtils.equals((String)query, (String)fixedQuery)) {
            StringBuffer newUrl = new StringBuffer();
            newUrl.append(url.getProtocol());
            newUrl.append("://");
            newUrl.append(url.getHost());
            if (url.getPort() != -1) {
                newUrl.append(":");
                newUrl.append(url.getPort());
            }
            newUrl.append(fixedPath);
            if (url.getUserInfo() != null) {
                newUrl.append(url.getUserInfo());
            }
            if (fixedQuery != null) {
                newUrl.append("?");
                newUrl.append(fixedQuery);
            }
            if (url.getRef() != null) {
                newUrl.append("#");
                newUrl.append(url.getRef());
            }
            return new URL(newUrl.toString());
        }
        return url;
    }

    private String encode(String str, BitSet allowed) throws URIException {
        if (str == null) {
            return null;
        }
        BitSet bits = new BitSet(str.length());
        bits.set(37);
        bits.or(allowed);
        return URIUtil.encode((String)str, (BitSet)bits);
    }

    public boolean moveFocusFromElement(FocusableElement oldElement) {
        if (oldElement != null && this.elementWithFocus_ == oldElement) {
            HtmlPage page = oldElement.getPage();
            page.moveFocusToElement(null);
            this.elementWithFocus_ = null;
            return page == page.getEnclosingWindow().getEnclosedPage();
        }
        return false;
    }

    public boolean moveFocusToElement(FocusableElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException("Cannot move focus to null");
        }
        this.elementWithFocus_ = newElement;
        return newElement.getPage().moveFocusToElement(newElement);
    }

    public FocusableElement getElementWithFocus() {
        return this.elementWithFocus_;
    }

    public List getWebWindows() {
        return Collections.unmodifiableList(this.webWindows_);
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler_ = handler == null ? new ImmediateRefreshHandler() : handler;
    }

    public RefreshHandler getRefreshHandler() {
        return this.refreshHandler_;
    }

    public void setScriptPreProcessor(ScriptPreProcessor scriptPreProcessor) {
        this.scriptPreProcessor_ = scriptPreProcessor;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor_;
    }

    public void setActiveXObjectMap(Map activeXObjectMap) {
        this.activeXObjectMap_ = activeXObjectMap;
    }

    public Map getActiveXObjectMap() {
        return this.activeXObjectMap_;
    }

    public void setHTMLParserListener(HTMLParserListener listener) {
        this.htmlParserListener_ = listener;
    }

    public HTMLParserListener getHTMLParserListener() {
        return this.htmlParserListener_;
    }

    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        HTMLParser.setIgnoreOutsideContent(ignoreOutsideContent);
    }

    public static boolean getIgnoreOutsideContent() {
        return HTMLParser.getIgnoreOutsideContent();
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public boolean isThrowExceptionOnScriptError() {
        return this.throwExceptionOnScriptError_;
    }

    public void setThrowExceptionOnScriptError(boolean newValue) {
        this.throwExceptionOnScriptError_ = newValue;
    }

    static {
        URL tmpUrl = null;
        try {
            tmpUrl = new URL(null, "about:blank", AboutUrlStreamHandler_);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        URL_ABOUT_BLANK = tmpUrl;
        WEB_RESPONSE_FOR_ABOUT_BLANK = new StringWebResponse("", URL_ABOUT_BLANK);
    }

    private static final class BinaryWebResponse
    extends WebResponseImpl {
        private final byte[] data_;

        private static WebResponseData getWebResponseData(byte[] data, String contentType) {
            ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
            compiledHeaders.add(new NameValuePair("Content-Type", contentType));
            return new WebResponseData(data, 200, "OK", compiledHeaders);
        }

        private BinaryWebResponse(byte[] data, URL originatingURL, String contentType) {
            super(BinaryWebResponse.getWebResponseData(data, contentType), originatingURL, SubmitMethod.GET, 0L);
            this.data_ = data;
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.data_);
        }
    }
}

