/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadManager {
    private Map threadMap_ = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((Class)ThreadManager.class);
    private int nextThreadID_ = 1;
    private static final int PRIORITY = Math.min(10, Thread.currentThread().getPriority() + 1);

    public int activeCount() {
        return this.threadMap_.size();
    }

    private synchronized int getNextThreadId() {
        return this.nextThreadID_++;
    }

    public int startThread(Runnable job, String label) {
        final int myThreadID = this.getNextThreadId();
        Thread newThread = new Thread(job, "HtmlUnit Managed Thread #" + myThreadID + ": " + label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    super.run();
                }
                finally {
                    ThreadManager.this.threadMap_.remove(new Integer(myThreadID));
                }
            }
        };
        newThread.setPriority(PRIORITY);
        newThread.setDaemon(true);
        this.threadMap_.put(new Integer(myThreadID), newThread);
        newThread.start();
        return myThreadID;
    }

    public void stopThread(int threadID) {
        Thread thread = (Thread)this.threadMap_.remove(new Integer(threadID));
        if (thread != null) {
            thread.interrupt();
        }
    }

    public boolean joinAll(long maxWaitMillis) {
        while (maxWaitMillis > 0L && !this.threadMap_.isEmpty()) {
            Iterator iter = this.threadMap_.values().iterator();
            while (maxWaitMillis > 0L && iter.hasNext()) {
                Thread thread;
                try {
                    thread = (Thread)iter.next();
                }
                catch (ConcurrentModificationException e) {
                    iter = this.threadMap_.values().iterator();
                    continue;
                }
                long before = System.currentTimeMillis();
                try {
                    LOG.debug((Object)("Trying to join: " + thread));
                    thread.join(maxWaitMillis);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread " + thread + " interrupted", e);
                }
                maxWaitMillis -= System.currentTimeMillis() - before;
            }
        }
        return this.threadMap_.size() == 0;
    }

    public void interruptAll() {
        HashSet keys = new HashSet(this.threadMap_.keySet());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            this.stopThread((Integer)iter.next());
        }
    }

    public String toString() {
        return "ThreadManager: " + this.threadMap_;
    }
}

