/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ScriptEngine {
    private static final Log ScriptEngineLog_ = LogFactory.getLog((Class)ScriptEngine.class);
    private final WebClient webClient_;

    protected ScriptEngine(WebClient webClient) {
        Assert.notNull("webClient", webClient);
        this.webClient_ = webClient;
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public abstract void initialize(WebWindow var1);

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName) {
        return this.execute(htmlPage, sourceCode, sourceName, null);
    }

    public abstract Object execute(HtmlPage var1, String var2, String var3, HtmlElement var4);

    public abstract Object callFunction(HtmlPage var1, Object var2, Object var3, Object[] var4, HtmlElement var5);

    public static Log getScriptEngineLog() {
        return ScriptEngineLog_;
    }

    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElement) {
        String newSourceCode = sourceCode;
        ScriptPreProcessor preProcessor = this.getWebClient().getScriptPreProcessor();
        if (preProcessor != null && (newSourceCode = preProcessor.preProcess(htmlPage, sourceCode, sourceName, htmlElement)) == null) {
            newSourceCode = "";
        }
        return newSourceCode;
    }

    public abstract boolean isScriptRunning();
}

