/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnectionImpl;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockWebConnection
extends WebConnectionImpl {
    private final Map responseMap_ = new HashMap(10);
    private WebResponseData defaultResponse_;
    private WebRequestSettings lastRequest_;
    private HttpState httpState_ = new HttpState();

    public MockWebConnection(WebClient webClient) {
        super(webClient);
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        URL url = webRequestSettings.getURL();
        this.getLog().debug((Object)("Getting response for " + url.toExternalForm()));
        this.lastRequest_ = webRequestSettings;
        WebResponseData response = (WebResponseData)this.responseMap_.get(url.toExternalForm());
        if (response == null && (response = this.defaultResponse_) == null) {
            throw new IllegalStateException("No response specified that can handle url [" + url.toExternalForm() + "]");
        }
        return new WebResponseImpl(response, webRequestSettings.getURL(), webRequestSettings.getSubmitMethod(), 0L);
    }

    public SubmitMethod getLastMethod() {
        return this.lastRequest_.getSubmitMethod();
    }

    public List getLastParameters() {
        return this.lastRequest_.getRequestParameters();
    }

    public void setResponse(URL url, String content, int statusCode, String statusMessage, String contentType, List responseHeaders) {
        this.setResponse(url, TextUtil.stringToByteArray(content), statusCode, statusMessage, contentType, responseHeaders);
    }

    public void setResponse(URL url, byte[] content, int statusCode, String statusMessage, String contentType, List responseHeaders) {
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>(responseHeaders);
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        WebResponseData responseEntry = new WebResponseData(content, statusCode, statusMessage, compiledHeaders);
        this.responseMap_.put(url.toExternalForm(), responseEntry);
    }

    public void setResponse(URL url, String content) {
        this.setResponse(url, content, 200, "OK", "text/html", Collections.EMPTY_LIST);
    }

    public void setResponse(URL url, String content, String contentType) {
        this.setResponse(url, content, 200, "OK", contentType, Collections.EMPTY_LIST);
    }

    public void setResponseAsGenericHtml(URL url, String title) {
        String content = "<html><head><title>" + title + "</title></head><body></body></html>";
        this.setResponse(url, content);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType) {
        this.setDefaultResponse(TextUtil.stringToByteArray(content), statusCode, statusMessage, contentType);
    }

    public void setDefaultResponse(byte[] content, int statusCode, String statusMessage, String contentType) {
        WebResponseData responseEntry;
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        this.defaultResponse_ = responseEntry = new WebResponseData(content, statusCode, statusMessage, compiledHeaders);
    }

    public void setDefaultResponse(String content) {
        this.setDefaultResponse(content, 200, "OK", "text/html");
    }

    public HttpState getState() {
        return this.httpState_;
    }

    public Map getLastAdditionalHeaders() {
        return this.lastRequest_.getAdditionalHeaders();
    }

    public WebRequestSettings getLastWebRequestSettings() {
        return this.lastRequest_;
    }
}

