/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.KeyDataPair;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnectionImpl;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;

public class HttpWebConnection
extends WebConnectionImpl {
    private HttpClient httpClient_;
    private String virtualHost_ = null;
    private static final HttpMethodRetryHandler NoAutoRetry = new HttpMethodRetryHandler(){

        public boolean retryMethod(HttpMethod arg0, IOException arg1, int arg2) {
            return false;
        }
    };

    public HttpWebConnection(WebClient webClient) {
        super(webClient);
    }

    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        URL url = webRequestSettings.getURL();
        HttpClient httpClient = this.getHttpClient();
        HttpMethodBase httpMethod = this.makeHttpMethod(webRequestSettings);
        try {
            HostConfiguration hostConfiguration = this.getHostConfiguration(webRequestSettings);
            long startTime = System.currentTimeMillis();
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)httpMethod);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse(responseCode, httpMethod, url, endTime - startTime);
            return webResponse;
        }
        catch (HttpException e) {
            if (url.getPath().length() == 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(url.getProtocol());
                buffer.append("://");
                buffer.append(url.getHost());
                buffer.append("/");
                if (url.getQuery() != null) {
                    buffer.append(url.getQuery());
                }
                WebRequestSettings newRequest = new WebRequestSettings(new URL(buffer.toString()));
                newRequest.setSubmitMethod(webRequestSettings.getSubmitMethod());
                newRequest.setRequestParameters(webRequestSettings.getRequestParameters());
                newRequest.setAdditionalHeaders(webRequestSettings.getAdditionalHeaders());
                WebResponse webResponse = this.getResponse(newRequest);
                return webResponse;
            }
            e.printStackTrace();
            throw new RuntimeException("HTTP Error: " + e.getMessage());
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private HostConfiguration getHostConfiguration(WebRequestSettings webRequestSettings) {
        URI uri;
        HostConfiguration hostConfiguration = new HostConfiguration();
        URL url = webRequestSettings.getURL();
        try {
            uri = new URI(url.toExternalForm(), false);
        }
        catch (URIException e) {
            throw new IllegalStateException("Unable to create URI from URL: " + url.toExternalForm());
        }
        hostConfiguration.setHost(uri);
        if (webRequestSettings.getProxyHost() != null) {
            String proxyHost = webRequestSettings.getProxyHost();
            int proxyPort = webRequestSettings.getProxyPort();
            hostConfiguration.setProxy(proxyHost, proxyPort);
        }
        return hostConfiguration;
    }

    private HttpMethodBase makeHttpMethod(WebRequestSettings webRequestSettings) throws IOException {
        GetMethod httpMethod;
        String path = webRequestSettings.getURL().getPath();
        if (path.length() == 0) {
            path = "/";
        }
        if (SubmitMethod.GET == webRequestSettings.getSubmitMethod()) {
            httpMethod = new GetMethod(path);
            if (webRequestSettings.getRequestParameters().isEmpty()) {
                String queryString = webRequestSettings.getURL().getQuery();
                httpMethod.setQueryString(queryString);
            } else {
                NameValuePair[] pairs = new NameValuePair[webRequestSettings.getRequestParameters().size()];
                webRequestSettings.getRequestParameters().toArray(pairs);
                httpMethod.setQueryString(pairs);
            }
        } else if (SubmitMethod.POST == webRequestSettings.getSubmitMethod()) {
            PostMethod postMethod = new PostMethod(path);
            postMethod.getParams().setContentCharset(webRequestSettings.getCharset());
            String queryString = webRequestSettings.getURL().getQuery();
            if (queryString != null) {
                postMethod.setQueryString(queryString);
            }
            if (webRequestSettings.getRequestBody() != null) {
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(webRequestSettings.getRequestBody()));
            }
            if (webRequestSettings.getEncodingType() == FormEncodingType.URL_ENCODED) {
                NameValuePair pair;
                Iterator iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    pair = (NameValuePair)iterator.next();
                    postMethod.removeParameter(pair.getName(), pair.getValue());
                }
                iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    pair = (NameValuePair)iterator.next();
                    postMethod.addParameter(pair.getName(), pair.getValue());
                }
            } else {
                ArrayList<StringPart> partList = new ArrayList<StringPart>();
                Iterator iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    StringPart newPart;
                    KeyValuePair pair = (KeyValuePair)((Object)iterator.next());
                    if (pair instanceof KeyDataPair) {
                        KeyDataPair pairWithFile = (KeyDataPair)pair;
                        newPart = new FilePart(pairWithFile.getName(), pairWithFile.getValue(), pairWithFile.getFile(), pairWithFile.getContentType(), null);
                        newPart.setCharSet(null);
                    } else {
                        newPart = new StringPart(pair.getName(), pair.getValue(), webRequestSettings.getCharset());
                        newPart.setContentType(null);
                    }
                    newPart.setTransferEncoding(null);
                    partList.add(newPart);
                }
                Part[] parts = new Part[partList.size()];
                parts = partList.toArray(parts);
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
            }
            httpMethod = postMethod;
        } else {
            throw new IllegalStateException("Submit method not yet supported: " + webRequestSettings.getSubmitMethod());
        }
        httpMethod.setRequestHeader("User-Agent", this.getWebClient().getBrowserVersion().getUserAgent());
        this.writeRequestHeadersToHttpMethod((HttpMethod)httpMethod, webRequestSettings.getAdditionalHeaders());
        httpMethod.setFollowRedirects(false);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)NoAutoRetry);
        if (webRequestSettings.getCredentialsProvider() != null) {
            httpMethod.getParams().setParameter("http.authentication.credential-provider", (Object)webRequestSettings.getCredentialsProvider());
        }
        return httpMethod;
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            Log log = LogFactory.getLog((String)"httpclient.wire");
            if (log instanceof SimpleLog) {
                ((SimpleLog)log).setLevel(4);
            }
            int timeout = this.getWebClient().getTimeout();
            this.httpClient_.getHttpConnectionManager().getParams().setSoTimeout(timeout);
            this.httpClient_.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
            if (this.virtualHost_ != null) {
                this.httpClient_.getParams().setVirtualHost(this.virtualHost_);
            }
        }
        this.httpClient_.getParams().setParameter("http.authentication.credential-provider", (Object)this.getWebClient().getCredentialsProvider());
        return this.httpClient_;
    }

    protected HttpClient createHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        return new HttpClient((HttpConnectionManager)connectionManager);
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    public HttpState getState() {
        return this.getHttpClient().getState();
    }

    private WebResponse makeWebResponse(int statusCode, HttpMethodBase method, URL originatingURL, long loadTime) throws IOException {
        String statusMessage = method.getStatusText();
        if (statusMessage == null || statusMessage.length() == 0) {
            statusMessage = HttpStatus.getStatusText((int)statusCode);
        }
        if (statusMessage == null) {
            statusMessage = "Unknown status code";
        }
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        Header[] array = method.getResponseHeaders();
        for (int i = 0; i < array.length; ++i) {
            headers.add(new NameValuePair(array[i].getName(), array[i].getValue()));
        }
        WebResponseData responseData = new WebResponseData(method.getResponseBodyAsStream(), statusCode, statusMessage, headers);
        SubmitMethod requestMethod = SubmitMethod.getInstance(method.getName());
        return new WebResponseImpl(responseData, originatingURL, requestMethod, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestHeadersToHttpMethod(HttpMethod httpMethod, Map requestHeaders) {
        Map map = requestHeaders;
        synchronized (map) {
            Iterator iterator = requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                httpMethod.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

