/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCredentialsProvider
implements CredentialsProvider {
    private final Map credentials_ = new HashMap();
    private final Map proxyCredentials_ = new HashMap();
    private final Set answerMarks_ = Collections.synchronizedSortedSet(new TreeSet());

    public void addCredentials(String username, String password) {
        this.addCredentials(username, password, AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
    }

    public void addCredentials(String username, String password, String host, int port, String realm) {
        AuthScope scope = new AuthScope(host, port, realm, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(username, password);
        this.credentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addProxyCredentials(String username, String password) {
        this.addProxyCredentials(username, password, AuthScope.ANY_HOST, -1);
    }

    public void addProxyCredentials(String username, String password, String host, int port) {
        AuthScope scope = new AuthScope(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(username, password);
        this.proxyCredentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addNTLMCredentials(String username, String password, String host, int port, String clientHost, String clientDomain) {
        AuthScope scope = new AuthScope(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        NTCredentials c = new NTCredentials(username, password, clientHost, clientDomain);
        this.credentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addNTLMProxyCredentials(String username, String password, String host, int port, String clientHost, String clientDomain) {
        AuthScope scope = new AuthScope(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        NTCredentials c = new NTCredentials(username, password, clientHost, clientDomain);
        this.proxyCredentials_.put(scope, c);
        this.clearAnswered();
    }

    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (this.alreadyAnswered(scheme, host, port, proxy)) {
            this.getLog().debug((Object)("Already answered for " + this.buildKey(scheme, host, port, proxy) + " returning null"));
            return null;
        }
        Map credentials = proxy ? this.proxyCredentials_ : this.credentials_;
        Iterator i = credentials.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            AuthScope scope = (AuthScope)entry.getKey();
            Credentials c = (Credentials)entry.getValue();
            if (!this.matchScheme(scope, scheme) || !this.matchHost(scope, host) || !this.matchPort(scope, port) || !this.matchRealm(scope, scheme)) continue;
            this.markAsAnswered(scheme, host, port, proxy);
            this.getLog().debug((Object)("Returning " + c + " for " + this.buildKey(scheme, host, port, proxy)));
            return c;
        }
        this.getLog().debug((Object)("No credential found for " + this.buildKey(scheme, host, port, proxy)));
        return null;
    }

    protected boolean matchRealm(AuthScope scope, AuthScheme scheme) {
        return scope.getRealm() == AuthScope.ANY_REALM || scope.getRealm().equals(scheme.getRealm());
    }

    protected boolean matchPort(AuthScope scope, int port) {
        return scope.getPort() == -1 || scope.getPort() == port;
    }

    protected boolean matchHost(AuthScope scope, String host) {
        return scope.getHost() == AuthScope.ANY_HOST || scope.getHost().equals(host);
    }

    protected boolean matchScheme(AuthScope scope, AuthScheme scheme) {
        return scope.getScheme() == AuthScope.ANY_SCHEME || scope.getScheme().equals(scheme.getSchemeName());
    }

    protected boolean alreadyAnswered(AuthScheme scheme, String host, int port, boolean proxy) {
        return this.answerMarks_.contains(this.buildKey(scheme, host, port, proxy));
    }

    protected void markAsAnswered(AuthScheme scheme, String host, int port, boolean proxy) {
        this.answerMarks_.add(this.buildKey(scheme, host, port, proxy));
    }

    protected void clearAnswered() {
        this.answerMarks_.clear();
        this.getLog().debug((Object)"Flushed marked answers");
    }

    protected Object buildKey(AuthScheme scheme, String host, int port, boolean proxy) {
        return scheme.getSchemeName() + " " + scheme.getRealm() + " " + host + ":" + port + " " + proxy;
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }
}

