/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Assert;

public class BrowserVersion {
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String browserLanguage_ = "en-us";
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win32";
    private String systemLanguage_ = "en-us";
    private String userAgent_;
    private String userLanguage_ = "en-us";
    private String javaScriptVersion_;
    private float javaScriptVersionNumeric_;
    private float browserVersionNumeric_;
    public static final String APP_CODE_NAME = "Mozilla";
    public static final String INTERNET_EXPLORER = "Microsoft Internet Explorer";
    public static final String NETSCAPE = "Netscape";
    public static final String LANGUAGE_ENGLISH_US = "en-us";
    public static final String CPU_CLASS_X86 = "x86";
    public static final String PLATFORM_WIN32 = "Win32";
    public static final BrowserVersion FULL_FEATURED_BROWSER = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 6.0b; Windows 98)", "Mozilla/4.0 (compatible; MSIE 6.0b; Windows 98)", "1.2", 6.0f);
    public static final BrowserVersion MOZILLA_1_0 = new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.0.0) Gecko/20020530", "1.2", 6.0f);
    public static final BrowserVersion NETSCAPE_4_7_9 = new BrowserVersion("Netscape", "4.79 [en] (Windows NT 5.0; U)", "Mozilla/4.79 [en] (Windows NT 5.0; U)", "1.2", 4.79f);
    public static final BrowserVersion NETSCAPE_6_2_3 = new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US;rv:0.9.4.1) Gecko/20020508 Netscape6/6.2.3", "1.2", 6.0f);
    public static final BrowserVersion INTERNET_EXPLORER_6_0 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 6.0b; Windows 98)", "4.0 (compatible; MSIE 6.0; Windows 98)", "1.2", 6.0f);
    private static BrowserVersion DefaultBrowserVersion_ = FULL_FEATURED_BROWSER;

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, String javaScriptVersion, float browserVersionNumeric) {
        this.applicationName_ = applicationName;
        this.setApplicationVersion(applicationVersion);
        this.userAgent_ = userAgent;
        this.setJavaScriptVersion(javaScriptVersion);
        this.browserVersionNumeric_ = browserVersionNumeric;
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        Assert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public final boolean isIE() {
        return INTERNET_EXPLORER.equals(this.getApplicationName());
    }

    public final boolean isNetscape() {
        return NETSCAPE.equals(this.getApplicationName());
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage_;
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    public String getJavaScriptVersion() {
        return this.javaScriptVersion_;
    }

    public void setApplicationCodeName(String applicationCodeName) {
        this.applicationCodeName_ = applicationCodeName;
    }

    public void setApplicationMinorVersion(String applicationMinorVersion) {
        this.applicationMinorVersion_ = applicationMinorVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName_ = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion_ = applicationVersion;
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.browserLanguage_ = browserLanguage;
    }

    public void setCpuClass(String cpuClass) {
        this.cpuClass_ = cpuClass;
    }

    public void setJavaScriptVersion(String javaScriptVersion) {
        this.javaScriptVersion_ = javaScriptVersion;
        this.javaScriptVersionNumeric_ = Float.parseFloat(javaScriptVersion);
    }

    public void setOnLine(boolean onLine) {
        this.onLine_ = onLine;
    }

    public void setPlatform(String platform) {
        this.platform_ = platform;
    }

    public void setSystemLanguage(String systemLanguage) {
        this.systemLanguage_ = systemLanguage;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent_ = userAgent;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage_ = userLanguage;
    }

    public void setBrowserVersion(float browserVersion) {
        this.browserVersionNumeric_ = browserVersion;
    }

    public float getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    public float getJavaScriptVersionNumeric() {
        return this.javaScriptVersionNumeric_;
    }
}

