/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.util;

import com.jcoverage.util.TypeHelper;
import java.lang.reflect.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.Type;

public class ClassGenHelper {
    final ClassGen cg;
    final InstructionFactory factory;

    private ClassGenHelper(ClassGen cg) {
        this.cg = cg;
        this.factory = new InstructionFactory(cg);
    }

    public static ClassGenHelper newInstance(ClassGen cg) {
        return new ClassGenHelper(cg);
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cg.getConstantPool();
    }

    private InstructionList createInvoke(Class cl, String methodName, Class returnType, Type[] parameterTypes, short kind) {
        InstructionList il = new InstructionList();
        il.append(this.factory.createInvoke(cl.getName(), methodName, TypeHelper.getType(returnType), parameterTypes, kind));
        return il;
    }

    public InstructionList createInvokeVirtual(Class cl, String methodName, Class returnType) {
        return this.createInvoke(cl, methodName, returnType, Type.NO_ARGS, (short)182);
    }

    public InstructionList createInvokeVirtual(Class cl, String methodName, Class returnType, Class signature) {
        return this.createInvokeVirtual(cl, methodName, returnType, new Class[]{signature});
    }

    public InstructionList createInvokeVirtual(Class cl, String methodName, Class returnType, Class[] signature) {
        return this.createInvoke(cl, methodName, returnType, TypeHelper.getTypes(signature), (short)182);
    }

    public InstructionList createInvokeStatic(Class cl, String methodName, Class returnType) {
        return this.createInvoke(cl, methodName, returnType, Type.NO_ARGS, (short)184);
    }

    public InstructionList createInvokeStatic(Class cl, String methodName, Class returnType, Class[] signature) {
        return this.createInvoke(cl, methodName, returnType, TypeHelper.getTypes(signature), (short)184);
    }

    public InstructionList createInvokeInterface(Class cl, String methodName, Class returnType) {
        return this.createInvoke(cl, methodName, returnType, Type.NO_ARGS, (short)185);
    }

    public InstructionList createInvokeInterface(Class cl, String methodName, Class returnType, Class signature) {
        return this.createInvokeInterface(cl, methodName, returnType, new Class[]{signature});
    }

    public InstructionList createInvokeInterface(Class cl, String methodName, Class returnType, Class[] signature) {
        return this.createInvoke(cl, methodName, returnType, TypeHelper.getTypes(signature), (short)185);
    }

    public InstructionList createInvokeSpecial(Class cl, String methodName, Class returnType) {
        return this.createInvoke(cl, methodName, returnType, Type.NO_ARGS, (short)183);
    }

    public InstructionList createInvokeSpecial(Class cl, String methodName, Class returnType, Class[] signature) {
        return this.createInvoke(cl, methodName, returnType, TypeHelper.getTypes(signature), (short)183);
    }

    public InstructionList createInvokeSpecial(Method m) {
        return this.createInvokeSpecial(m.getDeclaringClass(), m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    public String getClassName(InstructionHandle handleToInvokeInstruction) {
        return this.getClassName((InvokeInstruction)handleToInvokeInstruction.getInstruction());
    }

    public String getClassName(InvokeInstruction invoke) {
        return invoke.getClassName(this.getConstantPool());
    }
}

