/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.ConditionalFactory;
import com.jcoverage.coverage.CoverageRuntimeException;
import com.jcoverage.util.ClassGenHelper;
import com.jcoverage.util.InstructionHelper;
import com.jcoverage.util.InstructionListHelper;
import com.jcoverage.util.MethodGenHelper;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

class InstrumentMethodGen {
    static final Logger logger = Logger.getLogger((Class)(class$com$jcoverage$coverage$InstrumentMethodGen == null ? (class$com$jcoverage$coverage$InstrumentMethodGen = InstrumentMethodGen.class$("com.jcoverage.coverage.InstrumentMethodGen")) : class$com$jcoverage$coverage$InstrumentMethodGen));
    final Method original;
    final MethodGenHelper methodGenHelper;
    final ClassGenHelper classGenHelper;
    final Set conditionals = new HashSet();
    final Set sourceLineNumbers = new HashSet();
    final Perl5Matcher pm = new Perl5Matcher();
    Pattern ignoreRegex = null;
    static /* synthetic */ Class class$com$jcoverage$coverage$InstrumentMethodGen;
    static /* synthetic */ Class class$com$jcoverage$coverage$InstrumentationFactory;
    static /* synthetic */ Class class$com$jcoverage$coverage$Instrumentation;
    static /* synthetic */ Class class$java$lang$String;

    InstrumentMethodGen(Method original, ClassGen cg, String ignoreRegex) {
        this.original = original;
        this.methodGenHelper = new MethodGenHelper(new MethodGen(original, cg.getClassName(), cg.getConstantPool()));
        this.classGenHelper = ClassGenHelper.newInstance(cg);
        Perl5Compiler pc = new Perl5Compiler();
        if (ignoreRegex != null) {
            try {
                this.ignoreRegex = pc.compile(ignoreRegex);
            }
            catch (MalformedPatternException ex) {
                throw new CoverageRuntimeException(ex);
            }
        }
    }

    void updateTargeters(InstructionHandle oldTarget, InstructionHandle newTarget, InstructionTargeter targeter) {
        targeter.updateTarget(oldTarget, newTarget);
    }

    void updateTargeters(InstructionHandle oldTarget, InstructionHandle newTarget, InstructionTargeter[] targeters) {
        for (int i = 0; i < targeters.length; ++i) {
            this.updateTargeters(oldTarget, newTarget, targeters[i]);
        }
    }

    void updateTargeters(InstructionHandle oldTarget, InstructionHandle newTarget) {
        if (oldTarget.hasTargeters()) {
            this.updateTargeters(oldTarget, newTarget, oldTarget.getTargeters());
        }
    }

    boolean isIgnorable(ClassGenHelper helper, InstructionHandle handle) {
        if (InstructionHelper.isInvokeInstruction(handle)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("class name: " + helper.getClassName(handle)));
            }
            return this.pm.matches(helper.getClassName(handle), this.ignoreRegex);
        }
        return false;
    }

    boolean hasIgnoreRegex() {
        return this.ignoreRegex != null;
    }

    boolean isIgnorable(ClassGenHelper helper, LineNumberGen lng) {
        if (!this.hasIgnoreRegex()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("instruction offset: ");
            sb.append(lng.getInstruction().getPosition());
            sb.append(", source line: ");
            sb.append(lng.getSourceLine());
            logger.debug((Object)sb.toString());
        }
        if (this.isIgnorable(helper, lng.getInstruction())) {
            return true;
        }
        for (InstructionHandle handle = lng.getInstruction().getNext(); handle != null && !this.methodGenHelper.hasLineNumber(handle); handle = handle.getNext()) {
            if (!this.isIgnorable(helper, handle)) continue;
            return true;
        }
        return false;
    }

    void addIfInstruction(LineNumberGen lng, IfInstruction ifInstruction) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("if instruction at line: ");
            sb.append(lng.getSourceLine());
            sb.append(", target: ");
            sb.append(this.methodGenHelper.getLineNumber(ifInstruction.getTarget()));
            sb.append("(for method: ");
            sb.append(this.methodGenHelper.getMethodGen().getClassName());
            sb.append('.');
            sb.append(this.methodGenHelper.getMethodGen().getName());
            sb.append(')');
            logger.debug((Object)sb.toString());
        }
        if (this.methodGenHelper.getLineNumber(ifInstruction.getTarget()) != 0) {
            this.conditionals.add(ConditionalFactory.newConditional(lng, this.methodGenHelper.getLineNumber(ifInstruction.getTarget())));
        }
    }

    void handleIfInstruction(LineNumberGen lng) {
        if (InstructionHelper.isIfInstruction(lng)) {
            this.addIfInstruction(lng, (IfInstruction)lng.getInstruction().getInstruction());
            return;
        }
        for (InstructionHandle handle = lng.getInstruction().getNext(); handle != null && !this.methodGenHelper.hasLineNumber(handle); handle = handle.getNext()) {
            if (!InstructionHelper.isIfInstruction(handle)) continue;
            this.addIfInstruction(lng, (IfInstruction)handle.getInstruction());
            return;
        }
    }

    void addInstrumentation(LineNumberGen lng) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("adding instrumentation to: ");
            sb.append(this.classGenHelper.getClassGen().getClassName());
            sb.append('.');
            sb.append(this.methodGenHelper.getMethodGen().getName());
            sb.append(" at line: ");
            sb.append(lng.getSourceLine());
            sb.append(", position: ");
            sb.append(lng.getInstruction().getPosition());
            logger.debug((Object)sb.toString());
        }
        if (this.isIgnorable(this.classGenHelper, lng)) {
            return;
        }
        this.handleIfInstruction(lng);
        this.addSourceLine(lng);
        this.updateTargeters(lng.getInstruction(), this.methodGenHelper.getMethodGen().getInstructionList().insert(lng.getInstruction(), this.emitGetInstrumentationAndTouchLine(lng)));
    }

    InstructionList emitGetInstrumentationAndTouchLine(LineNumberGen lng) {
        InstructionList il = new InstructionList();
        il.append(this.classGenHelper.createInvokeStatic(class$com$jcoverage$coverage$InstrumentationFactory == null ? (class$com$jcoverage$coverage$InstrumentationFactory = InstrumentMethodGen.class$("com.jcoverage.coverage.InstrumentationFactory")) : class$com$jcoverage$coverage$InstrumentationFactory, "getInstance", class$com$jcoverage$coverage$InstrumentationFactory == null ? (class$com$jcoverage$coverage$InstrumentationFactory = InstrumentMethodGen.class$("com.jcoverage.coverage.InstrumentationFactory")) : class$com$jcoverage$coverage$InstrumentationFactory));
        il.append(new LDC(this.classGenHelper.getConstantPool().addString(this.classGenHelper.getClassGen().getClassName())));
        il.append(this.classGenHelper.createInvokeVirtual(class$com$jcoverage$coverage$InstrumentationFactory == null ? (class$com$jcoverage$coverage$InstrumentationFactory = InstrumentMethodGen.class$("com.jcoverage.coverage.InstrumentationFactory")) : class$com$jcoverage$coverage$InstrumentationFactory, "newInstrumentation", class$com$jcoverage$coverage$Instrumentation == null ? (class$com$jcoverage$coverage$Instrumentation = InstrumentMethodGen.class$("com.jcoverage.coverage.Instrumentation")) : class$com$jcoverage$coverage$Instrumentation, class$java$lang$String == null ? (class$java$lang$String = InstrumentMethodGen.class$("java.lang.String")) : class$java$lang$String));
        il.append(InstructionListHelper.push(this.classGenHelper.getConstantPool(), lng.getSourceLine()));
        il.append(this.classGenHelper.createInvokeInterface(class$com$jcoverage$coverage$Instrumentation == null ? (class$com$jcoverage$coverage$Instrumentation = InstrumentMethodGen.class$("com.jcoverage.coverage.Instrumentation")) : class$com$jcoverage$coverage$Instrumentation, "touch", Void.TYPE, Integer.TYPE));
        return il;
    }

    void addSourceLine(LineNumberGen lng) {
        this.sourceLineNumbers.add(new Integer(lng.getSourceLine()));
    }

    void addInstrumentation(LineNumberGen[] lineNumberTable) {
        for (int i = 0; i < lineNumberTable.length; ++i) {
            if (i == lineNumberTable.length - 1 && this.methodGenHelper.isVoidReturningMethod() && InstructionHelper.isRetInstruction(lineNumberTable[i])) continue;
            this.addInstrumentation(lineNumberTable[i]);
        }
    }

    public void addInstrumentation() {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("adding instrumentation to: ");
            sb.append(this.classGenHelper.getClassGen().getClassName());
            sb.append('.');
            sb.append(this.methodGenHelper.getMethodGen().getName());
            logger.debug((Object)sb.toString());
        }
        this.addInstrumentation(this.methodGenHelper.getMethodGen().getLineNumbers());
        this.methodGenHelper.getMethodGen().setMaxStack();
        this.classGenHelper.getClassGen().replaceMethod(this.original, this.methodGenHelper.getMethodGen().getMethod());
    }

    Set getSourceLineNumbers() {
        return this.sourceLineNumbers;
    }

    Set getConditionals() {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.classGenHelper.getClassGen().getClassName());
            sb.append('.');
            sb.append(this.methodGenHelper.getMethodGen().getName());
            sb.append(" conditionals: ");
            sb.append(this.conditionals.toString());
            logger.debug((Object)sb.toString());
        }
        return this.conditionals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

