/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import put.idss.mlrules.Rule;
import put.idss.mlrules.RuleBuilder;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLRules
extends Classifier
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1L;
    public static int MINIMIZER_GRADIENT = 0;
    public static int MINIMIZER_NEWTON = 1;
    public static final Tag[] TAGS_MINIMIZER = new Tag[]{new Tag(MINIMIZER_GRADIENT, "Gradient descent"), new Tag(MINIMIZER_NEWTON, "Newton-Raphson step")};
    private boolean modelBuilt = false;
    private short[] coveredInstances = null;
    private Rule[] rules;
    private NominalToBinary ntb;
    private Instances instances;
    private int N = 0;
    private int D = 0;
    private int K = 0;
    private int nRules = 100;
    private double[] defaultRule = null;
    private double[][] f;
    private RuleBuilder ruleBuilder = null;
    private boolean resample = true;
    private double percentage = 0.5;
    private double nu = 0.5;
    private boolean useLineSearch = false;
    private int minimization = MINIMIZER_GRADIENT;
    private boolean chooseClass = true;
    private double R = 5.0;
    private double Rp = 1.0E-5;
    private Random mainRandomGenerator = null;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Krzysztof Dembczy\ufffdski and Wojciech Kot\ufffdowski and Roman S\ufffdowi\ufffdski");
        result.setValue(TechnicalInformation.Field.TITLE, "Maximum likelihood rule ensembles");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 25th International Conference on Machine Learning (ICML 2008)");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        result.setValue(TechnicalInformation.Field.PAGES, "224--231");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Helsinki, Finland");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Omnipress");
        return result;
    }

    public String globalInfo() {
        return "Maximum Likelihood Rule Ensembles (MLRules) - class for building a rule ensemble for classification via estimating the conditional class probabilities.\nRules are combined in additive way.\n\n" + this.getTechnicalInformation().toString();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public String toString() {
        if (!this.modelBuilt) {
            return "Maximum Likelihood Rule Ensembles (MLRules): No model built yet.";
        }
        StringBuffer buffer = new StringBuffer("Maximum Likelihood Rule Ensembles (MLRules)...\n\n" + this.nRules + " rules generated.\n" + "Default rule:\n" + this.printDefaultRule() + "\n\n" + "List of rules:\n\n");
        int i = 0;
        while (i < this.nRules) {
            buffer.append(String.valueOf(this.getRules()[i].toString()) + "\n");
            ++i;
        }
        return buffer.toString();
    }

    private String printDefaultRule() {
        double[] defaultRule = this.getDefaultRule();
        StringBuffer ruleString = new StringBuffer();
        int i = 0;
        while (i < defaultRule.length) {
            ruleString.append("vote for class " + this.instances.classAttribute().value(i) + " with weight " + defaultRule[i] + "\n");
            ++i;
        }
        return ruleString.toString();
    }

    public Instances getInstances() {
        return this.instances;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public double[] getDefaultRule() {
        return this.defaultRule;
    }

    public void setnRules(int nRules) {
        this.nRules = nRules;
    }

    public int getnRules() {
        return this.nRules;
    }

    public String nRulesTipText() {
        return "The total number of rules.";
    }

    public double[] getF(int position) {
        return this.f[position];
    }

    public int getD() {
        return this.D;
    }

    public int getK() {
        return this.K;
    }

    public short[] resample(double percentage) {
        short[] subSample = new short[this.N];
        int subsampleSize = (int)((double)this.N * percentage);
        Random random = new Random(this.mainRandomGenerator.nextInt());
        int[] indices = new int[this.N];
        int i = 0;
        while (i < this.N) {
            indices[i] = i;
            ++i;
        }
        i = this.N - 1;
        while (i > 0) {
            int temp = indices[i];
            int index = random.nextInt(i + 1);
            indices[i] = indices[index];
            indices[index] = temp;
            --i;
        }
        i = 0;
        while (i < subsampleSize) {
            subSample[indices[i]] = 1;
            ++i;
        }
        return subSample;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.initialize(instances);
        this.rules = new Rule[this.nRules];
        Arrays.fill(this.coveredInstances, (short)1);
        this.defaultRule = this.useLineSearch ? this.ruleBuilder.createDefaultRule() : this.ruleBuilder.createDefaultRule(this.f, this.coveredInstances);
        this.updateFunction(this.defaultRule);
        int m = 0;
        while (m < this.nRules) {
            if (this.resample) {
                this.coveredInstances = this.resample(this.getPercentage());
            } else {
                Arrays.fill(this.coveredInstances, (short)1);
            }
            this.rules[m] = this.ruleBuilder.createRule(this.f, this.coveredInstances);
            if (this.rules[m] != null) {
                this.updateFunction(this.rules[m].getDecision());
            } else {
                --m;
            }
            ++m;
        }
        this.modelBuilt = true;
    }

    private void initialize(Instances instances) throws Exception {
        this.instances = new Instances(instances);
        this.ntb = new NominalToBinary();
        this.ntb.setBinaryAttributesNominal(true);
        try {
            this.ntb.setInputFormat(this.instances);
            this.instances = Filter.useFilter((Instances)this.instances, (Filter)this.ntb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.D = this.instances.numAttributes() - 1;
        this.N = this.instances.numInstances();
        this.K = this.instances.numClasses();
        this.f = new double[this.N][this.K];
        this.instances.insertAttributeAt(new Attribute("InstanceIndex"), this.D + 1);
        int indexAttribute = this.D + 1;
        int i = 0;
        while (i < this.N) {
            this.instances.instance(i).setValue(indexAttribute, (double)i);
            ++i;
        }
        this.coveredInstances = new short[this.N];
        this.ruleBuilder = new RuleBuilder(this.nu, this.useLineSearch, this.minimization == 0, this.chooseClass, this.R, this.Rp);
        this.ruleBuilder.initialize(this.instances);
        this.mainRandomGenerator = new Random();
    }

    public void updateFunctionWhenRemoval(Rule rule) {
        int i = 0;
        while (i < this.N) {
            if (rule.classifyInstance(this.instances.instance(i)) != null) {
                int k = 0;
                while (k < this.K) {
                    double[] dArray = this.f[i];
                    int n = k;
                    dArray[n] = dArray[n] - rule.getDecision()[k];
                    ++k;
                }
            }
            ++i;
        }
    }

    public void updateFunction(double[] decision) {
        int i = 0;
        while (i < this.N) {
            if (this.coveredInstances[i] >= 0) {
                int k = 0;
                while (k < this.K) {
                    double[] dArray = this.f[i];
                    int n = k;
                    dArray[n] = dArray[n] + decision[k];
                    ++k;
                }
            }
            ++i;
        }
    }

    public double[] evaluateF(Instance instance) {
        double[] evalF = new double[this.K];
        this.ntb.input(instance);
        instance = this.ntb.output();
        int k = 0;
        while (k < this.K) {
            evalF[k] = this.defaultRule[k];
            ++k;
        }
        int m = 0;
        while (m < this.nRules) {
            double[] currentValues = this.rules[m].classifyInstance(instance);
            if (currentValues != null) {
                int k2 = 0;
                while (k2 < this.K) {
                    int n = k2;
                    evalF[n] = evalF[n] + currentValues[k2];
                    ++k2;
                }
            }
            ++m;
        }
        return evalF;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] evalF = this.evaluateF(instance);
        double[] distribution = new double[this.K];
        double total = 0.0;
        int k = 0;
        while (k < this.K) {
            distribution[k] = Math.exp(evalF[k]);
            total += distribution[k];
            ++k;
        }
        k = 0;
        while (k < this.K) {
            int n = k++;
            distribution[n] = distribution[n] / total;
        }
        return distribution;
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSet the number of rules, i.e. the ensemble size (default 100).", "M", 1, "-M <number of rules>"));
        result.addElement(new Option("\tSet the amount of shrinkage (default 0.5).", "S", 1, "-S <shrinkage>"));
        result.addElement(new Option("\tNo resampling (default resampling is on).", "R", 0, "-R"));
        result.addElement(new Option("\tSet the size of the subsample as a fraction of the training set (default 0.5).", "P", 1, "-P"));
        result.addElement(new Option("\tSet the minimization technique:\n\t\t0 = gradient deccent,\n\t\t1 = Newton-Raphson.", "Q", 1, "-Q <technique>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String stringTechnique;
        String stringNu;
        String stringM = Utils.getOption((char)'M', (String[])options);
        if (stringM.length() != 0) {
            this.nRules = Integer.parseInt(stringM);
        }
        if ((stringNu = Utils.getOption((char)'S', (String[])options)).length() != 0) {
            this.nu = Double.parseDouble(stringNu);
        }
        this.resample = Utils.getFlag((char)'R', (String[])options);
        String stringPercentage = Utils.getOption((char)'P', (String[])options);
        if (stringPercentage.length() != 0) {
            this.percentage = Double.parseDouble(stringPercentage);
        }
        if ((stringTechnique = Utils.getOption((char)'Q', (String[])options)).length() != 0) {
            this.minimization = Integer.parseInt(stringTechnique);
        }
    }

    public String[] getOptions() {
        Vector<String> results = new Vector<String>();
        results.add("-M");
        results.add("" + this.nRules);
        results.add("-S");
        results.add("" + this.nu);
        if (!this.resample) {
            results.add("-R");
        }
        results.add("-P");
        results.add("" + this.percentage);
        results.add("-Q");
        results.add("" + this.minimization);
        return results.toArray(new String[results.size()]);
    }

    public double classifyInstance(Instance instance) {
        double[] evalF = this.evaluateF(instance);
        int classIndex = 0;
        int k = 1;
        while (k < this.K) {
            if (evalF[classIndex] < evalF[k]) {
                classIndex = k;
            }
            ++k;
        }
        return classIndex;
    }

    public double[][] multipleEvaluateF(Instance instance) {
        double[][] evalsF = new double[this.nRules][this.K];
        this.ntb.input(instance);
        instance = this.ntb.output();
        int i = 0;
        while (i < this.nRules) {
            int j;
            double[] currentValues = this.rules[i].classifyInstance(instance);
            if (currentValues != null) {
                j = 0;
                while (j < this.K) {
                    evalsF[i][j] = i == 0 ? this.defaultRule[j] + currentValues[j] : evalsF[i - 1][j] + currentValues[j];
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.K) {
                    evalsF[i][j] = i == 0 ? this.defaultRule[j] : evalsF[i - 1][j];
                    ++j;
                }
            }
            ++i;
        }
        return evalsF;
    }

    public double[] multipleClassifyInstance(Instance instance) {
        double[][] values = this.multipleEvaluateF(instance);
        double[] curve = new double[this.nRules];
        int j = 0;
        while (j < this.nRules) {
            int classIndex = 0;
            int k = 1;
            while (k < this.K) {
                if (values[j][classIndex] < values[j][k]) {
                    classIndex = k;
                }
                ++k;
            }
            curve[j] = classIndex;
            ++j;
        }
        return curve;
    }

    public double computeEmpiricalRisk() {
        double empiricalRisk = 0.0;
        int i = 0;
        while (i < this.N) {
            double total = 0.0;
            int k = 0;
            while (k < this.K) {
                total += Math.exp(this.f[i][k]);
                ++k;
            }
            empiricalRisk -= this.instances.instance(i).weight() * Math.log(Math.exp(this.f[i][(int)this.instances.instance(i).classValue()]) / total);
            ++i;
        }
        return empiricalRisk / (double)this.N;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setNu(double nu) {
        this.nu = nu;
    }

    public double getNu() {
        return this.nu;
    }

    public void setResample(boolean resample) {
        this.resample = resample;
    }

    public boolean getResample() {
        return this.resample;
    }

    public static void main(String[] args) {
        MLRules.runClassifier((Classifier)new MLRules(), (String[])args);
    }

    public String nuTipText() {
        return "Shrinkage.";
    }

    public String resampleTipText() {
        return "Resampling";
    }

    public String percentageTipText() {
        return "Subsample size (as a fraction of the training set).";
    }

    public void setMinimization(SelectedTag newType) {
        if (newType.getTags() == TAGS_MINIMIZER) {
            this.minimization = newType.getSelectedTag().getID();
        }
    }

    public SelectedTag getMinimization() {
        return new SelectedTag(this.minimization, TAGS_MINIMIZER);
    }

    public String minimizationTipText() {
        return "Minimization technique.";
    }
}

