/*
 * Decompiled with CFR 0.152.
 */
package put.idss.mlrules;

import java.io.Serializable;
import java.util.Arrays;
import put.idss.mlrules.Rule;
import weka.core.Instances;

public class RuleBuilder
implements Serializable {
    static final long serialVersionUID = -1L;
    static final double EPSILON = 1.0E-8;
    public double R = 10.0;
    public double Rp = 0.01;
    protected int[][] invertedList = null;
    protected Instances instances = null;
    protected int D;
    protected int indexAttribute;
    protected int K;
    protected int N;
    protected boolean useLineSearch = false;
    protected double nu = 0.1;
    protected double[][] f = null;
    private double[][] probability = null;
    private double gradient = 0.0;
    private double hessian = 0.0;
    private int maxK = 0;
    public boolean preChosenK = false;
    private double[] gradients = null;
    private double[] hessians = null;
    private boolean useGradient = true;
    private double lineSearchMax = 4.0;
    private int lineSearchIterations = 10;
    private double lineSearchPrecision = 1.0E-4;

    public RuleBuilder(double nu, boolean useLineSearch, boolean useGradient, boolean preChosenK, double R, double Rp) {
        this.nu = nu;
        this.useLineSearch = useLineSearch;
        this.useGradient = useGradient;
        this.preChosenK = preChosenK;
        this.R = R;
        this.Rp = Rp;
    }

    public void initialize(Instances instances) {
        this.instances = instances;
        this.N = instances.numInstances();
        this.D = instances.numAttributes() - 2;
        this.K = instances.numClasses();
        this.indexAttribute = this.D + 1;
        this.invertedList = new int[this.D][this.N];
        int j = 0;
        while (j < this.D) {
            instances.sort(j);
            double[] temporaryDoubleArray = instances.attributeToDoubleArray(this.indexAttribute);
            int i = 0;
            while (i < this.N) {
                this.invertedList[j][i] = (int)temporaryDoubleArray[i];
                ++i;
            }
            ++j;
        }
        instances.sort(this.indexAttribute);
        this.probability = new double[this.N][this.K];
        this.gradients = new double[this.K];
        this.hessians = new double[this.K];
    }

    private void initializeForCut() {
        this.gradient = 0.0;
        this.hessian = this.R;
        Arrays.fill(this.gradients, 0.0);
        Arrays.fill(this.hessians, this.R);
    }

    public void initializeForRule(double[][] f, short[] coveredInstances) {
        block13: {
            int k;
            this.f = f;
            if (this.preChosenK) {
                Arrays.fill(this.gradients, 0.0);
                Arrays.fill(this.hessians, this.R);
            }
            int i = 0;
            while (i < this.N) {
                if (coveredInstances[i] >= 0) {
                    double norm = 0.0;
                    int k2 = 0;
                    while (k2 < this.K) {
                        this.probability[i][k2] = Math.exp(f[i][k2]);
                        norm += this.probability[i][k2];
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < this.K) {
                        double[] dArray = this.probability[i];
                        int n = k2;
                        dArray[n] = dArray[n] / norm;
                        if (this.preChosenK) {
                            int n2 = k2;
                            this.gradients[n2] = this.gradients[n2] - this.instances.instance(i).weight() * this.probability[i][k2];
                            int n3 = k2;
                            this.hessians[n3] = this.hessians[n3] + this.instances.instance(i).weight() * (this.Rp + this.probability[i][k2] * (1.0 - this.probability[i][k2]));
                        }
                        ++k2;
                    }
                    if (this.preChosenK) {
                        int n = (int)this.instances.instance(i).classValue();
                        this.gradients[n] = this.gradients[n] + this.instances.instance(i).weight();
                    }
                }
                ++i;
            }
            if (!this.preChosenK) break block13;
            this.maxK = 0;
            if (this.useGradient) {
                k = 1;
                while (k < this.K) {
                    if (this.gradients[k] > this.gradients[this.maxK]) {
                        this.maxK = k;
                    }
                    ++k;
                }
            } else {
                k = 1;
                while (k < this.K) {
                    if (this.gradients[k] / Math.sqrt(this.hessians[k]) > this.gradients[this.maxK] / Math.sqrt(this.hessians[this.maxK])) {
                        this.maxK = k;
                    }
                    ++k;
                }
            }
        }
    }

    public double computeCurrentEmpiricalRisk(int position, int weight) {
        if (this.preChosenK) {
            if ((int)this.instances.instance(position).classValue() == this.maxK) {
                this.gradient += this.instances.instance(position).weight() * (double)weight;
            }
            this.gradient -= this.instances.instance(position).weight() * (double)weight * this.probability[position][this.maxK];
            if (this.useGradient) {
                return -this.gradient;
            }
            this.hessian += this.instances.instance(position).weight() * (double)weight * (this.Rp + this.probability[position][this.maxK] * (1.0 - this.probability[position][this.maxK]));
            return -this.gradient * Math.abs(this.gradient) / this.hessian;
        }
        int y = (int)this.instances.instance(position).classValue();
        int k = 0;
        while (k < this.K) {
            if (y == k) {
                int n = k;
                this.gradients[n] = this.gradients[n] + this.instances.instance(position).weight() * (double)weight;
            }
            int n = k;
            this.gradients[n] = this.gradients[n] - this.instances.instance(position).weight() * (double)weight * this.probability[position][k];
            if (!this.useGradient) {
                int n2 = k;
                this.hessians[n2] = this.hessians[n2] + this.instances.instance(position).weight() * (double)weight * (this.Rp + this.probability[position][k] * (1.0 - this.probability[position][k]));
            }
            ++k;
        }
        if (this.useGradient) {
            double highest = this.gradients[0];
            int k2 = 1;
            while (k2 < this.K) {
                highest = Math.max(highest, this.gradients[k2]);
                ++k2;
            }
            return -highest;
        }
        double highest = this.gradients[0] * Math.abs(this.gradients[0]) / this.hessians[0];
        int k3 = 1;
        while (k3 < this.K) {
            highest = Math.max(highest, this.gradients[k3] * Math.abs(this.gradients[k3]) / this.hessians[k3]);
            ++k3;
        }
        return -highest;
    }

    public double[] computeDecision(short[] coveredInstances) {
        if (this.preChosenK) {
            this.hessian = this.R;
            this.gradient = 0.0;
            int i = 0;
            while (i < coveredInstances.length) {
                if (coveredInstances[i] >= 0) {
                    if ((int)this.instances.instance(i).classValue() == this.maxK) {
                        this.gradient += this.instances.instance(i).weight();
                    }
                    this.gradient -= this.instances.instance(i).weight() * this.probability[i][this.maxK];
                    this.hessian += this.instances.instance(i).weight() * (this.Rp + this.probability[i][this.maxK] * (1.0 - this.probability[i][this.maxK]));
                }
                ++i;
            }
            if (this.gradient <= 0.0) {
                return null;
            }
            double alphaNR = this.gradient / this.hessian;
            double[] decision = new double[this.K];
            Arrays.fill(decision, -alphaNR / (double)this.K);
            decision[this.maxK] = alphaNR * (double)(this.K - 1) / (double)this.K;
            return decision;
        }
        Arrays.fill(this.hessians, this.R);
        Arrays.fill(this.gradients, 0.0);
        int chosenK = 0;
        double[] origGradients = new double[this.K];
        int i = 0;
        while (i < coveredInstances.length) {
            if (coveredInstances[i] >= 0) {
                int k = 0;
                while (k < this.K) {
                    if ((int)this.instances.instance(i).classValue() == k) {
                        int n = k;
                        this.gradients[n] = this.gradients[n] + this.instances.instance(i).weight();
                        int n2 = k;
                        origGradients[n2] = origGradients[n2] + this.instances.instance(i).weight() * (double)coveredInstances[i];
                    }
                    int n = k;
                    this.gradients[n] = this.gradients[n] - this.instances.instance(i).weight() * this.probability[i][k];
                    int n3 = k;
                    this.hessians[n3] = this.hessians[n3] + this.instances.instance(i).weight() * (this.Rp + this.probability[i][k] * (1.0 - this.probability[i][k]));
                    int n4 = k;
                    origGradients[n4] = origGradients[n4] - this.instances.instance(i).weight() * (double)coveredInstances[i] * this.probability[i][k];
                    ++k;
                }
            }
            ++i;
        }
        int k = 1;
        while (k < this.K) {
            if (origGradients[k] > origGradients[chosenK]) {
                chosenK = k;
            }
            ++k;
        }
        if (this.gradients[chosenK] <= 0.0) {
            return null;
        }
        double alphaNR = this.gradients[chosenK] / this.hessians[chosenK];
        double[] decision = new double[this.K];
        Arrays.fill(decision, -alphaNR / (double)this.K);
        decision[chosenK] = alphaNR * (double)(this.K - 1) / (double)this.K;
        return decision;
    }

    public Cut findBestCut(int attribute, short[] coveredInstances) {
        Cut bestCut = new Cut(this.K);
        bestCut.position = -1;
        bestCut.exists = false;
        bestCut.empiricalRisk = 0.0;
        double tempEmpiricalRisk = 0.0;
        int cutDirection = -1;
        while (cutDirection <= 1) {
            this.initializeForCut();
            int currentPosition = 0;
            int i = cutDirection == 1 ? this.N - 1 : 0;
            while (cutDirection == 1 && i >= 0 || cutDirection != 1 && i < this.N) {
                currentPosition = this.invertedList[attribute][i];
                if (coveredInstances[currentPosition] > 0 && !this.instances.instance(currentPosition).isMissing(attribute)) break;
                if (cutDirection == 1) {
                    --i;
                    continue;
                }
                ++i;
            }
            double currentValue = this.instances.instance(currentPosition).value(attribute);
            while (cutDirection == 1 && i >= 0 || cutDirection != 1 && i < this.instances.numInstances()) {
                int nextPosition = this.invertedList[attribute][i];
                if (coveredInstances[nextPosition] > 0 && !this.instances.instance(nextPosition).isMissing(attribute)) {
                    double value = this.instances.instance(nextPosition).value(attribute);
                    if (currentValue != value && tempEmpiricalRisk < bestCut.empiricalRisk + 1.0E-8) {
                        bestCut.saveCut(cutDirection, currentValue, value, tempEmpiricalRisk);
                    }
                    tempEmpiricalRisk = this.computeCurrentEmpiricalRisk(nextPosition, coveredInstances[nextPosition]);
                    currentValue = this.instances.instance(nextPosition).value(attribute);
                }
                if (cutDirection == 1) {
                    --i;
                    continue;
                }
                ++i;
            }
            cutDirection += 2;
        }
        return bestCut;
    }

    public short[] markCoveredInstances(int bestAttribute, short[] coveredInstances, Cut cut) {
        int i = 0;
        while (i < this.N) {
            if (coveredInstances[i] != -1) {
                if (this.instances.instance(i).isMissing(bestAttribute)) {
                    coveredInstances[i] = -1;
                } else {
                    double value = this.instances.instance(i).value(bestAttribute);
                    if (value < cut.value && cut.direction == 1 || value > cut.value && cut.direction == -1) {
                        coveredInstances[i] = -1;
                    }
                }
            }
            ++i;
        }
        return coveredInstances;
    }

    private double computeRuleGradient(double[][] f, short[] coveredInstances, double point) {
        int size = 0;
        double gradient = 0.0;
        int i = 0;
        while (i < this.N) {
            if (coveredInstances[i] >= 0) {
                ++size;
                this.probability[i][this.maxK] = Math.exp(f[i][this.maxK] + point);
                double norm = this.probability[i][this.maxK];
                int k = 0;
                while (k < this.K) {
                    if (k != this.maxK) {
                        this.probability[i][k] = Math.exp(f[i][k]);
                        norm += this.probability[i][k];
                    }
                    ++k;
                }
                if ((int)this.instances.instance(i).classValue() == this.maxK) {
                    gradient += this.instances.instance(i).weight();
                }
                gradient -= this.instances.instance(i).weight() * this.probability[i][this.maxK] / norm;
            }
            ++i;
        }
        return gradient / (double)size;
    }

    public double[] getLineSearchDecision(double[][] f, short[] coveredInstances) {
        double gradient = this.computeRuleGradient(f, coveredInstances, this.lineSearchMax);
        if (gradient >= 0.0) {
            double[] decision = new double[this.K];
            Arrays.fill(decision, -this.lineSearchMax / (double)this.K);
            decision[this.maxK] = this.lineSearchMax * (double)(this.K - 1) / (double)this.K;
            return decision;
        }
        return this.getLineSearchDecision(f, coveredInstances, 0.0, this.lineSearchMax, 1);
    }

    private double[] getLineSearchDecision(double[][] f, short[] coveredInstances, double left, double right, int depth) {
        double middle = (left + right) / 2.0;
        double gradient = this.computeRuleGradient(f, coveredInstances, middle);
        if (Math.abs(gradient) < this.lineSearchPrecision || depth == this.lineSearchIterations) {
            double[] decision = new double[this.K];
            Arrays.fill(decision, -middle / (double)this.K);
            decision[this.maxK] = middle * (double)(this.K - 1) / (double)this.K;
            return decision;
        }
        if (gradient > 0.0) {
            return this.getLineSearchDecision(f, coveredInstances, middle, right, depth + 1);
        }
        return this.getLineSearchDecision(f, coveredInstances, left, middle, depth + 1);
    }

    public Rule createRule(double[][] f, short[] coveredInstances) {
        this.initializeForRule(f, coveredInstances);
        Rule rule = new Rule(this.instances.classAttribute());
        Cut bestCut = new Cut(this.K);
        bestCut.empiricalRisk = 0.0;
        boolean creating = true;
        while (creating) {
            int bestAttribute = -1;
            int j = 0;
            while (j < this.D) {
                Cut cut = this.findBestCut(j, coveredInstances);
                if (cut.empiricalRisk < bestCut.empiricalRisk - 1.0E-8) {
                    bestCut.copy(cut);
                    bestAttribute = j;
                }
                ++j;
            }
            if (bestAttribute == -1 || !bestCut.exists) {
                creating = false;
                continue;
            }
            rule.addSelector(bestAttribute, bestCut.value, bestCut.direction, this.instances.attribute(bestAttribute));
            coveredInstances = this.markCoveredInstances(bestAttribute, coveredInstances, bestCut);
        }
        if (bestCut.exists) {
            double[] decision = null;
            decision = this.useLineSearch ? this.getLineSearchDecision(f, coveredInstances) : this.computeDecision(coveredInstances);
            if (decision == null) {
                return null;
            }
            int i = 0;
            while (i < decision.length) {
                int n = i++;
                decision[n] = decision[n] * this.nu;
            }
            rule.setDecision(decision);
            return rule;
        }
        return null;
    }

    public double[] createDefaultRule(double[][] f, short[] coveredInstances) {
        this.initializeForRule(f, coveredInstances);
        double[] decision = this.computeDecision(coveredInstances);
        int i = 0;
        while (i < decision.length) {
            int n = i++;
            decision[n] = decision[n] * this.nu;
        }
        return decision;
    }

    public double[] createDefaultRule() {
        double[] priors = new double[this.K];
        int i = 0;
        while (i < this.N) {
            int n = (int)this.instances.instance(i).classValue();
            priors[n] = priors[n] + 1.0;
            ++i;
        }
        int emptyClasses = 0;
        int k = 0;
        while (k < this.K) {
            int n = k;
            priors[n] = priors[n] / (double)this.N;
            if (priors[k] == 0.0) {
                ++emptyClasses;
            }
            ++k;
        }
        double logPriors = 0.0;
        int k2 = 0;
        while (k2 < this.K) {
            if (priors[k2] != 0.0) {
                logPriors += Math.log(priors[k2]);
            }
            ++k2;
        }
        double[] decision = new double[this.K];
        Arrays.fill(decision, -(logPriors /= (double)(this.K - emptyClasses)));
        int k3 = 0;
        while (k3 < this.K) {
            if (priors[k3] != 0.0) {
                int n = k3;
                decision[n] = decision[n] + Math.log(priors[k3]);
            } else {
                decision[k3] = 0.0;
            }
            ++k3;
        }
        return decision;
    }

    protected final class Cut {
        public double[] decision = null;
        public int position = -1;
        public int direction = 0;
        public double value = 0.0;
        public double empiricalRisk = 0.0;
        public boolean exists = false;

        Cut(int K) {
            this.decision = new double[K];
        }

        Cut(Cut cut) {
            this.decision = new double[cut.decision.length];
            this.copy(cut);
        }

        void copy(Cut cut) {
            int i = 0;
            while (i < this.decision.length) {
                this.decision[i] = cut.decision[i];
                ++i;
            }
            this.position = cut.position;
            this.direction = cut.direction;
            this.value = cut.value;
            this.exists = cut.exists;
            this.empiricalRisk = cut.empiricalRisk;
        }

        public void saveCut(int direction, double currentValue, double value, double tempEmpiricalRisk) {
            this.direction = direction;
            this.value = (currentValue + value) / 2.0;
            this.empiricalRisk = tempEmpiricalRisk;
            this.exists = true;
        }
    }
}

